/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.common;

import com.ibm.urbancode.zos.deploy.xml.utils.ContainerType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ManifestXml {
    private static final String CONTAINER_TAG = "container";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String NAME_ATTRIBUTE = "name";
    private boolean hasGenericArtifact;
    private final Set<String> hfsContainers = new HashSet<String>();
    private final Set<String> datasetContainers = new HashSet<String>();

    private ManifestXml() {
    }

    protected static ManifestXml generateContainerInfoByType(String manifestFilePath, String encoding) throws XMLStreamException, IOException {
        ManifestXml manifestXml = new ManifestXml();
        try (InputStream manifestInputStream = Files.newInputStream(Paths.get(manifestFilePath, new String[0]), new OpenOption[0]);){
            manifestXml.readXml(manifestInputStream, encoding);
        }
        return manifestXml;
    }

    public static ManifestXml generateContainerInfoByType(String manifestFilePath) throws XMLStreamException, IOException {
        return ManifestXml.generateContainerInfoByType(manifestFilePath, "CP037");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readXml(InputStream manifestInputStream, String encoding) throws XMLStreamException {
        try (XMLStreamReader xmlStreamReader = null;){
            XMLInputFactory inputFactory = XMLInputFactory.newFactory();
            xmlStreamReader = inputFactory.createXMLStreamReader(manifestInputStream, encoding);
            while (xmlStreamReader.hasNext()) {
                if (xmlStreamReader.next() != 1) continue;
                this.processStartElement(xmlStreamReader);
            }
        }
    }

    private void processStartElement(XMLStreamReader xmlStreamReader) {
        String tagName = xmlStreamReader.getName().getLocalPart();
        if (tagName.equalsIgnoreCase(CONTAINER_TAG)) {
            this.processContainerNode(xmlStreamReader);
        }
    }

    private void processContainerNode(XMLStreamReader xmlStreamReader) {
        String name = xmlStreamReader.getAttributeValue(null, NAME_ATTRIBUTE);
        String type = xmlStreamReader.getAttributeValue(null, TYPE_ATTRIBUTE);
        ContainerType containerType = ContainerType.valueOf((String)type.toUpperCase());
        switch (containerType) {
            case PDS: 
            case SEQUENTIAL: {
                this.datasetContainers.add(name);
                break;
            }
            case DIRECTORY: {
                this.addToHfsContainers(name);
                break;
            }
            case GENERIC: {
                this.hasGenericArtifact = true;
            }
        }
    }

    private void addToHfsContainers(String containerName) {
        if (containerName.startsWith(File.separator)) {
            this.hfsContainers.add(containerName);
        } else {
            this.hfsContainers.add(File.separator + containerName);
        }
    }

    public boolean hasDataset() {
        return !this.datasetContainers.isEmpty();
    }

    public boolean hasHFSFile() {
        return !this.hfsContainers.isEmpty();
    }

    public boolean hasOnlyGenericArtifacts() {
        return this.hasGenericArtifact && !this.hasDataset() && !this.hasHFSFile();
    }

    public Set<String> getAllDeployHFSFiles() {
        return this.hfsContainers;
    }

    public Set<String> getAllDeployDatasets() {
        return this.datasetContainers;
    }
}

