/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.toolkit.manifest;

import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.ibm.urbancode.zos.deploy.xml.utils.ContainerResource;
import com.ibm.urbancode.zos.deploy.xml.utils.ManifestContainer;
import com.ibm.urbancode.zos.deploy.xml.utils.parsers.ContainerMapperParser;
import com.ibm.urbancode.zos.deploy.xml.utils.parsers.PackageManifestParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;

public class PDSChecker {
    private static final String OPEN_PARENTHESIS = "(";
    private static final String CLOSED_PARENTHESIS = ")";
    private final String manifestFilePath;
    private final String containerMapperFilePath;

    public PDSChecker(String componentVersionWorkingDir) {
        this.manifestFilePath = componentVersionWorkingDir + File.separator + "packageManifest_deploy.xml";
        this.containerMapperFilePath = componentVersionWorkingDir + File.separator + "containerMapper.xml";
    }

    public List<String> getListOfExistingPdsMembers() throws IOException, XMLStreamException {
        Map<String, String> datasetMapping = this.getDatasetMapper();
        Set<ManifestContainer> manifestContainers = this.getManifestContainers();
        ArrayList<String> existingMembers = new ArrayList<String>();
        for (ManifestContainer manifestContainer : manifestContainers) {
            if (!manifestContainer.isPds()) continue;
            String targetDataset = datasetMapping.get(manifestContainer.getSourceContainerName());
            for (ContainerResource member : manifestContainer.getContainerResources()) {
                String pdsMember = targetDataset + OPEN_PARENTHESIS + member.getName() + CLOSED_PARENTHESIS;
                if (!DatasetHelper.isDatasetExist(pdsMember)) continue;
                existingMembers.add(pdsMember);
            }
        }
        return existingMembers;
    }

    private Set<ManifestContainer> getManifestContainers() throws IOException, XMLStreamException {
        Set manifestContainers;
        try (InputStream packageManifestStream = Files.newInputStream(Paths.get(this.manifestFilePath, new String[0]), new OpenOption[0]);){
            manifestContainers = new PackageManifestParser(packageManifestStream).parse();
        }
        return manifestContainers;
    }

    private Map<String, String> getDatasetMapper() throws IOException, XMLStreamException {
        Map datasetMapping;
        try (InputStream containerMapperStream = Files.newInputStream(Paths.get(this.containerMapperFilePath, new String[0]), new OpenOption[0]);){
            datasetMapping = new ContainerMapperParser(containerMapperStream).parse();
        }
        return datasetMapping;
    }
}

