/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.common.util;

import com.ibm.urbancode.zos.common.util.SystemEnv;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.ibm.urbancode.zos.dataset.util.RexxFileToDatasetConvertor;
import com.ibm.urbancode.zos.dataset.util.TempDsnNameHelper;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayExecutor;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayXMLInput;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayXMLResponse;
import com.ibm.urbancode.zos.ispf.gateway.common.ServiceType;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class Buzdepv2Executor {
    private static final String TSO_EX = "TSO EX";
    private static final String SPACE = " ";
    private static final String SINGLE_QUOTE = "'";
    private final String actionDsn;
    private final String dsnPrefix;
    private final String ispfGatewayBinariesPath;

    public Buzdepv2Executor(String actionDsn, String dsnPrefix, String ispfGatewayBinariesPath) {
        this.actionDsn = actionDsn;
        this.dsnPrefix = dsnPrefix;
        this.ispfGatewayBinariesPath = ispfGatewayBinariesPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IspfGatewayXMLResponse execute() throws Exception {
        IspfGatewayXMLResponse ispfGatewayXMLResponse;
        String rexxDataset = TempDsnNameHelper.getRexxDsnName(this.dsnPrefix);
        try {
            this.copyRexxProgramToDataset(rexxDataset);
            String command = this.getCommandForIspfGateway(rexxDataset);
            IspfGatewayXMLInput ispfGatewayXMLInput = new IspfGatewayXMLInput(ServiceType.ISPF, command);
            IspfGatewayExecutor ispfGatewayExecutor = new IspfGatewayExecutor(this.ispfGatewayBinariesPath, ispfGatewayXMLInput);
            ispfGatewayExecutor.setEnvironmentVars(this.getEnvironmentVariables());
            ispfGatewayXMLResponse = ispfGatewayExecutor.execute();
        }
        finally {
            DatasetHelper.deleteDataset(rexxDataset);
        }
        return ispfGatewayXMLResponse;
    }

    private void copyRexxProgramToDataset(String rexxDataset) throws IOException {
        String rexxFilePath = SystemEnv.getPluginHome() + File.separator + "BUZDEPV2.rexx";
        new RexxFileToDatasetConvertor(rexxFilePath, rexxDataset).convert();
    }

    private String getCommandForIspfGateway(String tempRexxDataset) {
        return "TSO EX '" + tempRexxDataset + SINGLE_QUOTE + SPACE + SINGLE_QUOTE + this.actionDsn + SINGLE_QUOTE;
    }

    private Map<String, String> getEnvironmentVariables() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("ISPF_LOG_DIR", SystemEnv.getBuzToolkitHome() + "/var/log/ispf");
        env.put("PATH", SystemEnv.getBuzToolkitHome() + "/conf/toolkit" + File.pathSeparator + this.ispfGatewayBinariesPath + File.pathSeparator + this.getCurrentEnvPath());
        env.put("CGI_ISPPREF", this.dsnPrefix);
        return env;
    }

    private String getCurrentEnvPath() {
        return System.getenv("PATH") == null ? "" : System.getenv("PATH");
    }
}

