/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.dataset.util;

import com.ibm.jzos.RecordWriter;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZUtil;
import com.ibm.urbancode.zos.dataset.util.ActionRecord;
import com.ibm.urbancode.zos.dataset.util.DatasetLreclException;
import java.io.IOException;
import java.util.List;

public class ActionDatasetBuilder {
    public static final int DATASET_LRECL = 144;
    private final List<ActionRecord> actionRecords;
    private final String actionDataset;

    public ActionDatasetBuilder(List<ActionRecord> actionRecords, String actionDataset) {
        this.actionRecords = actionRecords;
        this.actionDataset = actionDataset;
    }

    public void build() throws IOException {
        this.createActionDataset();
        this.loadRecordsIntoActionDataset();
    }

    private void createActionDataset() {
        String fullyQualifiedDsn = ZFile.getFullyQualifiedDSN((String)this.actionDataset, (boolean)true);
        String targetDD = ZFile.allocDummyDDName();
        ZFile.bpxwdyn((String)("alloc fi(" + targetDD + ") da(" + fullyQualifiedDsn + ") reuse new dsorg(ps) lrecl(" + 144 + ") recfm(f,b) CYL space(1,1) blksize(" + 1440 + " catalog msg(wtp)"));
        ZFile.bpxwdyn((String)("free fi(" + targetDD + ") msg(wtp)"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRecordsIntoActionDataset() throws IOException {
        RecordWriter writer = RecordWriter.newWriter((String)ZFile.getSlashSlashQuotedDSN((String)this.actionDataset, (boolean)true), (int)1);
        try {
            this.writeHeaderRecord(writer);
            for (ActionRecord actionRecord : this.actionRecords) {
                this.writeRecord(writer, actionRecord.getRecord());
            }
        }
        finally {
            writer.close();
            writer.flush();
        }
    }

    private void writeHeaderRecord(RecordWriter writer) throws IOException {
        this.writeRecord(writer, ActionRecord.getHeader());
    }

    private void writeRecord(RecordWriter writer, String record) throws IOException {
        if (record.length() > 144) {
            throw new DatasetLreclException("Action record exceeds record length 144");
        }
        String formattedLine = String.format("%-144s", record);
        byte[] bytes = formattedLine.getBytes(ZUtil.getDefaultPlatformEncoding());
        writer.write(bytes, 0, bytes.length);
    }
}

