/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.inputs;

import com.ibm.urbancode.zos.common.util.FileHelper;
import com.urbancode.air.plugin.inputs.DirectoryNotFoundException;
import com.urbancode.air.plugin.inputs.HfsMappingHelper;
import com.urbancode.air.plugin.inputs.InputsValidator;
import com.urbancode.air.plugin.inputs.InvalidInputException;
import java.util.Properties;

public class RollbackPackageInputs {
    public static final String RESOURCE_ID = "resourceId";
    public static final String ENVIRONMENT_ID = "environmentId";
    public static final String VERSION_ID = "versionId";
    public static final String COMPONENT_ID = "componentId";
    public static final String COMPONENT_NAME = "componentName";
    public static final String VERSION_NAME = "versionName";
    public static final String VERSION_TYPE = "versionType";
    public static final String DEPLOY_BASE_PATH = "deployBasePath";
    public static final String TEMP_DSN_PREFIX = "tempDsnPrefix";
    public static final String PREVENT_RISKY_ROLLBACK = "preventRiskyRollback";
    public static final String DRY_RUN_FOR_RISKY = "dryRunForRisky";
    public static final String PRINT_LOGS = "printLogs";
    public static final String CHECK_ACCESS = "checkAccess";
    public static final String DEL_BACK_UP_FILES = "delBackUpFiles";
    public static final String HFS_TARGET_DIR = "hfsTargetDir";
    private final String resourceId;
    private final String environmentId;
    private final String versionId;
    private final String componentId;
    private final String componentName;
    private final String versionName;
    private final String versionType;
    private final String deployBasePath;
    private final String tempDsnPrefix;
    private final boolean isPreventRiskyRollbackEnabled;
    private final boolean isPrintLogsEnabled;
    private final boolean isDryRunEnabled;
    private final boolean isCheckAccessEnabled;
    private final boolean isDeleteBackupFilesEnabled;
    private final String hfsMapping;

    public RollbackPackageInputs(Properties inputProperties) {
        this.resourceId = inputProperties.getProperty(RESOURCE_ID).trim();
        this.environmentId = inputProperties.getProperty(ENVIRONMENT_ID).trim();
        this.versionId = inputProperties.getProperty(VERSION_ID).trim();
        this.componentId = inputProperties.getProperty(COMPONENT_ID).trim();
        this.componentName = inputProperties.getProperty(COMPONENT_NAME).trim();
        this.versionName = inputProperties.getProperty(VERSION_NAME).trim();
        this.versionType = inputProperties.getProperty(VERSION_TYPE).trim();
        this.deployBasePath = inputProperties.getProperty(DEPLOY_BASE_PATH).trim();
        this.tempDsnPrefix = inputProperties.getProperty(TEMP_DSN_PREFIX).trim();
        this.hfsMapping = HfsMappingHelper.determineMapping(inputProperties.getProperty(HFS_TARGET_DIR).trim());
        this.isPreventRiskyRollbackEnabled = Boolean.parseBoolean(inputProperties.getProperty(PREVENT_RISKY_ROLLBACK).trim());
        this.isDryRunEnabled = Boolean.parseBoolean(inputProperties.getProperty(DRY_RUN_FOR_RISKY).trim());
        this.isPrintLogsEnabled = Boolean.parseBoolean(inputProperties.getProperty(PRINT_LOGS).trim());
        this.isCheckAccessEnabled = Boolean.parseBoolean(inputProperties.getProperty(CHECK_ACCESS).trim());
        this.isDeleteBackupFilesEnabled = Boolean.parseBoolean(inputProperties.getProperty(DEL_BACK_UP_FILES).trim());
    }

    public void validateInputs() {
        InputsValidator.checkIfEmpty(this.resourceId, "Resource Id");
        InputsValidator.checkIfEmpty(this.environmentId, "Environment Id");
        InputsValidator.checkIfEmpty(this.versionId, "Version Id");
        InputsValidator.checkIfEmpty(this.componentId, "Component Id");
        InputsValidator.checkIfEmpty(this.componentName, "Component Name");
        InputsValidator.checkIfEmpty(this.versionName, "Version Name");
        this.validateVersionType();
        this.validateDeployBasePath();
    }

    private void validateDeployBasePath() {
        InputsValidator.checkIfEmpty(this.deployBasePath, "Deploy Base Path");
        if (FileHelper.isDirectoryNotExist(this.deployBasePath)) {
            throw new DirectoryNotFoundException(" [Error] Deploy Base Path " + this.deployBasePath + " does not exist.");
        }
    }

    private void validateVersionType() {
        InputsValidator.checkIfEmpty(this.versionType, "Version Type");
        if (this.versionTypeIsNotFull() && this.versionTypeIsNotIncremental()) {
            throw new InvalidInputException("Invalid version type - " + this.versionType + ". Version Type must be either " + "FULL" + " or " + "INCREMENTAL");
        }
    }

    private boolean versionTypeIsNotIncremental() {
        return !this.versionType.equalsIgnoreCase("INCREMENTAL");
    }

    private boolean versionTypeIsNotFull() {
        return !this.versionType.equalsIgnoreCase("FULL");
    }

    public boolean isVersionTypeFull() {
        return "FULL".equalsIgnoreCase(this.versionType);
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getDeployBasePath() {
        return this.deployBasePath;
    }

    public String getTempDsnPrefix() {
        return this.tempDsnPrefix;
    }

    public boolean isPreventRiskyRollbackEnabled() {
        return this.isPreventRiskyRollbackEnabled;
    }

    public boolean isPrintLogsEnabled() {
        return this.isPrintLogsEnabled;
    }

    public boolean isDryRunEnabled() {
        return this.isDryRunEnabled;
    }

    public boolean isCheckAccessEnabled() {
        return this.isCheckAccessEnabled;
    }

    public boolean isDeleteBackupFilesEnabled() {
        return this.isDeleteBackupFilesEnabled;
    }

    public String getHfsMapping() {
        return this.hfsMapping;
    }
}

