/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.xml.utils.parsers;

import com.ibm.urbancode.zos.deploy.xml.utils.parsers.XmlHelper;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ContainerMapperParser {
    private static final String MAP_NODE_NAME = "map";
    private static final String SOURCE_CONTAINER_NODE_NAME = "sourceContainer";
    private static final String TARGET_CONTAINER_NODE_NAME = "targetContainer";
    private static final String NAME_ATTRIBUTE = "name";
    private final InputStream containerMapperInputStream;
    private final String encoding;
    private final Map<String, String> rulerMapper = new HashMap<String, String>();
    String currentSourceName = null;
    String currentTargetName = null;

    protected ContainerMapperParser(InputStream containerMapperInputStream, String encoding) {
        this.containerMapperInputStream = containerMapperInputStream;
        this.encoding = encoding;
    }

    public ContainerMapperParser(InputStream containerMapperInputStream) {
        this(containerMapperInputStream, "CP037");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> parse() throws XMLStreamException {
        try (XMLStreamReader xmlStreamReader = null;){
            XMLInputFactory inputFactory = XMLInputFactory.newFactory();
            xmlStreamReader = inputFactory.createXMLStreamReader(this.containerMapperInputStream, this.encoding);
            while (xmlStreamReader.hasNext()) {
                int next = xmlStreamReader.next();
                if (next == 1) {
                    this.processStartElement(xmlStreamReader);
                    continue;
                }
                if (next != 2) continue;
                this.processEndElement(xmlStreamReader);
            }
        }
        return this.rulerMapper;
    }

    private void processStartElement(XMLStreamReader xmlStreamReader) {
        String tagName = xmlStreamReader.getName().getLocalPart().trim();
        if (tagName.equalsIgnoreCase(SOURCE_CONTAINER_NODE_NAME)) {
            this.currentSourceName = XmlHelper.getAttributeValue(xmlStreamReader, NAME_ATTRIBUTE);
        } else if (tagName.equalsIgnoreCase(TARGET_CONTAINER_NODE_NAME)) {
            this.currentTargetName = XmlHelper.getAttributeValue(xmlStreamReader, NAME_ATTRIBUTE);
        }
    }

    private void processEndElement(XMLStreamReader xmlStreamReader) {
        String tagName = xmlStreamReader.getName().getLocalPart().trim();
        if (tagName.equalsIgnoreCase(MAP_NODE_NAME)) {
            this.rulerMapper.put(this.currentSourceName, this.currentTargetName);
            this.currentSourceName = null;
            this.currentTargetName = null;
        }
    }
}

