/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.xml.utils.parsers;

import com.ibm.urbancode.zos.deploy.xml.utils.ContainerResource;
import com.ibm.urbancode.zos.deploy.xml.utils.ContainerType;
import com.ibm.urbancode.zos.deploy.xml.utils.Input;
import com.ibm.urbancode.zos.deploy.xml.utils.ManifestContainer;
import com.ibm.urbancode.zos.deploy.xml.utils.parsers.XmlHelper;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class PackageManifestParser {
    private static final String DELETED_SUFFIX = "_DELETE";
    private final Map<String, ManifestContainer> deployedDatasetMap = new LinkedHashMap<String, ManifestContainer>();
    private ManifestContainer container = null;
    private String containerDeployType = null;
    private ContainerResource containerResource = null;
    private boolean isDeleted = false;
    private final String encoding;
    private final InputStream packageManifestInputStream;

    protected PackageManifestParser(InputStream packageManifestInputStream, String encoding) {
        this.packageManifestInputStream = packageManifestInputStream;
        this.encoding = encoding;
    }

    public PackageManifestParser(InputStream packageManifestInputStream) {
        this(packageManifestInputStream, "CP037");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ManifestContainer> parse() throws XMLStreamException {
        try (XMLStreamReader xmlStreamReader = null;){
            XMLInputFactory inputFactory = XMLInputFactory.newFactory();
            xmlStreamReader = inputFactory.createXMLStreamReader(this.packageManifestInputStream, this.encoding);
            while (xmlStreamReader.hasNext()) {
                int next = xmlStreamReader.next();
                if (next == 1) {
                    this.processStartElement(xmlStreamReader);
                    continue;
                }
                if (next != 2) continue;
                this.processEndElement(xmlStreamReader);
            }
        }
        return new LinkedHashSet<ManifestContainer>(this.deployedDatasetMap.values());
    }

    private void processStartElement(XMLStreamReader xmlStreamReader) {
        String tagName = xmlStreamReader.getName().getLocalPart().trim();
        if (tagName.equalsIgnoreCase("deleted")) {
            this.isDeleted = true;
        } else if (tagName.equalsIgnoreCase("container")) {
            this.processContainerTag(xmlStreamReader);
        } else if (tagName.equalsIgnoreCase("resource") && this.container != null) {
            this.processResourceTag(xmlStreamReader);
        } else if (tagName.equalsIgnoreCase("property")) {
            this.processPropertyTag(xmlStreamReader);
        } else if (tagName.equalsIgnoreCase("inputs")) {
            this.processInputsTag(xmlStreamReader);
        } else if (tagName.equalsIgnoreCase("input")) {
            this.processInputTag(xmlStreamReader);
        }
    }

    private void processContainerTag(XMLStreamReader xmlStreamReader) {
        String containerNameKey;
        String containerName = XmlHelper.getAttributeValue(xmlStreamReader, "name");
        String string = containerNameKey = this.isDeleted ? containerName + DELETED_SUFFIX : containerName;
        if (this.deployedDatasetMap.containsKey(containerNameKey)) {
            this.container = this.deployedDatasetMap.get(containerNameKey);
        } else {
            this.containerDeployType = XmlHelper.getAttributeValue(xmlStreamReader, "deployType");
            String containerType = XmlHelper.getAttributeValue(xmlStreamReader, "type").toUpperCase();
            this.container = new ManifestContainer(containerName, ContainerType.valueOf(containerType));
            this.container.setDeployType(this.containerDeployType);
            if (this.isDeleted) {
                this.container.setDeleted();
            }
            this.deployedDatasetMap.put(containerNameKey, this.container);
        }
    }

    private void processResourceTag(XMLStreamReader xmlStreamReader) {
        String memberDeployType = XmlHelper.getAttributeValue(xmlStreamReader, "deployType");
        if (null == memberDeployType || memberDeployType.isEmpty()) {
            memberDeployType = this.containerDeployType;
        }
        String memberName = XmlHelper.getAttributeValue(xmlStreamReader, "name");
        String memberType = XmlHelper.getAttributeValue(xmlStreamReader, "type");
        this.containerResource = new ContainerResource(memberName);
        this.containerResource.setType(memberType);
        this.containerResource.setDeployType(memberDeployType);
        this.container.addContainerResource(this.containerResource);
    }

    private void processPropertyTag(XMLStreamReader xmlStreamReader) {
        String propertyName = XmlHelper.getAttributeValue(xmlStreamReader, "name");
        String propertyValue = XmlHelper.getAttributeValue(xmlStreamReader, "value");
        if (this.containerResource != null) {
            this.containerResource.addCustomerProperty(propertyName, propertyValue);
        } else if (this.container != null) {
            this.container.addCustomerProperty(propertyName, propertyValue);
        }
    }

    private void processInputsTag(XMLStreamReader xmlStreamReader) {
        String propertyUrl = XmlHelper.getAttributeValue(xmlStreamReader, "url");
        if (this.containerResource != null) {
            this.containerResource.getInputs().setUrl(propertyUrl);
        } else if (this.container != null && this.container.isSequential()) {
            this.container.getInputs().setUrl(propertyUrl);
        }
    }

    private void processInputTag(XMLStreamReader xmlStreamReader) {
        Input input = new Input(XmlHelper.getAttributeValue(xmlStreamReader, "name"));
        input.setVersion(XmlHelper.getAttributeValue(xmlStreamReader, "version"));
        input.setUrl(XmlHelper.getAttributeValue(xmlStreamReader, "url"));
        input.setCompileType(XmlHelper.getAttributeValue(xmlStreamReader, "compileType"));
        if (this.containerResource != null) {
            this.containerResource.getInputs().addInput(input);
        } else if (this.container != null && this.container.isSequential()) {
            this.container.getInputs().addInput(input);
        }
    }

    private void processEndElement(XMLStreamReader xmlStreamReader) {
        String tagName = xmlStreamReader.getName().getLocalPart().trim();
        if (tagName.equalsIgnoreCase("deleted")) {
            this.isDeleted = false;
        } else if (tagName.equalsIgnoreCase("container")) {
            this.container = null;
            this.containerDeployType = null;
        } else if (tagName.equalsIgnoreCase("resource")) {
            this.containerResource = null;
        }
    }
}

