/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.xml.utils.parsers;

import com.ibm.urbancode.zos.deploy.xml.utils.ContainerResource;
import com.ibm.urbancode.zos.deploy.xml.utils.ContainerType;
import com.ibm.urbancode.zos.deploy.xml.utils.CopyType;
import com.ibm.urbancode.zos.deploy.xml.utils.Input;
import com.ibm.urbancode.zos.deploy.xml.utils.Inputs;
import com.ibm.urbancode.zos.deploy.xml.utils.ManifestContainer;
import com.ibm.urbancode.zos.deploy.xml.utils.parsers.ContainerMap;
import com.ibm.urbancode.zos.deploy.xml.utils.parsers.TargetDatasetUpdater;
import com.ibm.urbancode.zos.deploy.xml.utils.parsers.XmlHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class PackageManifest {
    private static final String V_2_0 = "v2_0";
    private final List<ManifestContainer> containers = new ArrayList<ManifestContainer>();
    private ManifestContainer container = null;
    private String containerDeployType = null;
    private ContainerResource containerResource = null;
    private boolean isDeleted = false;
    private Boolean hasDataset = null;
    private Boolean hasHFSFile = null;
    private Boolean hasGenericArtifact = null;
    private String manifestVersion;

    public static PackageManifest from(String manifestFilePath, String mvsContainerMappingsFilePath) throws XMLStreamException, IOException {
        PackageManifest manifest = PackageManifest.from(manifestFilePath);
        ContainerMap containerMap = ContainerMap.from(mvsContainerMappingsFilePath);
        TargetDatasetUpdater.update(manifest, containerMap);
        return manifest;
    }

    public static PackageManifest from(String manifestFilePath) throws XMLStreamException, IOException {
        PackageManifest packageManifest = new PackageManifest();
        try (InputStream inputStream = Files.newInputStream(Paths.get(manifestFilePath, new String[0]), new OpenOption[0]);){
            packageManifest.parse(inputStream);
        }
        return packageManifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(InputStream inputStream) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newFactory();
        try (XMLStreamReader xmlStreamReader = null;){
            xmlStreamReader = inputFactory.createXMLStreamReader(inputStream, XmlHelper.getFileEncoding());
            while (xmlStreamReader.hasNext()) {
                int next = xmlStreamReader.next();
                if (next == 1) {
                    this.processStartElement(xmlStreamReader);
                    continue;
                }
                if (next != 2) continue;
                this.processEndElement(xmlStreamReader);
            }
        }
    }

    private void processStartElement(XMLStreamReader xmlStreamReader) {
        String tagName = xmlStreamReader.getLocalName().trim();
        if (tagName.equalsIgnoreCase("manifest")) {
            this.manifestVersion = XmlHelper.getAttributeValue(xmlStreamReader, "version");
        } else if (tagName.equalsIgnoreCase("deleted")) {
            this.isDeleted = true;
        } else if (tagName.equalsIgnoreCase("container")) {
            this.processContainerTag(xmlStreamReader);
        } else if (tagName.equalsIgnoreCase("resource") && this.container != null) {
            this.processResourceTag(xmlStreamReader);
        } else if (tagName.equalsIgnoreCase("property")) {
            this.processPropertyTag(xmlStreamReader);
        } else if (tagName.equalsIgnoreCase("inputs")) {
            this.processInputsTag(xmlStreamReader);
        } else if (tagName.equalsIgnoreCase("input")) {
            this.processInputTag(xmlStreamReader);
        }
    }

    private void processContainerTag(XMLStreamReader xmlStreamReader) {
        String containerName = XmlHelper.getAttributeValue(xmlStreamReader, "name");
        this.containerDeployType = XmlHelper.getAttributeValue(xmlStreamReader, "deployType");
        ContainerType containerType = this.getContainerType(xmlStreamReader, containerName);
        this.container = new ManifestContainer(containerName, containerType);
        this.container.setDeployType(this.containerDeployType);
        String copyType = XmlHelper.getAttributeValue(xmlStreamReader, "copyType");
        if (!this.isNullOrEmpty(copyType)) {
            this.container.setCopyType(CopyType.valueOf(copyType));
        }
        if (this.isDeleted) {
            this.container.setDeleted();
        }
    }

    private ContainerType getContainerType(XMLStreamReader xmlStreamReader, String containerName) {
        String containerType = XmlHelper.getAttributeValue(xmlStreamReader, "type");
        if (this.isNullOrEmpty(containerType)) {
            throw new RuntimeException("Container Type not found for container " + containerName);
        }
        String containerTypeUpperCased = containerType.toUpperCase();
        return ContainerType.valueOf(containerTypeUpperCased);
    }

    private void processResourceTag(XMLStreamReader xmlStreamReader) {
        String resourceName = XmlHelper.getAttributeValue(xmlStreamReader, "name");
        String resourceType = XmlHelper.getAttributeValue(xmlStreamReader, "type");
        String resourceDeployType = XmlHelper.getAttributeValue(xmlStreamReader, "deployType");
        String lastModifiedTimestamp = XmlHelper.getAttributeValue(xmlStreamReader, "lastModifiedTimestamp");
        this.containerResource = new ContainerResource(resourceName);
        this.containerResource.setType(resourceType);
        this.containerResource.setDeployType(this.isNullOrEmpty(resourceDeployType) ? this.containerDeployType : resourceDeployType);
        this.containerResource.setLastModifiedTimestamp(lastModifiedTimestamp);
    }

    private boolean isNullOrEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    private void processPropertyTag(XMLStreamReader xmlStreamReader) {
        String propertyName = XmlHelper.getAttributeValue(xmlStreamReader, "name");
        String propertyValue = XmlHelper.getAttributeValue(xmlStreamReader, "value");
        if (this.containerResource != null) {
            this.containerResource.addCustomerProperty(propertyName, propertyValue);
        } else if (this.container != null) {
            this.container.addCustomerProperty(propertyName, propertyValue);
        }
    }

    private void processInputsTag(XMLStreamReader xmlStreamReader) {
        String inputsUrl = XmlHelper.getAttributeValue(xmlStreamReader, "url");
        if (this.containerResource != null) {
            this.containerResource.setInputs(new Inputs(inputsUrl));
        } else if (this.container != null && this.container.isSequential()) {
            this.container.setInputs(new Inputs(inputsUrl));
        }
    }

    private void processInputTag(XMLStreamReader xmlStreamReader) {
        Input input = new Input(XmlHelper.getAttributeValue(xmlStreamReader, "name"));
        input.setVersion(XmlHelper.getAttributeValue(xmlStreamReader, "version"));
        input.setUrl(XmlHelper.getAttributeValue(xmlStreamReader, "url"));
        input.setCompileType(XmlHelper.getAttributeValue(xmlStreamReader, "compileType"));
        if (this.containerResource != null) {
            this.containerResource.getInputs().addInput(input);
        } else if (this.container != null && this.container.isSequential()) {
            this.container.getInputs().addInput(input);
        }
    }

    private void processEndElement(XMLStreamReader xmlStreamReader) {
        String tagName = xmlStreamReader.getLocalName().trim();
        if (tagName.equalsIgnoreCase("deleted")) {
            this.isDeleted = false;
        } else if (tagName.equalsIgnoreCase("container")) {
            this.containers.add(this.container);
            this.container = null;
            this.containerDeployType = null;
        } else if (tagName.equalsIgnoreCase("resource")) {
            this.container.addContainerResource(this.containerResource);
            this.containerResource = null;
        }
    }

    public Stream<ManifestContainer> getContainers() {
        return this.containers.stream();
    }

    public Stream<ManifestContainer> getDeletedContainers() {
        return this.getContainers().filter(ManifestContainer::isDeleted);
    }

    public Stream<ManifestContainer> getAddedContainers() {
        return this.getContainers().filter(container -> !container.isDeleted());
    }

    public boolean hasDataset() {
        if (this.hasDataset == null) {
            this.hasDataset = this.getContainers().anyMatch(ManifestContainer::isDataset);
        }
        return this.hasDataset;
    }

    public boolean hasHFSFile() {
        if (this.hasHFSFile == null) {
            this.hasHFSFile = this.getContainers().anyMatch(ManifestContainer::isDirectory);
        }
        return this.hasHFSFile;
    }

    public boolean hasGenericArtifact() {
        if (this.hasGenericArtifact == null) {
            this.hasGenericArtifact = this.getContainers().anyMatch(ManifestContainer::isGeneric);
        }
        return this.hasGenericArtifact;
    }

    public boolean hasOnlyGenericArtifacts() {
        return this.hasGenericArtifact() && !this.hasDataset() && !this.hasHFSFile();
    }

    public boolean isNewPackageFormat() {
        return this.manifestVersion != null && this.manifestVersion.equals(V_2_0);
    }
}

