/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.dataset.record;

import com.ibm.team.enterprise.deployment.dataset.record.DatasetRecord;
import com.ibm.urbancode.zos.deploy.xml.utils.ContainerResource;
import com.ibm.urbancode.zos.deploy.xml.utils.ManifestContainer;
import com.ibm.urbancode.zos.deploy.xml.utils.parsers.PackageManifest;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class MemberStats
implements DatasetRecord {
    public static final String RESOURCE_LAST_MODIFIED_USERID = "lastModifiedUserid";
    private static final String SEMICOLON = ";";
    private final String pdsDataset;
    private final String member;
    private final String modifiedTimestamp;
    private final String modifiedUser;

    private MemberStats(String pdsDataset, String member, String modifiedTimestamp, String modifiedUser) {
        this.pdsDataset = pdsDataset;
        this.member = member;
        this.modifiedTimestamp = modifiedTimestamp;
        this.modifiedUser = modifiedUser;
    }

    public static List<DatasetRecord> generateRecords(PackageManifest manifest, Map<String, String> sourceTempDsnMap) {
        return manifest.getAddedContainers().filter(ManifestContainer::isPds).flatMap(container -> MemberStats.getStatsForContainerMembers(container, sourceTempDsnMap)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Stream<MemberStats> getStatsForContainerMembers(ManifestContainer container, Map<String, String> sourceTempDsnMap) {
        String dataset = sourceTempDsnMap.get(container.getSourceContainerName());
        return container.getContainerResources().map(resource -> MemberStats.getMemberStats(resource, dataset));
    }

    private static MemberStats getMemberStats(ContainerResource resource, String dataset) {
        String modifiedUser = (String)resource.getCustomerProperties().get(RESOURCE_LAST_MODIFIED_USERID);
        String modifiedTimestamp = resource.getLastModifiedTimestamp();
        if (modifiedUser != null && modifiedTimestamp != null) {
            return new MemberStats(dataset, resource.getName(), modifiedTimestamp, modifiedUser);
        }
        return null;
    }

    @Override
    public String getRecord() {
        return this.pdsDataset + SEMICOLON + this.member + SEMICOLON + this.modifiedTimestamp + SEMICOLON + this.modifiedUser;
    }
}

