/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.toolkit.manifest;

import com.ibm.jzos.ZFileException;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.dataset.alloc.AllocLikeCommandBuilder;
import com.ibm.urbancode.zos.dataset.alloc.DatasetAllocator;
import com.ibm.urbancode.zos.deploy.xml.utils.ManifestContainer;
import com.ibm.urbancode.zos.deploy.xml.utils.parsers.PackageManifest;
import java.io.File;
import java.util.Map;

public final class CpTempDatasetCreator {
    private static final int BUFFER_TRACKS = 10;
    private static final String SYS_ID_BLKSZ = "SYS.id.BLKSZ";
    private static final int BUFFER_DIR_BLOCKS = 1;
    private static final int MEMBERS_PER_DIR_BLOCK = 6;
    private final PackageManifest packageManifest;
    private final String componentVersionWorkingDir;
    private final Map<String, String> sourceTempDsnMap;

    private CpTempDatasetCreator(PackageManifest packageManifest, String componentVersionWorkingDir, Map<String, String> sourceTempDsnMap) {
        this.packageManifest = packageManifest;
        this.componentVersionWorkingDir = componentVersionWorkingDir;
        this.sourceTempDsnMap = sourceTempDsnMap;
    }

    public static void create(PackageManifest packageManifest, String componentVersionWorkingDir, Map<String, String> sourceTempDsnMap) {
        CpTempDatasetCreator cpTempDatasetCreator = new CpTempDatasetCreator(packageManifest, componentVersionWorkingDir, sourceTempDsnMap);
        cpTempDatasetCreator.createDatasets();
    }

    private void createDatasets() {
        this.packageManifest.getAddedContainers().filter(ManifestContainer::isDataset).map(this::getTempDatasetAllocator).forEach(this::allocateTempDataset);
    }

    private DatasetAllocator getTempDatasetAllocator(ManifestContainer container) {
        String tempDataset = this.sourceTempDsnMap.get(container.getSourceContainerName());
        if (container.isPds()) {
            return this.getDatasetAllocatorForPds(container, tempDataset);
        }
        return this.getDatasetAllocatorForSequential(container, tempDataset);
    }

    private DatasetAllocator getDatasetAllocatorForPds(ManifestContainer container, String tempDataset) {
        String directoryBlocks = String.valueOf(this.getDirectoryBlocks(container));
        String spaceInTracks = this.getSpaceInTracks(container);
        return new AllocLikeCommandBuilder(tempDataset).withLikeDataset(container.getTargetContainerName()).withDirectoryBlocks(directoryBlocks).withBlockSize((String)container.getCustomerProperties().get(SYS_ID_BLKSZ)).withSpace(spaceInTracks, spaceInTracks).build();
    }

    private int getDirectoryBlocks(ManifestContainer container) {
        String sourceContainer = container.getSourceContainerName();
        String containerDir = this.componentVersionWorkingDir + File.separator + sourceContainer;
        int totalMembers = FileHelper.getNumberOfFiles(containerDir);
        return totalMembers / 6 + 1;
    }

    private String getSpaceInTracks(ManifestContainer container) {
        String containerDirectory = this.componentVersionWorkingDir + File.separator + container.getSourceContainerName();
        int spaceInTracks = FileHelper.getDirectorySizeInTracks(containerDirectory) + 10;
        return String.valueOf(spaceInTracks);
    }

    private DatasetAllocator getDatasetAllocatorForSequential(ManifestContainer container, String tempDataset) {
        return new AllocLikeCommandBuilder(tempDataset).withLikeDataset(container.getTargetContainerName()).build();
    }

    private void allocateTempDataset(DatasetAllocator datasetAllocator) {
        try {
            datasetAllocator.allocate();
        }
        catch (ZFileException e) {
            throw new RuntimeException(e);
        }
    }
}

