/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.toolkit.manifest;

import com.ibm.jzos.ZFileException;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.dataset.alloc.AllocGenericCommandBuilder;
import com.ibm.urbancode.zos.dataset.alloc.DatasetAllocator;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.ibm.urbancode.zos.deploy.xml.utils.ManifestContainer;
import com.ibm.urbancode.zos.deploy.xml.utils.parsers.PackageManifest;
import java.io.File;
import java.util.Map;

public final class MissingTargetDatasetsCreator {
    private static final String SYS_ID_RECLN = "SYS.id.RECLN";
    private static final String SYS_ID_RECFM = "SYS.id.RECFM";
    private static final String SYS_ID_RECORG = "SYS.id.RECORG";
    private static final String SYS_ID_BLKSZ = "SYS.id.BLKSZ";
    private static final String SYS_ID_LIBTYPE = "SYS.id.LIBTYPE";
    private static final String TRACKS = "TRACKS";
    private static final String PDSE = "PDSE";
    private static final String LIBRARY = "LIBRARY";
    private static final String PDS = "PDS";
    private static final int BUFFER_TRACKS = 10;
    private static final int BUFFER_DIR_BLOCKS = 1;
    private static final int MEMBERS_PER_DIR_BLOCK = 6;

    private MissingTargetDatasetsCreator() {
    }

    public static void create(PackageManifest packageManifest, String componentVersionWorkingDir) {
        packageManifest.getAddedContainers().filter(ManifestContainer::isDataset).filter(MissingTargetDatasetsCreator::isTargetDatasetNotExist).map(container -> MissingTargetDatasetsCreator.getDatasetAllocator(container, componentVersionWorkingDir)).forEach(MissingTargetDatasetsCreator::allocateDataset);
    }

    private static boolean isTargetDatasetNotExist(ManifestContainer container) {
        try {
            return DatasetHelper.isDatasetNotExist(container.getTargetContainerName());
        }
        catch (ZFileException e) {
            throw new RuntimeException(e);
        }
    }

    private static DatasetAllocator getDatasetAllocator(ManifestContainer container, String componentVersionWorkingDir) {
        Map containerProperties = container.getCustomerProperties();
        int directoryBlocks = MissingTargetDatasetsCreator.getDirectoryBlocks(container, componentVersionWorkingDir);
        String dsnType = MissingTargetDatasetsCreator.getDsnType(container);
        String spaceInTracks = MissingTargetDatasetsCreator.getSpaceInTracks(container, componentVersionWorkingDir);
        return new AllocGenericCommandBuilder(container.getTargetContainerName()).withDsOrg((String)containerProperties.get(SYS_ID_RECORG)).withRecordLength((String)containerProperties.get(SYS_ID_RECLN)).withBlockSize((String)containerProperties.get(SYS_ID_BLKSZ)).withSpace(spaceInTracks, spaceInTracks).withSpaceUnit(TRACKS, (String)containerProperties.get(SYS_ID_RECLN)).withRecordFormat((String)containerProperties.get(SYS_ID_RECFM)).withDatasetType(dsnType).withDirectoryBlocks(String.valueOf(directoryBlocks)).build();
    }

    private static int getDirectoryBlocks(ManifestContainer container, String componentVersionWorkingDir) {
        if (container.isSequential()) {
            return 0;
        }
        String sourceContainer = container.getSourceContainerName();
        String containerDir = componentVersionWorkingDir + File.separator + sourceContainer;
        int totalMembers = FileHelper.getNumberOfFiles(containerDir);
        return totalMembers / 6 + 1;
    }

    private static String getDsnType(ManifestContainer container) {
        if (container.isSequential()) {
            return "";
        }
        String libraryType = (String)container.getCustomerProperties().get(SYS_ID_LIBTYPE);
        if (libraryType.trim().equals(PDSE)) {
            return LIBRARY;
        }
        return PDS;
    }

    private static String getSpaceInTracks(ManifestContainer container, String componentVersionWorkingDir) {
        String containerDirectory = componentVersionWorkingDir + File.separator + container.getSourceContainerName();
        int spaceInTracks = FileHelper.getDirectorySizeInTracks(containerDirectory) + 10;
        return String.valueOf(spaceInTracks);
    }

    private static void allocateDataset(DatasetAllocator datasetAllocator) {
        try {
            datasetAllocator.allocate();
        }
        catch (ZFileException e) {
            throw new RuntimeException(e);
        }
    }
}

