/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.toolkit.manifest;

import com.ibm.team.enterprise.deployment.dataset.record.DatasetRecord;
import com.ibm.team.enterprise.deployment.dataset.record.DatasetRecordsWriter;
import com.ibm.team.enterprise.deployment.dataset.record.DeploymentRecord;
import com.ibm.team.enterprise.deployment.dataset.record.MemberStats;
import com.ibm.team.enterprise.deployment.toolkit.manifest.CpCommand;
import com.ibm.team.enterprise.deployment.toolkit.manifest.CpScriptFile;
import com.ibm.team.enterprise.deployment.toolkit.manifest.CpTempDatasetCreator;
import com.ibm.team.enterprise.deployment.toolkit.manifest.MissingTargetDatasetsCreator;
import com.ibm.team.enterprise.deployment.toolkit.manifest.ProcessExecutor;
import com.ibm.team.enterprise.deployment.toolkit.manifest.SourceTempDsnMap;
import com.ibm.urbancode.zos.common.util.Console;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.common.util.PluginFilesHelper;
import com.ibm.urbancode.zos.common.util.RexxExecutor;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.ibm.urbancode.zos.dataset.util.RexxFileToDatasetConvertor;
import com.ibm.urbancode.zos.dataset.util.TempDsnNameHelper;
import com.ibm.urbancode.zos.deploy.xml.utils.parsers.PackageManifest;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayXMLResponse;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class NewFormatPackageDeployer {
    private final String manifestDeployFilePath;
    private final String containerMapperFilePath;
    private final String tempDsnPrefix;
    private final String componentVersionWorkingDir;
    private final String ispfGatewayBinPath;

    public NewFormatPackageDeployer(String componentVersionWorkingDir, String tempDsnPrefix, String ispfGatewayBinPath) {
        this.componentVersionWorkingDir = componentVersionWorkingDir;
        this.tempDsnPrefix = tempDsnPrefix;
        this.ispfGatewayBinPath = ispfGatewayBinPath;
        this.manifestDeployFilePath = componentVersionWorkingDir + File.separator + "packageManifest_deploy.xml";
        this.containerMapperFilePath = componentVersionWorkingDir + File.separator + "containerMapper.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy() throws XMLStreamException, IOException, InterruptedException {
        int exitCode;
        this.extractPackageZip();
        PackageManifest packageManifestDeploy = PackageManifest.from((String)this.manifestDeployFilePath, (String)this.containerMapperFilePath);
        this.CreateMissingTargetDatasets(packageManifestDeploy);
        Map<String, String> sourceTempDsnMap = SourceTempDsnMap.from(packageManifestDeploy, this.tempDsnPrefix);
        this.createTemporaryDatasets(packageManifestDeploy, sourceTempDsnMap);
        String statsUpdaterRexx = null;
        String statsUpdaterRexxInput = null;
        String deploymentRexx = null;
        String deploymentRexxInput = null;
        try {
            this.copyFilesToDatasets(packageManifestDeploy, sourceTempDsnMap);
            RexxExecutor rexxExecutor = new RexxExecutor(this.tempDsnPrefix, this.ispfGatewayBinPath);
            statsUpdaterRexxInput = this.getStatsUpdaterRexxInput(packageManifestDeploy, sourceTempDsnMap);
            statsUpdaterRexx = this.getStatsUpdaterRexxDataset();
            IspfGatewayXMLResponse ispfGatewayXMLResponse1 = rexxExecutor.execute(statsUpdaterRexx, statsUpdaterRexxInput);
            exitCode = Integer.parseInt(ispfGatewayXMLResponse1.getReturnCode());
            if (exitCode != 0) {
                Console.printProcessOutput(ispfGatewayXMLResponse1.getOutputText());
                throw new RuntimeException("[Error] Stats Updater REXX failed with return code " + exitCode);
            }
            deploymentRexxInput = this.getDeploymentRexxInput(packageManifestDeploy, sourceTempDsnMap);
            deploymentRexx = this.getDeploymentRexxDataset();
            IspfGatewayXMLResponse ispfGatewayXMLResponse2 = rexxExecutor.execute(deploymentRexx, deploymentRexxInput);
            Console.printProcessOutput(ispfGatewayXMLResponse2.getOutputText());
            exitCode = Integer.parseInt(ispfGatewayXMLResponse2.getReturnCode());
            DatasetHelper.deleteDataset(deploymentRexx);
        }
        catch (Exception e) {
            e.printStackTrace();
            exitCode = 8;
        }
        finally {
            DatasetHelper.deleteDataset(deploymentRexx);
            DatasetHelper.deleteDataset(deploymentRexxInput);
            DatasetHelper.deleteDataset(statsUpdaterRexx);
            DatasetHelper.deleteDataset(statsUpdaterRexxInput);
            Collection<String> tempDatasets = sourceTempDsnMap.values();
            for (String tempDataset : tempDatasets) {
                DatasetHelper.deleteDataset(tempDataset);
            }
        }
        DatasetHelper.deleteDataset(deploymentRexxInput);
        DatasetHelper.deleteDataset(statsUpdaterRexx);
        DatasetHelper.deleteDataset(statsUpdaterRexxInput);
        Collection<String> tempDatasets = sourceTempDsnMap.values();
        for (String tempDataset : tempDatasets) {
            DatasetHelper.deleteDataset(tempDataset);
        }
        if (exitCode > 0) {
            System.exit(1);
        }
    }

    private String getDeploymentRexxDataset() throws IOException {
        String deploymentRexx = TempDsnNameHelper.getRexxDsnName(this.tempDsnPrefix);
        String deploymentRexxFilePath = PluginFilesHelper.getDeploymentRexxFilePath();
        RexxFileToDatasetConvertor.convert(deploymentRexxFilePath, deploymentRexx);
        return deploymentRexx;
    }

    private String getDeploymentRexxInput(PackageManifest packageManifestDeploy, Map<String, String> sourceTempDsnMap) throws IOException {
        List<DatasetRecord> deploymentRecords = DeploymentRecord.generateRecordsFrom(packageManifestDeploy, sourceTempDsnMap);
        String deploymentRexxInput = TempDsnNameHelper.getActionDsnName(this.tempDsnPrefix);
        DatasetRecordsWriter.write(deploymentRecords, deploymentRexxInput);
        return deploymentRexxInput;
    }

    private String getStatsUpdaterRexxInput(PackageManifest packageManifestDeploy, Map<String, String> sourceTempDsnMap) throws IOException {
        String statsUpdaterRexxInput = TempDsnNameHelper.getActionDsnName(this.tempDsnPrefix);
        List<DatasetRecord> statsRecords = MemberStats.generateRecords(packageManifestDeploy, sourceTempDsnMap);
        DatasetRecordsWriter.write(statsRecords, statsUpdaterRexxInput);
        return statsUpdaterRexxInput;
    }

    private String getStatsUpdaterRexxDataset() throws IOException {
        String statsUpdaterRexxDsn = TempDsnNameHelper.getRexxDsnName(this.tempDsnPrefix);
        String statsUpdaterRexxFilePath = PluginFilesHelper.getStatsUpdaterRexxFilePath();
        RexxFileToDatasetConvertor.convert(statsUpdaterRexxFilePath, statsUpdaterRexxDsn);
        return statsUpdaterRexxDsn;
    }

    private void createTemporaryDatasets(PackageManifest packageManifestDeploy, Map<String, String> sourceTempDsnMap) {
        Console.printActionTitle("Creating Temporary Datasets");
        CpTempDatasetCreator.create(packageManifestDeploy, this.componentVersionWorkingDir, sourceTempDsnMap);
        System.out.println();
    }

    private void CreateMissingTargetDatasets(PackageManifest packageManifestDeploy) {
        Console.printActionTitle("Create missing target datasets");
        MissingTargetDatasetsCreator.create(packageManifestDeploy, this.componentVersionWorkingDir);
        System.out.println();
    }

    private void extractPackageZip() throws IOException, InterruptedException {
        String packageZipFilePath = this.componentVersionWorkingDir + File.separator + "package.zip";
        if (FileHelper.isFileExist(packageZipFilePath)) {
            ProcessExecutor.extractUsingPaxCommand(this.componentVersionWorkingDir, "package.zip");
        }
    }

    private void copyFilesToDatasets(PackageManifest packageManifestDeploy, Map<String, String> sourceTempDsnMap) throws Exception {
        List<String> cpCommands = CpCommand.generateCommands(packageManifestDeploy, sourceTempDsnMap);
        String cpScriptFilePath = this.componentVersionWorkingDir + File.separator + "temp_copy_file_to_dataset.sh";
        CpScriptFile.create(cpScriptFilePath, cpCommands);
        ProcessExecutor.executeScript(this.componentVersionWorkingDir, "temp_copy_file_to_dataset.sh");
    }
}

