/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.common.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.stream.Stream;

public final class FileHelper {
    private static final int BYTES_PER_TRACK = 56664;
    private static final int ONE_TRACK = 1;
    private static final String ENCODING_IBM1047 = "IBM-1047";
    public static final String LINE_BREAK = System.lineSeparator();

    private FileHelper() {
    }

    public static boolean isFileNotExist(String filePath) {
        return !FileHelper.isFileExist(filePath);
    }

    public static boolean isFileExist(String filePath) {
        return new File(filePath).isFile();
    }

    public static void cleanDirectory(String directoryPath) throws IOException {
        if (new File(directoryPath).isDirectory()) {
            try (Stream<Path> pathStream = Files.walk(Paths.get(directoryPath, new String[0]), new FileVisitOption[0]);){
                pathStream.map(Path::toFile).sorted(Comparator.reverseOrder()).forEach(File::delete);
            }
        }
    }

    public static int getDirectorySizeInTracks(String directoryPath) {
        long sizeInBytes = FileHelper.getDirectorySizeInBytes(Paths.get(directoryPath, new String[0]));
        return FileHelper.determineTracks(sizeInBytes);
    }

    public static int getFileSizeInTracks(String filePath) {
        long sizeInBytes = FileHelper.getFileSizeInBytes(Paths.get(filePath, new String[0]));
        return FileHelper.determineTracks(sizeInBytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long getDirectorySizeInBytes(Path directoryPath) {
        try (Stream<Path> walk = Files.walk(directoryPath, new FileVisitOption[0]);){
            long l = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).mapToLong(FileHelper::getFileSizeInBytes).sum();
            return l;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static long getFileSizeInBytes(Path filePath) {
        try {
            return Files.size(filePath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static int determineTracks(long sizeInBytes) {
        if (sizeInBytes <= 56664L) {
            return 1;
        }
        return (int)Math.ceil((double)sizeInBytes / 56664.0);
    }

    public static boolean isDirectoryNotExist(String directoryPath) {
        return !new File(directoryPath).isDirectory();
    }

    public static void changeEncodingAttributeToIBM1047(String xmlFilePath) throws IOException {
        Path path = Paths.get(xmlFilePath, new String[0]);
        String content = new String(Files.readAllBytes(path));
        content = content.replace("xml version=\"1.0\" encoding=\"UTF-8\"", "xml version=\"1.0\" encoding=\"IBM-1047\"");
        Files.write(path, content.getBytes(), new OpenOption[0]);
    }

    public static void writeStringToFile(String s, String filePath) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(path, Charset.forName(ENCODING_IBM1047), new OpenOption[0]);){
            writer.write(s);
        }
    }

    public static int getNumberOfFiles(String directoryPath) {
        if (FileHelper.isDirectoryNotExist(directoryPath)) {
            throw new RuntimeException("Directory " + directoryPath + " does not exist.");
        }
        File[] directoryFiles = new File(directoryPath).listFiles();
        if (directoryFiles == null) {
            throw new RuntimeException("Failed to list files for directory " + directoryPath);
        }
        return directoryFiles.length;
    }

    public static String getFileContent(String filePathString) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(filePathString));){
            String line;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line).append(LINE_BREAK);
            }
        }
        return stringBuilder.toString();
    }

    public static int getFileLineCount(String filePath) throws IOException {
        try (Stream<String> lines = Files.lines(Paths.get(filePath, new String[0]));){
            int n = (int)lines.count();
            return n;
        }
    }
}

