/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.zinventory;

import com.ibm.urbancode.zos.common.util.DeploymentXmlFilePaths;
import com.ibm.urbancode.zos.deploy.xml.utils.ContainerResource;
import com.ibm.urbancode.zos.deploy.xml.utils.Input;
import com.ibm.urbancode.zos.deploy.xml.utils.Inputs;
import com.ibm.urbancode.zos.deploy.xml.utils.ManifestContainer;
import com.ibm.urbancode.zos.deploy.xml.utils.parsers.ContainerMap;
import com.ibm.urbancode.zos.deploy.xml.utils.parsers.PackageManifest;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ZInventoryRequestGenerator {
    private static final String PDS_MEMBER = "PDSMEMBER";
    private static final String USS_FILE = "USSFILE";
    private static final String SEQUENTIAL = "SEQUENTIAL";
    private static final String DELETED = "DELETE";
    private static final String DEPLOY = "DEPLOY";
    private static final String NAME = "name";
    private static final String INPUTS = "inputs";
    private static final String DEPLOY_TYPE = "deploy-type";
    private static final String TARGET_TYPE = "target-type";
    private static final String TARGET = "target";
    private static final String OPERATION_TYPE = "operation-type";
    private static final String FORWARD_SLASH = "/";
    private static final String INPUTS_URL = "Inputs-url=";
    private static final String SEMI_COLON = " ; ";
    private ContainerMap datasetContainerMap;
    private ContainerMap hfsContainerMap;
    private final ArrayList<JSONObject> resourcesList = new ArrayList();
    private final HashMap<String, ManifestContainer> originalDeployedContainerMapper = new HashMap();
    private final HashMap<String, ManifestContainer> originalDeletedContainerMapper = new HashMap();
    private PackageManifest packageManifestDeploy;
    private PackageManifest originalPackageManifest;
    private final String containerMapperFilePath = DeploymentXmlFilePaths.containerMapperXmlFilePath;
    private final String containerMapperHFSFilePath = DeploymentXmlFilePaths.containerMapperHFSXmlFilePath;
    private final String packageManifestDeployFilePath = DeploymentXmlFilePaths.packageManifestFileDeployNamePath;
    private final String originalPackageManifestFilePath = DeploymentXmlFilePaths.originalPackageManifestFileNamePath;

    public List<JSONObject> buildRequestPayload() throws XMLStreamException, IOException {
        this.extractDataFromXmlFiles();
        this.mapDatasetNameWithDatasetObjectFromOriginalPackageManifest();
        this.packageManifestDeploy.getAddedContainers().map(container -> this.originalDeployedContainerMapper.get(container.getSourceContainerName())).forEach(originalContainer -> this.addJSONObjectsToResourceList((ManifestContainer)originalContainer, DEPLOY));
        this.packageManifestDeploy.getDeletedContainers().map(container -> this.originalDeletedContainerMapper.get(container.getSourceContainerName())).forEach(originalContainer -> this.addJSONObjectsToResourceList((ManifestContainer)originalContainer, DELETED));
        return this.resourcesList;
    }

    private void addJSONObjectsToResourceList(ManifestContainer originalContainer, String operationType) {
        if (originalContainer.isDirectory()) {
            originalContainer.getContainerResources().forEach(resource -> this.resourcesList.add(this.getJSONObjectForDirectoryContainer((ContainerResource)resource, operationType, originalContainer)));
        } else if (originalContainer.isPds()) {
            originalContainer.getContainerResources().forEach(resource -> this.resourcesList.add(this.getJSONObjectForPdsContainer((ContainerResource)resource, operationType, originalContainer)));
        } else if (originalContainer.isSequential()) {
            this.resourcesList.add(this.getJSONObjectForSequentialContainer(originalContainer, operationType));
        }
    }

    private JSONObject getJSONObjectForDirectoryContainer(ContainerResource resource, String operationType, ManifestContainer container) {
        JSONObject js = new JSONObject();
        try {
            js.put(NAME, (Object)resource.getName());
            js.put(INPUTS, (Object)this.getInputsForZSearch(resource.getInputs()));
            js.put(OPERATION_TYPE, (Object)operationType);
            js.put(DEPLOY_TYPE, (Object)(resource.getDeployType() == null ? "" : resource.getDeployType()));
            js.put(TARGET_TYPE, (Object)USS_FILE);
            js.put(TARGET, (Object)this.hfsContainerMap.getTarget(FORWARD_SLASH + container.getSourceContainerName()));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return js;
    }

    private JSONObject getJSONObjectForPdsContainer(ContainerResource resource, String operationType, ManifestContainer container) {
        JSONObject js = new JSONObject();
        try {
            js.put(NAME, (Object)resource.getName());
            js.put(INPUTS, (Object)this.getInputsForZSearch(resource.getInputs()));
            js.put(OPERATION_TYPE, (Object)operationType);
            js.put(DEPLOY_TYPE, (Object)(resource.getDeployType() == null ? "" : resource.getDeployType()));
            js.put(TARGET_TYPE, (Object)PDS_MEMBER);
            js.put(TARGET, (Object)this.datasetContainerMap.getTarget(container.getSourceContainerName()));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return js;
    }

    private JSONObject getJSONObjectForSequentialContainer(ManifestContainer sequentialContainer, String operationType) {
        JSONObject js = new JSONObject();
        try {
            js.put(TARGET_TYPE, (Object)SEQUENTIAL);
            js.put(TARGET, (Object)this.datasetContainerMap.getTarget(sequentialContainer.getSourceContainerName()));
            js.put(INPUTS, (Object)this.getInputsForZSearch(sequentialContainer.getInputs()));
            js.put(NAME, (Object)sequentialContainer.getSourceContainerName());
            js.put(DEPLOY_TYPE, (Object)(sequentialContainer.getDeployType() == null ? "" : sequentialContainer.getDeployType()));
            js.put(OPERATION_TYPE, (Object)operationType);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return js;
    }

    private void extractDataFromXmlFiles() throws IOException, XMLStreamException {
        this.packageManifestDeploy = PackageManifest.from((String)this.packageManifestDeployFilePath);
        this.originalPackageManifest = PackageManifest.from((String)this.originalPackageManifestFilePath);
        if (new File(this.containerMapperFilePath).isFile()) {
            this.datasetContainerMap = ContainerMap.from((String)this.containerMapperFilePath);
        }
        if (new File(this.containerMapperHFSFilePath).isFile()) {
            this.hfsContainerMap = ContainerMap.from((String)this.containerMapperHFSFilePath);
        }
    }

    private void mapDatasetNameWithDatasetObjectFromOriginalPackageManifest() {
        this.originalPackageManifest.getAddedContainers().forEach(container -> this.originalDeployedContainerMapper.put(container.getSourceContainerName(), (ManifestContainer)container));
        this.originalPackageManifest.getDeletedContainers().forEach(container -> this.originalDeletedContainerMapper.put(container.getSourceContainerName(), (ManifestContainer)container));
    }

    private String getInputsForZSearch(Inputs inputs) {
        if (inputs == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(inputs.getUrl().isEmpty() ? inputs.getUrl() : "Inputs-url='" + inputs.getUrl() + "'" + SEMI_COLON);
        inputs.getInputs().forEach(input -> builder.append(this.getInputForZSearch((Input)input)));
        return builder.toString();
    }

    private String getInputForZSearch(Input input) {
        return "NAME:- " + input.getName() + ", VERSION:- " + input.getVersion() + ", URL:- '" + input.getUrl() + "', COMPILE_TYPE:- " + input.getCompileType() + SEMI_COLON;
    }
}

