/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.urbancode.zos.common.util.DeploymentFilesHelper;
import com.ibm.urbancode.zos.deploy.xml.utils.DeploymentResultHelper;
import com.ibm.urbancode.zos.deploy.xml.utils.ManifestContainer;
import com.ibm.urbancode.zos.deploy.xml.utils.RollbackManifest;
import com.ibm.urbancode.zos.deploy.xml.utils.parsers.PackageManifest;
import com.ibm.urbancode.zos.generate.artifact.info.ElementsSorter;
import com.ibm.urbancode.zos.generate.artifact.info.FilterInputs;
import com.ibm.urbancode.zos.generate.artifact.info.LoopType;
import com.ibm.urbancode.zos.generate.artifact.info.PackageManifestDownloader;
import com.ibm.urbancode.zos.generate.artifact.info.VersionInfoGenerator;
import com.urbancode.air.plugin.inputs.GenerateInfoInputs;
import java.io.IOException;
import java.util.Properties;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;

public class GenerateVersionArtifactInfo {
    private final Properties outputProperties;
    private final GenerateInfoInputs pluginInputs;
    private final FilterInputs filterInputs;
    private int exitCode = 0;

    public GenerateVersionArtifactInfo(Properties inputProperties, Properties outputProperties) {
        this.outputProperties = outputProperties;
        this.pluginInputs = new GenerateInfoInputs(inputProperties);
        this.filterInputs = this.pluginInputs.getFilterInputs();
    }

    public int execute() throws Exception {
        try {
            this.pluginInputs.validateInputs();
            if (!this.isVersionDeployed()) {
                this.ignoreTargetDatasetIfExist();
                this.ignoreDeployActionIfExist();
            }
            PackageManifest packageManifest = this.getPackageManifest();
            Stream<ManifestContainer> containersBasedOnLoopType = this.getManifestContainersBasedOnLoopType(packageManifest);
            Stream orderedContainers = new ElementsSorter(containersBasedOnLoopType, this.filterInputs.getOrderBy()).sort();
            RollbackManifest rollbackManifest = this.getRollbackManifest();
            VersionInfoGenerator infoGenerator = new VersionInfoGenerator(this.filterInputs, orderedContainers, rollbackManifest);
            infoGenerator.generate();
            this.printGeneratedTextToConsole(infoGenerator.getText());
            this.setOutputProperties(infoGenerator);
            if (this.pluginInputs.isFailOnEmpty() && infoGenerator.getText().trim().isEmpty()) {
                throw new RuntimeException("Step failed because Fail On Empty is checked and the generation result is empty.");
            }
        }
        catch (RuntimeException runtimeException) {
            System.out.println(" [Error] " + runtimeException.getMessage());
            this.exitCode = 1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.exitCode = 1;
        }
        return this.exitCode;
    }

    private Stream<ManifestContainer> getManifestContainersBasedOnLoopType(PackageManifest packageManifest) {
        if (LoopType.isDeleted((String)this.filterInputs.getLoopType())) {
            return packageManifest.getDeletedContainers();
        }
        return packageManifest.getAddedContainers();
    }

    private RollbackManifest getRollbackManifest() throws XMLStreamException, IOException {
        if (this.isRollbackManifestOperationsNeeded()) {
            return DeploymentResultHelper.getRollbackStructure((String)this.pluginInputs.getDeployBasePath(), (String)this.pluginInputs.getResourceId(), (String)this.pluginInputs.getComponentName(), (String)this.pluginInputs.getVersionName());
        }
        return new RollbackManifest();
    }

    private boolean isRollbackManifestOperationsNeeded() {
        if (this.filterInputs.isDeployActionPassed()) {
            return true;
        }
        String loopType = this.filterInputs.getLoopType();
        return loopType.equals("DeletedMemberExcludingMissingMembers");
    }

    private boolean isVersionDeployed() {
        return DeploymentResultHelper.checkVersionDeployed((String)this.pluginInputs.getDeployBasePath(), (String)this.pluginInputs.getResourceId(), (String)this.pluginInputs.getComponentName(), (String)this.pluginInputs.getVersionName());
    }

    private void ignoreTargetDatasetIfExist() {
        if (!this.filterInputs.getTargetDataset().isEmpty()) {
            System.out.println("Warning: Target Dataset Name Filter ignored because version " + this.pluginInputs.getVersionName() + " is not deployed");
            this.filterInputs.ignoreTargetDataset();
        }
    }

    private void ignoreDeployActionIfExist() {
        if (!this.filterInputs.getDeployAction().isEmpty()) {
            System.out.println("Warning: Deployment Action Filter ignored because version " + this.pluginInputs.getVersionName() + " is not deployed");
            this.filterInputs.ignoreDeployAction();
        }
    }

    private PackageManifest getPackageManifest() throws Exception {
        if (this.isVersionDeployed()) {
            return DeploymentResultHelper.getDeployedPackageManifest((String)this.pluginInputs.getDeployBasePath(), (String)this.pluginInputs.getResourceId(), (String)this.pluginInputs.getComponentName(), (String)this.pluginInputs.getVersionName());
        }
        String versionWorkingDir = DeploymentFilesHelper.getVersionDirPathInWorkingDir(this.pluginInputs.getVersionName(), this.pluginInputs.getResourceId());
        PackageManifestDownloader.download((String)this.pluginInputs.getComponentName(), (String)this.pluginInputs.getVersionName(), (String)versionWorkingDir);
        String manifestFilePath = DeploymentFilesHelper.getFilePathInWorkingDir(this.pluginInputs.getVersionName(), this.pluginInputs.getResourceId(), "packageManifest.xml");
        return PackageManifest.from((String)manifestFilePath);
    }

    private void printGeneratedTextToConsole(String text) {
        System.out.println();
        System.out.println("Output text:");
        System.out.println("========================================================================================================================");
        System.out.println(text);
        System.out.println("========================================================================================================================");
    }

    private void setOutputProperties(VersionInfoGenerator infoGenerator) {
        this.outputProperties.setProperty("text", infoGenerator.getText());
        this.outputProperties.setProperty("count", Long.toString(infoGenerator.getCount()));
    }
}

