/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.jcl;

import com.urbancode.air.plugin.inputs.InvalidInputException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JobCard {
    private static final String JOB_COMMAND_REGEX = "\\bJOB\\b";
    private static final Pattern JOB_COMMAND_REGEX_PATTERN = Pattern.compile("\\bJOB\\b");
    private static final String LINE_BREAK = "\n";
    private static final String TWO_FORWARD_SLASHES = "//";

    private JobCard() {
    }

    public static String update(String jcl, String jobCard) {
        if (jobCard.isEmpty()) {
            System.out.println(" [Info] No default job card statement found");
            throw new InvalidInputException("JOB statement must be provided in the first line of JCL.");
        }
        if (JobCard.hasNoJobStatement(jobCard)) {
            throw new InvalidInputException("JOB statement must be provided in the first line in the default Job card.");
        }
        System.out.println(" [Info] Adding default JOB statement");
        return jobCard + LINE_BREAK + jcl;
    }

    public static boolean hasNoJobStatement(String jcl) {
        String[] jclLines = jcl.split(LINE_BREAK);
        String jclFirstLine = jclLines[0];
        Matcher jobCommandMatcher = JOB_COMMAND_REGEX_PATTERN.matcher(jclFirstLine);
        return !jclFirstLine.startsWith(TWO_FORWARD_SLASHES) || !jobCommandMatcher.find();
    }
}

