/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.generate.artifact.info;

import com.ibm.urbancode.zos.deploy.xml.utils.ContainerType;
import java.util.HashMap;
import java.util.Map;

public final class InfoMatcher {
    private static final String REGEX_FORMAT = "^/.+/$";
    private static final Map<String, ContainerType> loopTypeToContainerTypeMap = new HashMap<String, ContainerType>(){
        {
            this.put("Member", ContainerType.PDS);
            this.put("PDS", ContainerType.PDS);
            this.put("DeletedMember", ContainerType.PDS);
            this.put("DeletedPDS", ContainerType.PDS);
            this.put("DeletedMemberExcludingMissingMembers", ContainerType.PDS);
            this.put("Sequential", ContainerType.SEQUENTIAL);
            this.put("DeletedSequential", ContainerType.SEQUENTIAL);
            this.put("Directory", ContainerType.DIRECTORY);
            this.put("File", ContainerType.DIRECTORY);
            this.put("DeletedFile", ContainerType.DIRECTORY);
            this.put("GenericArtifactGroup", ContainerType.GENERIC);
            this.put("GenericArtifact", ContainerType.GENERIC);
        }
    };

    private InfoMatcher() {
    }

    public static boolean isMatched(String filter, String value) {
        if (filter.isEmpty()) {
            return true;
        }
        if (value == null) {
            return false;
        }
        return InfoMatcher.isFilterValueMatched(filter, value);
    }

    private static boolean isFilterValueMatched(String filter, String value) {
        if (InfoMatcher.isFilterARegularExpression(filter)) {
            String pattern = InfoMatcher.extractPatternFromRegEx(filter);
            return value.matches(pattern);
        }
        return value.equals(filter);
    }

    public static boolean isPropertyMatched(String filterPropertyKey, String filterPropertyValue, Map<String, String> customProperties) {
        if (!customProperties.containsKey(filterPropertyKey)) {
            return false;
        }
        if (filterPropertyValue.isEmpty()) {
            return true;
        }
        String custValue = customProperties.get(filterPropertyKey);
        return InfoMatcher.isFilterValueMatched(filterPropertyValue, custValue);
    }

    public static boolean isContainerTypeCompatibleWithLoopType(ContainerType containerType, String loopType) {
        return containerType == loopTypeToContainerTypeMap.get(loopType);
    }

    private static boolean isFilterARegularExpression(String inputFilter) {
        return inputFilter.matches(REGEX_FORMAT);
    }

    private static String extractPatternFromRegEx(String regEx) {
        return regEx.substring(1, regEx.length() - 1);
    }
}

