/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.xml.utils;

import com.ibm.urbancode.zos.deploy.xml.utils.ContainerResource;
import com.ibm.urbancode.zos.deploy.xml.utils.ContainerType;
import com.ibm.urbancode.zos.deploy.xml.utils.CopyType;
import com.ibm.urbancode.zos.deploy.xml.utils.Inputs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class ManifestContainer
implements Comparable<ManifestContainer> {
    private String targetContainerName;
    private CopyType copyType;
    private String deployType;
    private final List<ContainerResource> containerResources = new ArrayList<ContainerResource>();
    private final Map<String, String> customerProperties = new HashMap<String, String>();
    private Inputs inputs;
    private boolean isMissing = false;
    private final String sourceContainerName;
    private final ContainerType type;
    private boolean isDeleted = false;

    public ManifestContainer(String sourceContainerName, ContainerType type) {
        this.sourceContainerName = sourceContainerName;
        this.type = type;
    }

    public Inputs getInputs() {
        return this.inputs;
    }

    public void setInputs(Inputs inputs) {
        this.inputs = inputs;
    }

    public void addContainerResource(ContainerResource containerResource) {
        this.containerResources.add(containerResource);
    }

    public Stream<ContainerResource> getContainerResources() {
        return this.containerResources.stream();
    }

    public String getTargetContainerName() {
        return this.targetContainerName;
    }

    public void setTargetContainerName(String targetContainerName) {
        this.targetContainerName = targetContainerName;
    }

    public String getDeployType() {
        return this.deployType;
    }

    public void setDeployType(String deployType) {
        this.deployType = deployType;
    }

    public Map<String, String> getCustomerProperties() {
        return this.customerProperties;
    }

    public void addCustomerProperty(String property, String value) {
        this.customerProperties.put(property, value);
    }

    public String getSourceContainerName() {
        return this.sourceContainerName;
    }

    public ContainerType getType() {
        return this.type;
    }

    public boolean isGeneric() {
        return this.type == ContainerType.GENERIC;
    }

    public boolean isDirectory() {
        return this.type == ContainerType.DIRECTORY;
    }

    public boolean isPds() {
        return this.type == ContainerType.PDS;
    }

    public boolean isSequential() {
        return this.type == ContainerType.SEQUENTIAL;
    }

    public boolean isDataset() {
        return this.isPds() || this.isSequential();
    }

    public void setMissing() {
        this.isMissing = true;
    }

    public boolean isMissing() {
        return this.isMissing;
    }

    public CopyType getCopyType() {
        return this.copyType;
    }

    public void setCopyType(CopyType copyType) {
        this.copyType = copyType;
    }

    public void setDeleted() {
        this.isDeleted = true;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    @Override
    public int compareTo(ManifestContainer other) {
        return this.sourceContainerName.compareTo(other.getSourceContainerName());
    }

    public String toString() {
        return "ManifestContainer{sourceContainerName='" + this.sourceContainerName + '\'' + ", type='" + this.type.toString() + '\'' + ", targetContainerName='" + this.targetContainerName + '\'' + ", copyType='" + this.copyType.toString() + '\'' + ", deployType='" + this.deployType + '\'' + ", containerResources=" + this.containerResources + ", customerProperties=" + this.customerProperties + ", inputs=" + this.inputs + '}';
    }
}

