/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eserver.zos.racf;

import com.ibm.eserver.zos.racf.IRRPassTicketEvaluationException;
import com.ibm.eserver.zos.racf.IRRPassTicketGenerationException;
import com.ibm.eserver.zos.racf.nls.IRRNLS;
import com.ibm.eserver.zos.racf.trace.IRRNativeTraceTable;
import com.ibm.eserver.zos.racf.util.IRRUtil;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IRRPassTicket {
    private static final String SCCSID = "@(#)85  1.3 saf/src/com/ibm/eserver/zos/racf/IRRPassTicket.java, saf, hbb7740 07/03/15 17:17:31";
    private static final String COPYRIGHT = "IBM Confidential\nObject Code Only Source Materials\n5694-A01\n(c) Copyright IBM Corp. 2005,2008\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private static final String CNAME = (class$com$ibm$eserver$zos$racf$IRRPassTicket == null ? (class$com$ibm$eserver$zos$racf$IRRPassTicket = IRRPassTicket.class$("com.ibm.eserver.zos.racf.IRRPassTicket")) : class$com$ibm$eserver$zos$racf$IRRPassTicket).getName();
    private static final String APARNUM = "HBB7750";
    private static final int IRR_SUCCESS = 0;
    private static final int IRR_BADTICKETOPTION = -1;
    private static final int IRR_NOUSERID = -2;
    private static final int IRR_BADUSERIDLENGTH = -3;
    private static final int IRR_NOAPPL = -4;
    private static final int IRR_BADAPPLLENGTH = -5;
    private static final int IRR_NOPT = -6;
    private static final int IRR_BADPTLENGTH = -7;
    private static final int IRR_NORETURNCODES = -8;
    private static final int IRR_BADRETURNCODESLENGTH = -9;
    static int RCLEN = 3;
    static int SAFRC = 0;
    static int RACFRC = 1;
    static int RACFRSN = 2;
    static int GENERATE = 1;
    static int EVALUATE = 2;
    static int MAXLEN = 8;
    private static Logger trc;
    private static IRRNLS nls;
    private IRRNativeTraceTable ttab = new IRRNativeTraceTable();
    private byte[] traceTableBytes;
    static /* synthetic */ Class class$com$ibm$eserver$zos$racf$IRRPassTicket;

    public IRRPassTicket() {
        trc = Logger.getLogger(CNAME, "com.ibm.eserver.zos.racf.nls.IRRTraceMessages");
        nls = new IRRNLS("com.ibm.eserver.zos.racf.nls.IRRExceptionMessages");
    }

    public String generate(String string, String string2) throws IRRPassTicketGenerationException {
        trc.entering(CNAME, "generate");
        int[] nArray = new int[RCLEN];
        StringBuffer stringBuffer = new StringBuffer("JUNKJUNK");
        this.RacfPassTicket(GENERATE, nArray, string, string2, stringBuffer);
        if (nArray[SAFRC] + nArray[RACFRC] + nArray[RACFRSN] > 0) {
            throw new IRRPassTicketGenerationException(nArray[SAFRC], nArray[RACFRC], nArray[RACFRSN]);
        }
        trc.exiting(CNAME, "generate");
        return stringBuffer.toString();
    }

    public void evaluate(String string, String string2, String string3) throws IRRPassTicketEvaluationException {
        trc.entering(CNAME, "evaluate");
        int[] nArray = new int[RCLEN];
        if (string3 == null || string3.length() <= 0 || string3.length() > MAXLEN) {
            throw new IllegalArgumentException(nls.getText("racf.e005_NULL_Parameter", new String("PassTicket")));
        }
        this.RacfPassTicket(EVALUATE, nArray, string, string2, new StringBuffer(string3));
        if (nArray[SAFRC] + nArray[RACFRC] + nArray[RACFRSN] > 0) {
            throw new IRRPassTicketEvaluationException(nArray[SAFRC], nArray[RACFRC], nArray[RACFRSN]);
        }
        trc.exiting(CNAME, "evaluate");
    }

    private void RacfPassTicket(int n, int[] nArray, String string, String string2, StringBuffer stringBuffer) throws IllegalStateException, IllegalArgumentException {
        trc.entering(CNAME, "RacfPassTicket");
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[8];
        int n2 = 0;
        this.traceTableBytes = (byte[])(trc.isLoggable(Level.FINER) ? this.ttab.createTraceTable() : null);
        try {
            if (string == null || string.length() <= 0 || string.length() > MAXLEN) {
                throw new IllegalArgumentException(nls.getText("racf.e005_NULL_Parameter", new String("Userid")));
            }
            byArray = string.trim().getBytes("CP1047");
            if (string2 == null || string2.length() <= 0 || string2.length() > MAXLEN) {
                throw new IllegalArgumentException(nls.getText("racf.e005_NULL_Parameter", new String("Application")));
            }
            byArray2 = string2.trim().getBytes("CP1047");
            if (stringBuffer == null || stringBuffer.length() <= 0 || stringBuffer.length() > MAXLEN) {
                throw new IllegalArgumentException(nls.getText("racf.e005_NULL_Parameter", new String("PassTicket")));
            }
            byArray3 = stringBuffer.toString().trim().getBytes("CP1047");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            IllegalStateException illegalStateException = new IllegalStateException(nls.getText("racf.e001_unable_to_encode_parm", IRRUtil.stackTrace2String(unsupportedEncodingException)));
            trc.throwing(CNAME, "RacfPassTicket", illegalStateException);
            throw illegalStateException;
        }
        try {
            n2 = this.doRACFPassTicket(nArray, n, this.traceTableBytes, byArray, byArray2, byArray3);
        }
        catch (Exception exception) {
            if (trc.isLoggable(Level.FINER)) {
                if (this.traceTableBytes != null) {
                    this.ttab.unload(trc);
                }
                trc.logp(Level.FINER, CNAME, "RacfPassTicket", "racf.i001_doRACFPassTicket", Integer.toString(n2));
            }
            IllegalStateException illegalStateException = new IllegalStateException(nls.getText("racf.e004_Unexpected_Exception", exception));
            trc.throwing(CNAME, "RacfPassTicket", illegalStateException);
            throw illegalStateException;
        }
        if (trc.isLoggable(Level.FINER)) {
            if (this.traceTableBytes != null) {
                this.ttab.unload(trc);
            }
            trc.logp(Level.FINER, CNAME, "RacfPassTicket", "racf.i001_doRACFPassTicket", Integer.toString(n2));
        }
        if (n2 < 0) {
            IllegalStateException illegalStateException = new IllegalStateException(nls.getText("racf.e002_internal_error_attempting_to_call_passticket", n2));
            trc.throwing(CNAME, "RacfPassTicket", illegalStateException);
            throw illegalStateException;
        }
        try {
            if (n == GENERATE && n2 == 0 && nArray[0] + nArray[1] + nArray[2] == 0) {
                stringBuffer.replace(0, MAXLEN, new String(byArray3, "CP1047").trim());
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            trc.logp(Level.FINER, CNAME, "RacfPassTicket", "smf.i002_sysProductOwner_create_failed", unsupportedEncodingException);
            IllegalStateException illegalStateException = new IllegalStateException(nls.getText("racf.e003_unable_to_encode_returned_passticket", IRRUtil.stackTrace2String(unsupportedEncodingException)));
            trc.throwing(CNAME, "RacfPassTicket", illegalStateException);
            throw illegalStateException;
        }
        trc.exiting(CNAME, "RacfPassTicket");
    }

    private native int doRACFPassTicket(int[] var1, int var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    String string = new String(System.getProperty("com.ibm.vm.bitmode"));
                    if (string.equals("64")) {
                        System.loadLibrary("IRRRacf64");
                        return null;
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (Exception exception) {
                    System.out.println(IRRUtil.stackTrace2String(exception));
                }
                try {
                    System.loadLibrary("IRRRacf");
                }
                catch (Exception exception) {
                    System.out.println("Exception caught " + exception);
                    System.out.println(IRRUtil.stackTrace2String(exception));
                }
                return null;
            }
        });
    }
}

