/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eserver.zos.racf.nls;

import com.ibm.eserver.zos.racf.util.IRRUtil;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IRRNLS {
    private ResourceBundle bundle;
    private String bundleName;
    private static final String SCCSID = "@(#)78  1.2 saf/src/com/ibm/eserver/zos/racf/nls/IRRNLS.java, saf, hbb7740 07/03/15 17:17:30";
    private static final String COPYRIGHT = "IBM Confidential\nObject Code Only Source Materials\n5694-A01\n(c) Copyright IBM Corp. 2005,2008\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private static final String CNAME = (class$com$ibm$eserver$zos$racf$nls$IRRNLS == null ? (class$com$ibm$eserver$zos$racf$nls$IRRNLS = IRRNLS.class$("com.ibm.eserver.zos.racf.nls.IRRNLS")) : class$com$ibm$eserver$zos$racf$nls$IRRNLS).getName();
    private static final String APARNUM = "HBB7750";
    private static Logger trc = Logger.getLogger(CNAME, "com.ibm.eserver.zos.racf.nls.IRRTraceMessages");
    private static final boolean DEBUG = IRRUtil.getDebugMode(CNAME);
    static /* synthetic */ Class class$com$ibm$eserver$zos$racf$nls$IRRNLS;

    public IRRNLS() {
    }

    public IRRNLS(String string) throws MissingResourceException {
        this.bundleName = string;
        try {
            this.bundle = ResourceBundle.getBundle(string);
        }
        catch (Exception exception) {
            trc.logp(Level.FINER, CNAME, "constructor-1", "nls.i001_unable_to_load_bundle", string);
            this.bundle = null;
            MissingResourceException missingResourceException = new MissingResourceException("Cannot load " + string + " resource bundle", string, "");
            trc.throwing(CNAME, "constructor-1", missingResourceException);
            throw missingResourceException;
        }
    }

    public String getText(String string) {
        return this.getText(string, null);
    }

    public String getText(String string, int n) {
        return this.getText(string, new Integer(n));
    }

    public String getText(String string, boolean bl) {
        return this.getText(string, (Object)bl);
    }

    public String getText(String string, byte by) {
        return this.getText(string, new Byte(by));
    }

    public String getText(String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return this.getText(string, objectArray);
    }

    public String getText(String string, Object[] objectArray) throws IllegalStateException {
        StringBuffer stringBuffer;
        String string2;
        block7: {
            string2 = null;
            stringBuffer = new StringBuffer();
            if (DEBUG) {
                trc.entering(CNAME, "getText", string);
            }
            if (this.bundle == null) {
                IllegalStateException illegalStateException = new IllegalStateException("Resource bundle not provided");
                trc.throwing(CNAME, "getText", illegalStateException);
                throw illegalStateException;
            }
            try {
                stringBuffer.append(this.bundle.getString(string));
            }
            catch (MissingResourceException missingResourceException) {
                if (trc.isLoggable(Level.FINER)) {
                    Object[] objectArray2 = new String[]{string, this.bundleName};
                    trc.logp(Level.FINER, CNAME, "getText", "nls.i002_unable_to_find_key", objectArray2);
                }
                stringBuffer.append(string);
                if (objectArray == null) break block7;
                for (int i = 0; i < objectArray.length; ++i) {
                    stringBuffer.append(" {");
                    stringBuffer.append(i);
                    stringBuffer.append("}");
                }
            }
        }
        string2 = objectArray != null ? MessageFormat.format(stringBuffer.toString(), objectArray) : stringBuffer.toString();
        if (DEBUG) {
            trc.exiting(CNAME, "getText", string2);
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

