/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eserver.zos.racf.trace;

import com.ibm.eserver.zos.racf.nls.IRRNLS;
import com.ibm.eserver.zos.racf.util.IRRUtil;
import com.ibm.misc.HexDumpEncoder;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IRRNativeTraceTable {
    private static final String SCCSID = "@(#)81  1.2 saf/src/com/ibm/eserver/zos/racf/trace/IRRNativeTraceTable.java, saf, hbb7740 07/03/15 17:17:30";
    private static final String COPYRIGHT = "IBM Confidential\nObject Code Only Source Materials\n5694-A01\n(c) Copyright IBM Corp. 2005,2008\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private static final String CNAME = (class$com$ibm$eserver$zos$racf$trace$IRRNativeTraceTable == null ? (class$com$ibm$eserver$zos$racf$trace$IRRNativeTraceTable = IRRNativeTraceTable.class$("com.ibm.eserver.zos.racf.trace.IRRNativeTraceTable")) : class$com$ibm$eserver$zos$racf$trace$IRRNativeTraceTable).getName();
    private static final String APARNUM = "HBB7750";
    private static Logger trc = Logger.getLogger(CNAME, "com.ibm.eserver.zos.racf.nls.IRRTraceMessages");
    private static final boolean DEBUG = IRRUtil.getDebugMode(CNAME);
    private static IRRNLS nls = new IRRNLS("com.ibm.eserver.zos.racf.nls.IRRExceptionMessages");
    private static final int DEFAULT_TRACE_ENTRY_SIZE = 128;
    private static final int MAX_TRACE_ENTRY_SIZE = 1024;
    private static final int MIN_TRACE_ENTRY_SIZE = 128;
    private static final int DEFAULT_TRACE_TABLE_SIZE = 100;
    private static final int MAX_TRACE_TABLE_SIZE = 1000;
    private static final int MIN_TRACE_TABLE_SIZE = 10;
    private int traceEntrySize = 128;
    private int traceTableSize = 100;
    private static final int INTEGER_SIZE = 4;
    private byte[] traceTable;
    static /* synthetic */ Class class$com$ibm$eserver$zos$racf$trace$IRRNativeTraceTable;

    public IRRNativeTraceTable() {
    }

    public IRRNativeTraceTable(int n) {
        this.traceTableSize = n;
    }

    public IRRNativeTraceTable(int n, int n2) {
        this.traceTableSize = n;
        this.traceEntrySize = n2;
    }

    public static int getDefaultTraceTableSize() {
        return 100;
    }

    public static int getDefaultTraceEntrySize() {
        return 128;
    }

    public static int getMaxTraceEntrySize() {
        return 1024;
    }

    public static int getMaxTraceTableSize() {
        return 1000;
    }

    public static int getMinTraceEntrySize() {
        return 128;
    }

    public static int getMinTraceTableSize() {
        return 10;
    }

    public int getTraceEntrySize() {
        return this.traceEntrySize;
    }

    public void setTraceEntrySize(int n) {
        this.traceEntrySize = n;
    }

    public int getTraceTableSize() {
        return this.traceTableSize;
    }

    public void setTraceTableSize(int n) {
        this.traceTableSize = n;
    }

    public byte[] getTraceTable() {
        return this.traceTable;
    }

    public byte[] createTraceTable() {
        return this.createTraceTable(0);
    }

    public byte[] createTraceTable(int n) throws IllegalArgumentException {
        byte[] byArray;
        if (DEBUG && trc.isLoggable(Level.FINER)) {
            trc.entering(CNAME, "createTraceTable");
        }
        if (n > 0) {
            this.traceTableSize = n;
        }
        if (this.traceEntrySize == 0) {
            this.traceEntrySize = 128;
        }
        if (this.traceTableSize == 0) {
            this.traceTableSize = 100;
        }
        if (this.traceEntrySize > 1024) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(nls.getText("trace.e001_trace_entry_too_large"));
            trc.throwing(CNAME, "createTraceTable", illegalArgumentException);
            throw illegalArgumentException;
        }
        if (this.traceTableSize > 1000) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(nls.getText("trace.e002_trace_table_too_large"));
            trc.throwing(CNAME, "createTraceTable", illegalArgumentException);
            throw illegalArgumentException;
        }
        if (this.traceEntrySize < 128) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(nls.getText("trace.e003_trace_entry_too_small"));
            trc.throwing(CNAME, "createTraceTable", illegalArgumentException);
            throw illegalArgumentException;
        }
        if (this.traceTableSize < 10) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(nls.getText("trace.e004_trace_table_too_small"));
            trc.throwing(CNAME, "createTraceTable", illegalArgumentException);
            throw illegalArgumentException;
        }
        int n2 = this.traceEntrySize * (this.traceTableSize + 1);
        this.traceTable = new byte[n2];
        int n3 = 0;
        try {
            byArray = "IRRTTH  ".getBytes("CP1047");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = "IRRTTH  ".getBytes();
        }
        System.arraycopy(byArray, 0, this.traceTable, 0, byArray.length);
        n3 = 8;
        this.copyInt(this.traceTable, this.traceEntrySize, n3);
        this.copyInt(this.traceTable, this.traceEntrySize, n3 += 4);
        this.copyInt(this.traceTable, this.traceEntrySize * this.traceTableSize, n3 += 4);
        this.copyInt(this.traceTable, this.traceEntrySize * this.traceTableSize, n3 += 4);
        if (DEBUG && trc.isLoggable(Level.FINEST)) {
            byte[] byArray2 = new byte[this.traceEntrySize];
            System.arraycopy(this.traceTable, 0, byArray2, 0, byArray2.length);
            String string = new HexDumpEncoder().encodeBuffer(byArray2);
            trc.logp(Level.FINEST, CNAME, "createTraceTable", "trace.i003_native_trace_header", string);
        }
        if (DEBUG && trc.isLoggable(Level.FINER)) {
            trc.exiting(CNAME, "createTraceTable");
        }
        return this.traceTable;
    }

    private void copyInt(byte[] byArray, int n, int n2) throws IllegalArgumentException {
        BigInteger bigInteger = new BigInteger(Integer.toString(n));
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2.length == 0 || byArray2.length > 4 || byArray2[0] == 45) {
            Object[] objectArray = new String[]{Integer.toString(n), bigInteger.toString()};
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(nls.getText("trace.e005_cannot_convert_value", objectArray));
            trc.throwing(CNAME, "copyInt", illegalArgumentException);
            throw illegalArgumentException;
        }
        for (int i = n2; i < n2 + 4; ++i) {
            byArray[i] = 0;
        }
        System.arraycopy(byArray2, 0, byArray, n2 + (4 - byArray2.length), byArray2.length);
    }

    public void unload() {
        this.unload(null);
    }

    public void unload(Logger logger) {
        Object object;
        Logger logger2;
        if (!trc.isLoggable(Level.FINER)) {
            return;
        }
        if (DEBUG) {
            trc.entering(CNAME, "unload");
        }
        if ((logger2 = logger) == null) {
            logger2 = trc;
        }
        if (DEBUG && trc.isLoggable(Level.FINEST)) {
            object = new HexDumpEncoder().encodeBuffer(this.traceTable);
            trc.logp(Level.FINEST, CNAME, "unload", "trace.i002_native_trace_table", object);
        }
        object = new NativeTraceFormatter(this);
        ListIterator listIterator = ((NativeTraceFormatter)object).getTraceList();
        while (listIterator.hasNext()) {
            NativeTraceRecord nativeTraceRecord = (NativeTraceRecord)listIterator.next();
            String string = nativeTraceRecord.toString();
            logger.logp(Level.FINER, CNAME, "unload", "trace.i001_native", string);
        }
        if (DEBUG) {
            trc.exiting(CNAME, "unload");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NativeTraceRecord
    implements Comparable {
        private String tteType = "";
        private String tteFilename = "";
        private String tteMeth = "";
        private int tteLineno;
        private int tteNo;
        private int tteLen;
        private String tteData = null;
        private byte[] tteDataBytes = null;

        public NativeTraceRecord() {
        }

        public NativeTraceRecord(byte[] byArray) {
            byte[] byArray2 = new byte[2];
            System.arraycopy(byArray, 50, byArray2, 0, 2);
            BigInteger bigInteger = new BigInteger(byArray2);
            this.tteNo = bigInteger.intValue();
            if (this.tteNo != 0) {
                byArray2 = new byte[2];
                System.arraycopy(byArray, 48, byArray2, 0, 2);
                bigInteger = new BigInteger(byArray2);
                this.tteLen = bigInteger.intValue();
                byArray2 = new byte[4];
                System.arraycopy(byArray, 44, byArray2, 0, 4);
                bigInteger = new BigInteger(byArray2);
                this.tteLineno = bigInteger.intValue();
                try {
                    this.tteType = new String(byArray, 0, 4, "CP1047").trim();
                    this.tteFilename = new String(byArray, 4, 16, "CP1047").trim();
                    this.tteMeth = new String(byArray, 20, 24, "CP1047").trim();
                    if (this.tteLen > 0) {
                        this.tteDataBytes = new byte[this.tteLen];
                        System.arraycopy(byArray, 52, this.tteDataBytes, 0, this.tteLen);
                        if (!this.tteType.equals("BYTE")) {
                            this.tteData = new String(byArray, 52, this.tteLen, "CP1047");
                        }
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }

        public boolean isRecordValid() {
            return this.tteNo != 0;
        }

        public int getTteNo() {
            return this.tteNo;
        }

        public void setTteNo(int n) {
            this.tteNo = n;
        }

        public String getTteType() {
            return this.tteType;
        }

        public void setTteType(String string) {
            this.tteType = string;
        }

        public String getTteFilename() {
            return this.tteFilename;
        }

        public void setTteFilename(String string) {
            this.tteFilename = string;
        }

        public String getTteMethod() {
            return this.tteMeth;
        }

        public void setTteMeth(String string) {
            this.tteMeth = string;
        }

        public int getTteLineno() {
            return this.tteLineno;
        }

        public void setTteLineno(int n) {
            this.tteLineno = n;
        }

        public int compareTo(Object object) throws ClassCastException {
            if (!(object instanceof NativeTraceRecord)) {
                throw new ClassCastException();
            }
            int n = this.tteNo == ((NativeTraceRecord)object).getTteNo() ? 0 : (this.tteNo > ((NativeTraceRecord)object).getTteNo() ? 1 : -1);
            return n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Seq ");
            stringBuffer.append(this.tteNo);
            stringBuffer.append(" type ");
            stringBuffer.append(this.tteType);
            stringBuffer.append(" at ");
            stringBuffer.append(this.tteFilename);
            stringBuffer.append(":");
            stringBuffer.append(this.tteMeth);
            stringBuffer.append(".");
            stringBuffer.append(this.tteLineno);
            if (this.tteLen > 0) {
                stringBuffer.append(" ");
                if (this.tteData != null) {
                    stringBuffer.append(this.tteData);
                } else {
                    stringBuffer.append(IRRUtil.toHexString(this.tteDataBytes));
                }
            }
            return stringBuffer.toString();
        }
    }

    private class NativeTraceFormatter {
        private IRRNativeTraceTable ttab;
        private ArrayList traceList = new ArrayList();
        private ListIterator list;

        public NativeTraceFormatter(IRRNativeTraceTable iRRNativeTraceTable2) {
            this.ttab = iRRNativeTraceTable2;
            if (iRRNativeTraceTable2 != null) {
                this.createTraceList();
                if (!this.traceList.isEmpty()) {
                    Collections.sort(this.traceList);
                }
            }
        }

        public ListIterator getTraceList() {
            return this.traceList.listIterator();
        }

        private void createTraceList() {
            byte[] byArray = new byte[this.ttab.getTraceEntrySize()];
            int n = this.ttab.getTraceEntrySize();
            int n2 = this.ttab.getTraceTableSize();
            for (int i = 0; i < n2; ++i) {
                System.arraycopy(this.ttab.getTraceTable(), n, byArray, 0, this.ttab.getTraceEntrySize());
                NativeTraceRecord nativeTraceRecord = new NativeTraceRecord(byArray);
                if (nativeTraceRecord.isRecordValid()) {
                    this.traceList.add(nativeTraceRecord);
                }
                n += this.ttab.getTraceEntrySize();
            }
        }
    }
}

