/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.common.util;

import com.ibm.urbancode.zos.common.util.SystemEnv;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayExecutor;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayXMLInput;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayXMLResponse;
import com.ibm.urbancode.zos.ispf.gateway.common.ServiceType;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class RexxExecutor {
    private static final String TSO_EX = "TSO EX";
    private static final String SPACE = " ";
    private static final String SINGLE_QUOTE = "'";
    private final String dsnPrefix;
    private final String ispfGatewayBinariesPath;

    public RexxExecutor(String dsnPrefix, String ispfGatewayBinariesPath) {
        this.dsnPrefix = dsnPrefix;
        this.ispfGatewayBinariesPath = ispfGatewayBinariesPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IspfGatewayXMLResponse execute(String rexxDataset, String rexxArguments) throws Exception {
        IspfGatewayXMLResponse ispfGatewayXMLResponse;
        try {
            String command = this.getCommandForIspfGateway(rexxDataset, rexxArguments);
            IspfGatewayXMLInput ispfGatewayXMLInput = new IspfGatewayXMLInput(ServiceType.ISPF, command);
            IspfGatewayExecutor ispfGatewayExecutor = new IspfGatewayExecutor(this.ispfGatewayBinariesPath, ispfGatewayXMLInput);
            ispfGatewayExecutor.setEnvironmentVars(this.getEnvironmentVariables());
            ispfGatewayXMLResponse = ispfGatewayExecutor.execute();
        }
        finally {
            DatasetHelper.deleteDataset(rexxDataset);
        }
        return ispfGatewayXMLResponse;
    }

    private String getCommandForIspfGateway(String rexxDataset, String rexxArguments) {
        return "TSO EX '" + rexxDataset + SINGLE_QUOTE + SPACE + SINGLE_QUOTE + rexxArguments + SINGLE_QUOTE;
    }

    private Map<String, String> getEnvironmentVariables() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("ISPF_LOG_DIR", SystemEnv.getBuzToolkitHome() + "/var/log/ispf");
        env.put("PATH", SystemEnv.getBuzToolkitHome() + "/conf/toolkit" + File.pathSeparator + this.ispfGatewayBinariesPath + File.pathSeparator + this.getCurrentEnvPath());
        env.put("CGI_ISPPREF", this.dsnPrefix);
        return env;
    }

    private String getCurrentEnvPath() {
        return System.getenv("PATH") == null ? "" : System.getenv("PATH");
    }
}

