/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.dataset.util;

import com.ibm.jzos.RecordWriter;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZUtil;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public final class RexxFileToDatasetConvertor {
    private static final int DATASET_LRECL = 144;

    private RexxFileToDatasetConvertor() {
    }

    public static void convert(String filePath, String dataset) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(filePath));){
            int spaceInTracks = FileHelper.getFileSizeInTracks(filePath);
            RexxFileToDatasetConvertor.createDataset(dataset, spaceInTracks);
            RexxFileToDatasetConvertor.writeRexxLinesToDataset(bufferedReader, dataset);
        }
        catch (Exception exception) {
            DatasetHelper.deleteDataset(dataset);
            throw exception;
        }
    }

    private static void createDataset(String dataset, int spaceInTracks) {
        String fullyQualifiedDsn = ZFile.getFullyQualifiedDSN((String)dataset, (boolean)true);
        String tempDD = ZFile.allocDummyDDName();
        ZFile.bpxwdyn((String)("alloc fi(" + tempDD + ") da(" + fullyQualifiedDsn + ") dsorg(ps) lrecl(" + 144 + ") recfm(v,b) tracks space(" + spaceInTracks + "," + spaceInTracks + ") blksize(" + 1440 + ") reuse new catalog msg(wtp)"));
        ZFile.bpxwdyn((String)("free fi(" + tempDD + ") msg(wtp)"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRexxLinesToDataset(BufferedReader bufferedReader, String dataset) throws IOException {
        RecordWriter recordWriter = RecordWriter.newWriter((String)ZFile.getSlashSlashQuotedDSN((String)dataset, (boolean)true), (int)1);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                byte[] bytes = line.getBytes(ZUtil.getDefaultPlatformEncoding());
                recordWriter.write(bytes, 0, bytes.length);
            }
        }
        finally {
            recordWriter.close();
            recordWriter.flush();
        }
    }
}

