/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFileException;
import com.ibm.team.enterprise.deployment.dataset.record.DatasetRecord;
import com.ibm.team.enterprise.deployment.dataset.record.DatasetRecordsWriter;
import com.ibm.urbancode.zos.common.util.DeleteRecordsGenerator;
import com.ibm.urbancode.zos.common.util.PluginFilesHelper;
import com.ibm.urbancode.zos.common.util.RexxExecutor;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.ibm.urbancode.zos.dataset.util.RexxFileToDatasetConvertor;
import com.ibm.urbancode.zos.dataset.util.TempDsnNameHelper;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayXMLResponse;
import com.urbancode.air.plugin.inputs.DeleteDatasetInputs;
import java.util.List;
import java.util.Properties;

public class DeleteDataset {
    private int exitCode = 0;
    private final Properties inputProperties;

    public DeleteDataset(Properties inputProperties, Properties ignoredOutputProperties) {
        this.inputProperties = inputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int execute() {
        block7: {
            String tempActionDsn = null;
            try {
                DeleteDatasetInputs pluginInput = new DeleteDatasetInputs(this.inputProperties);
                pluginInput.validateInputs();
                List<DatasetRecord> deleteRecords = DeleteRecordsGenerator.generate(pluginInput);
                tempActionDsn = TempDsnNameHelper.getActionDsnName(pluginInput.getDsnPrefix());
                DatasetRecordsWriter.write(deleteRecords, tempActionDsn);
                String rexxDataset = TempDsnNameHelper.getRexxDsnName(pluginInput.getDsnPrefix());
                String rexxFilePath = PluginFilesHelper.getDeploymentRexxFilePath();
                RexxFileToDatasetConvertor.convert(rexxFilePath, rexxDataset);
                RexxExecutor rexxExecutor = new RexxExecutor(pluginInput.getDsnPrefix(), pluginInput.getIspfGatewayBinariesPath());
                IspfGatewayXMLResponse ispfGatewayXMLResponse = rexxExecutor.execute(rexxDataset, tempActionDsn);
                System.out.print(ispfGatewayXMLResponse.getOutputText());
                this.exitCode = Integer.parseInt(ispfGatewayXMLResponse.getReturnCode());
                this.deleteDataset(tempActionDsn);
            }
            catch (RuntimeException runtimeException) {
                this.handleRuntimeExceptions(runtimeException);
                this.exitCode = 1;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.exitCode = 1;
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.deleteDataset(tempActionDsn);
            }
        }
        return this.exitCode;
    }

    private void handleRuntimeExceptions(Exception exception) {
        if (exception instanceof RcException) {
            exception.printStackTrace();
        } else {
            System.out.println(" [Error] " + exception.getMessage());
        }
    }

    private void deleteDataset(String dataset) {
        try {
            DatasetHelper.deleteDataset(dataset);
        }
        catch (ZFileException e) {
            e.printStackTrace();
            this.exitCode = 1;
        }
    }
}

