/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.allocate;

import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.urbancode.air.plugin.inputs.InputsValidator;
import com.urbancode.air.plugin.inputs.InvalidInputException;
import java.util.Properties;

public class AllocateDatasetSmsInputs {
    public static final String DATASET_NAME = "datasetName";
    public static final String DELETE_DATASET = "deleteDataset";
    public static final String MANAGEMENT_CLASS = "managementClass";
    public static final String STORAGE_CLASS = "storageClass";
    public static final String DATA_CLASS = "dataClass";
    private final String datasetName;
    private final boolean isDeleteDatasetEnabled;
    private final String managementClass;
    private final String storageClass;
    private final String dataClass;

    public AllocateDatasetSmsInputs(Properties inputProperties) {
        this.datasetName = DatasetHelper.determineFullyQualifiedDsn(inputProperties.getProperty(DATASET_NAME));
        this.isDeleteDatasetEnabled = Boolean.parseBoolean(inputProperties.getProperty(DELETE_DATASET));
        this.managementClass = inputProperties.getProperty(MANAGEMENT_CLASS).trim();
        this.storageClass = inputProperties.getProperty(STORAGE_CLASS).trim();
        this.dataClass = inputProperties.getProperty(DATA_CLASS).trim();
    }

    public void validate() {
        InputsValidator.checkIfEmpty(this.datasetName, "Dataset Name");
        if (this.managementClass.isEmpty() && this.storageClass.isEmpty() && this.dataClass.isEmpty()) {
            throw new InvalidInputException("At least one class needs to be specified.");
        }
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public boolean isDeleteDatasetEnabled() {
        return this.isDeleteDatasetEnabled;
    }

    public String getManagementClass() {
        return this.managementClass;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public String getDataClass() {
        return this.dataClass;
    }
}

