/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.replacetoken;

import com.ibm.jzos.RecordReader;
import com.ibm.jzos.RecordWriter;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZUtil;
import com.ibm.teamz.build.ant.jni.ISPFStatistics;
import com.ibm.urbancode.zos.common.util.GenericHelper;
import com.ibm.urbancode.zos.common.util.StringHelper;
import com.ibm.urbancode.zos.common.util.SystemEnv;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.ibm.urbancode.zos.dataset.util.DsInfo;
import com.urbancode.air.plugin.command.replacetoken.DatasetTruncateException;
import com.urbancode.air.plugin.command.replacetoken.ReplaceTokensMVSInputs;
import com.urbancode.air.plugin.inputs.InvalidInputException;
import com.urbancode.air.plugin.inputs.MissingInputException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;

public class ReplaceTokensMVS {
    private static final String CURRENT_WORK_DIR = ".";
    private static final String TEMP_DIR_PREFIX = "replaceToken";
    private static final String JAVA_LIBRARY_PATH = "java.library.path";
    private static final String LIB_NATIVE_PATH = "lib/native";
    private final Properties inputProperties;

    public ReplaceTokensMVS(Properties inputProperties, Properties ignoredOutputProperties) {
        this.inputProperties = inputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws Exception {
        try {
            ReplaceTokensMVSInputs pluginInputs = ReplaceTokensMVSInputs.getValidatedInputs(this.inputProperties);
            String workDir = this.getTempWorkDirectory();
            this.updateJavaLibraryPathWithPluginLibraries();
            HashMap<String, String> replaceTokens = new HashMap<String, String>();
            if (!pluginInputs.getEnvPropValues().isEmpty()) {
                replaceTokens.putAll(this.getEnvironmentProperties(pluginInputs));
            }
            if (!pluginInputs.getExplicitTokens().isEmpty()) {
                replaceTokens.putAll(this.getExplicitTokens(pluginInputs.getExplicitTokens()));
            }
            if (replaceTokens.isEmpty()) {
                System.out.println("No properties or explicit tokens to replace.");
                return 0;
            }
            LinkedHashSet<String> datasets = this.filter(pluginInputs.getIncludes(), pluginInputs.getExcludes());
            System.out.println("Replace token in following files:");
            for (String dataset : datasets) {
                System.out.println(ZFile.getFullyQualifiedDSN((String)dataset));
            }
            HashMap<String, Integer> fileStatus = new HashMap<String, Integer>();
            int noOfOccurrences = 0;
            int fileCnt = 0;
            for (String dsnName : datasets) {
                RecordReader reader = null;
                File tempFile = new File(workDir, dsnName);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), ZUtil.getDefaultPlatformEncoding());
                StringBuilder fileDataBuilder = new StringBuilder();
                String fileData = "";
                try {
                    int bytesRead;
                    reader = RecordReader.newReader((String)dsnName, (int)1);
                    byte[] recordBuf = new byte[reader.getLrecl()];
                    String myRec = "";
                    while ((bytesRead = reader.read(recordBuf)) > 0) {
                        myRec = new String(recordBuf, 0, bytesRead, ZUtil.getDefaultPlatformEncoding());
                        fileDataBuilder.append(myRec).append("\n");
                    }
                    fileData = fileDataBuilder.toString();
                    int fileOccurences = 0;
                    for (String propertyKey : replaceTokens.keySet()) {
                        String propertyValue = (String)replaceTokens.get(propertyKey);
                        fileOccurences += StringHelper.countMatches(fileData, propertyKey);
                        fileData = fileData.replace(propertyKey, propertyValue);
                    }
                    writer.write(fileData);
                    fileStatus.put(dsnName, fileOccurences);
                    if (fileOccurences <= 0) continue;
                    ++fileCnt;
                    noOfOccurrences += fileOccurences;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (ZFileException zfe) {
                            zfe.printStackTrace();
                            System.exit(1);
                        }
                    }
                    if (writer == null) continue;
                    try {
                        writer.flush();
                        writer.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
            }
            System.out.println("  [replace] Replaced " + noOfOccurrences + " occurrences in " + fileCnt + " files.");
            for (String fileName : datasets) {
                File tempFile = new File(workDir, fileName);
                if ((Integer)fileStatus.get(fileName) <= 0) continue;
                System.out.println("Apply changes to " + fileName);
                ISPFStatistics ispfstats = this.getISPFStats(fileName);
                RecordWriter target = RecordWriter.newWriter((String)fileName, (int)1);
                BufferedReader output = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tempFile), ZUtil.getDefaultPlatformEncoding()));
                byte[] recBuf = null;
                int lineCounts = 1;
                DsInfo dsInfo = new DsInfo(fileName);
                boolean isDatasetTruncated = false;
                try {
                    String line;
                    while ((line = output.readLine()) != null) {
                        String record = String.format("%-" + dsInfo.getAvailableRecordLength() + "s", line.replaceAll("\\s+$", ""));
                        recBuf = record.getBytes(ZUtil.getDefaultPlatformEncoding());
                        if (recBuf.length > dsInfo.getAvailableRecordLength()) {
                            isDatasetTruncated = true;
                            System.out.println("Warning: line " + lineCounts + " of " + fileName + " excceeds " + dsInfo.getAvailableRecordLength() + " bytes and will be truncated.");
                            System.out.println(" " + lineCounts + " of " + fileName + ": " + line);
                            target.write(recBuf, 0, dsInfo.getAvailableRecordLength());
                        } else {
                            target.write(recBuf, 0, recBuf.length);
                        }
                        ++lineCounts;
                    }
                    output.close();
                    tempFile.delete();
                    target.close();
                    if (ispfstats != null) {
                        this.updateISPFStats(ispfstats, --lineCounts, 0);
                    }
                    if (!isDatasetTruncated || !pluginInputs.isFailOnTruncate()) continue;
                    throw new DatasetTruncateException("Failed for truncated.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            return 0;
        }
        catch (DatasetTruncateException | InvalidInputException | MissingInputException knownRuntimeException) {
            System.out.println(" [Error] " + knownRuntimeException.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    private Map<String, String> getExplicitTokens(String inputExplicitTokens) throws IOException {
        HashMap<String, String> explicitTokens = new HashMap<String, String>();
        try (BufferedReader reader = new BufferedReader(new StringReader(inputExplicitTokens));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split("->", 2);
                String propName = parts[0];
                String propValue = parts.length == 2 ? parts[1] : "";
                propName = this.convertStringToDefaultEncoding(propName);
                propValue = this.convertStringToDefaultEncoding(propValue);
                explicitTokens.put(propName, propValue);
            }
        }
        return explicitTokens;
    }

    private Map<String, String> getEnvironmentProperties(ReplaceTokensMVSInputs pluginInputs) throws UnsupportedEncodingException {
        String[] properties;
        HashMap<String, String> envProperties = new HashMap<String, String>();
        if (!pluginInputs.getPropertyPrefix().isEmpty()) {
            System.out.println("Looking for properties starting with " + pluginInputs.getPropertyPrefix());
        }
        for (String property : properties = pluginInputs.getEnvPropValues().split("(?<=(^|[^\\\\])(\\\\{2}){0,8}),")) {
            String propertyValue;
            String[] parts = property.split("(?<=(^|[^\\\\])(\\\\{2}){0,8})=", 2);
            String propertyName = parts[0];
            String string = propertyValue = parts.length == 2 ? parts[1] : "";
            if (GenericHelper.isNullOrEmpty(propertyName)) continue;
            propertyName = propertyName.replace("\\=", "=").replace("\\,", ",").replace("\\\\", "\\");
            propertyValue = propertyValue.replace("\\=", "=").replace("\\,", ",").replace("\\\\", "\\");
            if (!GenericHelper.isNullOrEmpty(pluginInputs.getPropertyPrefix()) && !propertyName.startsWith(pluginInputs.getPropertyPrefix())) continue;
            propertyName = this.convertStringToDefaultEncoding(pluginInputs.getStartDelimiter() + propertyName + pluginInputs.getEndDelimiter());
            propertyValue = this.convertStringToDefaultEncoding(propertyValue);
            envProperties.put(propertyName, propertyValue);
        }
        return envProperties;
    }

    private void updateJavaLibraryPathWithPluginLibraries() {
        String javaLibPath = System.getProperty(JAVA_LIBRARY_PATH);
        String newJavaLibPath = SystemEnv.getPluginHome() + File.separator + LIB_NATIVE_PATH + File.pathSeparator + javaLibPath;
        System.setProperty(JAVA_LIBRARY_PATH, newJavaLibPath);
    }

    private String getTempWorkDirectory() throws IOException {
        String currentWorkingDir = new File(CURRENT_WORK_DIR).getCanonicalPath();
        File tempDir = Files.createTempDirectory(Paths.get(currentWorkingDir, new String[0]), TEMP_DIR_PREFIX, new FileAttribute[0]).toFile();
        tempDir.deleteOnExit();
        return tempDir.getCanonicalPath();
    }

    public LinkedHashSet<String> filter(String include, String exclude) throws Exception {
        String[] items;
        int i;
        String[] line;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (!GenericHelper.isNullOrEmpty(include)) {
            line = include.split("\\s|,");
            for (i = 0; i < line.length; ++i) {
                String inputMBRPattern;
                items = new String[2];
                if (!GenericHelper.isNullOrEmpty(line[i])) {
                    items = line[i].split("\\(|\\)");
                }
                String includeDSPattern = items.length > 0 ? items[0] : "";
                String string = inputMBRPattern = items.length > 1 ? items[1] : "";
                if (GenericHelper.isNullOrEmpty(includeDSPattern)) continue;
                Map<String, String> dsHelper = DatasetHelper.searchNonVsamDataset(includeDSPattern);
                for (Map.Entry<String, String> mapElement : dsHelper.entrySet()) {
                    result.addAll(DatasetHelper.getMembers(mapElement.getKey().toString(), mapElement.getValue().toString(), inputMBRPattern));
                }
            }
        }
        if (!GenericHelper.isNullOrEmpty(exclude)) {
            line = exclude.split("\\s|,");
            for (i = 0; i < line.length; ++i) {
                items = line[i].split("\\(|\\)");
                String excludeDSPattern = items.length > 0 ? items[0] : null;
                String excludeMBRPattern = items.length > 1 ? items[1] : "*";
                String pattern = DatasetHelper.makeRegexPattren(excludeDSPattern + "(" + excludeMBRPattern + ")");
                LinkedHashSet<String> deleteList = new LinkedHashSet<String>();
                for (String fileName : result) {
                    if (!fileName.matches("^.*" + pattern + ".*$")) continue;
                    deleteList.add(fileName);
                }
                result.removeAll(deleteList);
            }
        }
        return result;
    }

    public ISPFStatistics getISPFStats(String name) throws Exception {
        if (!name.startsWith("//'") || !name.endsWith(")'")) {
            return null;
        }
        name = name.substring(3, name.length() - 1);
        String dataset = name.substring(0, name.indexOf("("));
        String member = name.substring(name.indexOf("(") + 1, name.length() - 1);
        ISPFStatistics stats = new ISPFStatistics(dataset, member);
        return stats;
    }

    public boolean updateISPFStats(ISPFStatistics stats, int currentLines, int modifiedLines) {
        if (stats == null) {
            return false;
        }
        try {
            Calendar cal = Calendar.getInstance();
            stats.setModificationDate(cal.getTime());
            stats.setModifiedLines(modifiedLines);
            stats.setCurrentLines(currentLines);
            stats.setUserId(ZUtil.getCurrentUser());
            stats.save();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private String convertStringToDefaultEncoding(String str) throws UnsupportedEncodingException {
        byte[] bytes = str.getBytes(ZUtil.getDefaultPlatformEncoding());
        return new String(bytes);
    }
}

