/* REXX */
/*%STUB CALLCMD*/
/*********************************************************************/
/* Copyright:    Licensed Materials - Property of IBM and/or HCL     */
/*                                                                   */
/*        Copyright IBM Corporation. All rights reserved             */
/*        Copyright HCL Technologies limited. All rights reserved    */
/*                                                                   */
/*        US Government Users Restricted Rights -                    */
/*        Use, duplication or disclosure restricted by               */
/*        GSA ADP Schedule Contract with IBM Corp.                   */
/*                                                                   */
/*********************************************************************/
parse arg inputDataset

/* Read dataset records into a stem variable */
drop records.
Address TSO "ALLOC F(INPUTDSN)  DA('"inputDataset"') SHR REUSE"
Address TSO "EXECIO * DISKR INPUTDSN (STEM records. FINIS)"
execioRc = rc
x = Msg('off')
    Address TSO "FREE F(INPUTDSN)"
x = Msg('on')
if execioRc <> 0 then do
    say " [Error] EXECIO failed for dataset" inputDataset "with rc" execioRc
    call ExitProgram(execioRc)
end

do n = 1 to records.0
    parse upper var records.n pdsName ";" member ";" timestamp ";" user .
    Address ISPEXEC "LMINIT DATAID(UDID) DATASET('"pdsName"') ENQ(SHRW)"
    if rc <> 0 then do
        say "The LMINIT function failed for dataset" pdsName "with return code :" rc
        Call ExitProgram(rc)
    end

    Address ISPEXEC "CONTROL ERRORS RETURN"

    do forever
        parse var timestamp modifiedDate modifiedTime
        Address ISPEXEC "LMMSTATS DATAID(&UDID) MEMBER("member") USER("user")" ||,
                "MODDATE4("modifiedDate") MODTIME("modifiedTime") CREATED4("modifiedDate") "
        lmmstatsRc = rc
        If (lmmstatsRc <> 0) then do
            Address ISPEXEC "LMFREE DATAID(&UDID)"
            if rc <> 0 then do
                say "The LMFREE function failed with return code :" rc
                call ExitProgram(rc)
            end
            say "The LMMSTATS function failed for member" member " with return code :" lmmstatsRc
            call ExitProgram(lmmstatsRc)
        end

        if n == records.0 then
            leave // exit loop if it is the last record

        n = n + 1

        parse upper var records.n nextPdsName ";" nextMember ";" nextTimestamp ";" nextUser .
        if pdsName <> nextPdsName then do
            n = n - 1
            leave // exit loop if the next pdsName is not equals to the current pdsName
        end

        member = nextMember
        timestamp = nextTimestamp
        user = nextUser
    end

    Address ISPEXEC "CONTROL ERRORS CANCEL"

    Address ISPEXEC "LMFREE DATAID(&UDID)"
    if rc <> 0 then do
        say "The LMFREE function failed with return code :" rc
        call ExitProgram(rc)
    end

end

exit /* Program Exit */

ExitProgram :
    Parse arg returnCode
    ZISPFRC = returnCode
    Address ISPEXEC "VPUT (ZISPFRC) SHARED"
Exit returnCode
