/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.rexx;

import com.ibm.urbancode.zos.common.util.Console;
import com.ibm.urbancode.zos.common.util.SystemEnv;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.ibm.urbancode.zos.dataset.util.TempDsnNameHelper;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayExecutor;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayXMLInput;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayXMLResponse;
import com.ibm.urbancode.zos.ispf.gateway.common.ServiceType;
import com.ibm.urbancode.zos.rexx.RexxFileToDatasetConvertor;
import com.ibm.urbancode.zos.rexx.RexxNonZeroRcException;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public final class RexxExecutor {
    private static final String PATH = "PATH";
    private static final String ISPF_LOG_DIR = "ISPF_LOG_DIR";
    private static final String CGI_ISPPREF = "CGI_ISPPREF";
    private static final String CGI_CEATSO = "CGI_CEATSO";
    private static final String LEGACY_ISPF_GATEWAY = "FALSE";
    private static final String TSO_EX = "TSO EX";
    private static final String SPACE = " ";
    private static final String SINGLE_QUOTE = "'";
    private final String dsnPrefix;
    private final String ispfGatewayBinariesPath;

    public RexxExecutor(String dsnPrefix, String ispfGatewayBinariesPath) {
        this.dsnPrefix = dsnPrefix;
        this.ispfGatewayBinariesPath = ispfGatewayBinariesPath;
    }

    public void execute(String rexxFilePath, String rexxArguments) throws Exception {
        IspfGatewayXMLResponse ispfGatewayXMLResponse = this.executeProgram(rexxFilePath, rexxArguments);
        Console.printProcessOutput(ispfGatewayXMLResponse.getOutputText());
        if (ispfGatewayXMLResponse.getReturnCode() > 0) {
            Path path = Paths.get(rexxFilePath, new String[0]);
            String rexxProgram = path.getFileName().toString();
            throw new RexxNonZeroRcException("Program " + rexxProgram + " failed, check ISPF logs.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IspfGatewayXMLResponse executeProgram(String rexxFilePath, String rexxArguments) throws Exception {
        String rexxDataset = TempDsnNameHelper.getRexxDsnName(this.dsnPrefix);
        try {
            RexxFileToDatasetConvertor.convert(rexxFilePath, rexxDataset);
            String command = this.getCommandForIspfGateway(rexxDataset, rexxArguments);
            IspfGatewayXMLInput ispfGatewayXMLInput = new IspfGatewayXMLInput(ServiceType.ISPF, command);
            IspfGatewayExecutor ispfGatewayExecutor = new IspfGatewayExecutor(this.ispfGatewayBinariesPath, ispfGatewayXMLInput);
            ispfGatewayExecutor.setEnvironmentVars(this.getEnvironmentVariables());
            IspfGatewayXMLResponse ispfGatewayXMLResponse = ispfGatewayExecutor.execute();
            return ispfGatewayXMLResponse;
        }
        finally {
            DatasetHelper.deleteDataset(rexxDataset);
        }
    }

    private String getCommandForIspfGateway(String rexxDataset, String rexxArguments) {
        return "TSO EX '" + rexxDataset + SINGLE_QUOTE + SPACE + SINGLE_QUOTE + rexxArguments + SINGLE_QUOTE;
    }

    private Map<String, String> getEnvironmentVariables() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put(ISPF_LOG_DIR, SystemEnv.getBuzToolkitHome() + "/var/log/ispf");
        env.put(PATH, SystemEnv.getBuzToolkitHome() + "/conf/toolkit" + File.pathSeparator + this.ispfGatewayBinariesPath + File.pathSeparator + this.getCurrentEnvPath());
        env.put(CGI_ISPPREF, this.dsnPrefix);
        env.put(CGI_CEATSO, LEGACY_ISPF_GATEWAY);
        return env;
    }

    private String getCurrentEnvPath() {
        return System.getenv(PATH) == null ? "" : System.getenv(PATH);
    }
}

