/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.urbancode.zos.common.util.DeploymentFilesHelper;
import com.ibm.urbancode.zos.deploy.xml.utils.DeploymentResultHelper;
import com.ibm.urbancode.zos.deploy.xml.utils.PackageManifest;
import com.ibm.urbancode.zos.deploy.xml.utils.RollbackManifest;
import com.ibm.urbancode.zos.generate.artifact.info.ArtifactInfo;
import com.ibm.urbancode.zos.generate.artifact.info.DeploymentAction;
import com.ibm.urbancode.zos.generate.artifact.info.FilterInputs;
import com.ibm.urbancode.zos.generate.artifact.info.Filters;
import com.ibm.urbancode.zos.generate.artifact.info.LoopType;
import com.ibm.urbancode.zos.generate.artifact.info.utils.CustomPropertiesParser;
import com.ibm.urbancode.zos.generate.artifact.info.utils.PackageManifestDownloader;
import com.urbancode.air.plugin.inputs.GenerateInfoInputs;
import com.urbancode.air.plugin.inputs.InvalidInputException;
import com.urbancode.air.plugin.inputs.MissingInputException;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;

public class GenerateVersionArtifactInfo {
    private final Properties inputProperties;
    private final Properties outputProperties;
    private GenerateInfoInputs pluginInputs;

    public GenerateVersionArtifactInfo(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        try {
            this.pluginInputs = GenerateInfoInputs.getValidatedInputs(this.inputProperties);
            if (!this.isVersionDeployed()) {
                this.ignoreTargetDatasetIfExist();
                this.ignoreDeployActionIfExist();
            }
            PackageManifest packageManifest = this.getPackageManifest().sort(this.pluginInputs.getOrderBy());
            Optional<RollbackManifest> rollbackManifest = this.getRollbackManifest();
            Filters filters = this.buildFilters();
            ArtifactInfo artifactInfo = rollbackManifest.isPresent() ? ArtifactInfo.generate((Filters)filters, (PackageManifest)packageManifest, (RollbackManifest)rollbackManifest.get()) : ArtifactInfo.generate((Filters)filters, (PackageManifest)packageManifest);
            this.printGeneratedTextToConsole(artifactInfo.getText());
            this.setOutputProperties(artifactInfo);
            if (this.pluginInputs.isFailOnEmpty() && artifactInfo.getText().trim().isEmpty()) {
                throw new RuntimeException("Step failed because Fail On Empty is checked and the generation result is empty.");
            }
            return 0;
        }
        catch (InvalidInputException | MissingInputException | IllegalArgumentException exception) {
            System.out.println(" [Error] " + exception.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 1;
    }

    private Filters buildFilters() {
        FilterInputs filterInputs = new FilterInputs(this.pluginInputs.getLoopType(), this.pluginInputs.getTemplate());
        filterInputs.setSourceContainer(this.pluginInputs.getSourceContainer());
        filterInputs.setTargetDataset(this.pluginInputs.getTargetDataset());
        filterInputs.setDeployType(this.pluginInputs.getDeployType());
        filterInputs.setResource(this.pluginInputs.getResourceName());
        if (this.pluginInputs.isIgnoreUnresolved()) {
            filterInputs.setIgnoreUnresolved();
        }
        Map customPropertiesMap = CustomPropertiesParser.parseIntoMap((String)this.pluginInputs.getCustomPropertyLines());
        filterInputs.setCustomProperties(customPropertiesMap);
        String deploymentActionValue = this.pluginInputs.getDeployAction();
        if (!deploymentActionValue.isEmpty()) {
            DeploymentAction deploymentAction = this.convertToEnum(deploymentActionValue);
            filterInputs.setDeploymentAction(deploymentAction);
        }
        return filterInputs;
    }

    private DeploymentAction convertToEnum(String deploymentActionValue) {
        try {
            return DeploymentAction.valueOf((String)deploymentActionValue.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("ERROR: Invalid value '" + deploymentActionValue + "' Action value can be either 'created' or 'updated'.");
        }
    }

    private Optional<RollbackManifest> getRollbackManifest() throws XMLStreamException, IOException {
        if (this.isRollbackManifestOperationsNeeded()) {
            return Optional.of(DeploymentResultHelper.getRollbackStructure((String)this.pluginInputs.getDeployBasePath(), (String)this.pluginInputs.getResourceId(), (String)this.pluginInputs.getComponentName(), (String)this.pluginInputs.getVersionName()));
        }
        return Optional.empty();
    }

    private boolean isRollbackManifestOperationsNeeded() {
        if (!this.pluginInputs.getDeployAction().isEmpty()) {
            return true;
        }
        return this.pluginInputs.getLoopType() == LoopType.DeletedMemberExcludingMissingMembers;
    }

    private boolean isVersionDeployed() {
        return DeploymentResultHelper.checkVersionDeployed((String)this.pluginInputs.getDeployBasePath(), (String)this.pluginInputs.getResourceId(), (String)this.pluginInputs.getComponentName(), (String)this.pluginInputs.getVersionName());
    }

    private void ignoreTargetDatasetIfExist() {
        if (!this.pluginInputs.getTargetDataset().isEmpty()) {
            System.out.println("Warning: Target Dataset Name Filter ignored because version " + this.pluginInputs.getVersionName() + " is not deployed");
            this.pluginInputs.ignoreTargetDataset();
        }
    }

    private void ignoreDeployActionIfExist() {
        if (!this.pluginInputs.getDeployAction().isEmpty()) {
            System.out.println("Warning: Deployment Action Filter ignored because version " + this.pluginInputs.getVersionName() + " is not deployed");
            this.pluginInputs.ignoreDeployAction();
        }
    }

    private PackageManifest getPackageManifest() throws Exception {
        if (this.isVersionDeployed()) {
            return DeploymentResultHelper.getDeployedPackageManifest((String)this.pluginInputs.getDeployBasePath(), (String)this.pluginInputs.getResourceId(), (String)this.pluginInputs.getComponentName(), (String)this.pluginInputs.getVersionName());
        }
        String versionWorkingDir = DeploymentFilesHelper.getVersionDirPathInWorkingDir(this.pluginInputs.getVersionName(), this.pluginInputs.getResourceId());
        PackageManifestDownloader.download((String)this.pluginInputs.getComponentName(), (String)this.pluginInputs.getVersionName(), (String)versionWorkingDir);
        String manifestFilePath = DeploymentFilesHelper.getFilePathInWorkingDir(this.pluginInputs.getVersionName(), this.pluginInputs.getResourceId(), "packageManifest.xml");
        return PackageManifest.from((String)manifestFilePath);
    }

    private void printGeneratedTextToConsole(String text) {
        System.out.println();
        System.out.println("Output text:");
        System.out.println("========================================================================================================================");
        System.out.println(text);
        System.out.println("========================================================================================================================");
    }

    private void setOutputProperties(ArtifactInfo artifactInfo) {
        this.outputProperties.setProperty("text", artifactInfo.getText());
        this.outputProperties.setProperty("count", Long.toString(artifactInfo.getCount()));
    }
}

