/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.allocate.steps;

import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.urbancode.air.plugin.inputs.InputsValidator;
import java.util.Properties;

class AllocateDatasetInputs {
    public static final String DEFAULT_DIRECTORY_BLOCKS = "0";
    public static final String DATA_SET_NAME = "dataSetName";
    public static final String DELETE_DATASET = "deleteDataset";
    public static final String VOLUME_SERIAL = "volumeSerial";
    public static final String PRIMARY_QUANTITY = "primaryQuantity";
    public static final String SECONDARY_QUANTITY = "secondaryQuantity";
    public static final String DIRECTORY_BLOCKS = "directoryBlocks";
    public static final String RECORD_LENGTH = "recordLength";
    public static final String BLOCK_SIZE = "blockSize";
    public static final String SPACE_UNIT = "spaceUnit";
    public static final String AVER_REC_UNIT = "averRecUnit";
    public static final String RECORD_FORMAT = "recordFormat";
    public static final String DATA_SET_NAME_TYPE = "dataSetNameType";
    public static final String DEFAULT_VALUE = "---";
    private final String datasetName;
    private final boolean isDeleteDatasetEnabled;
    private final String volumeSerial;
    private final String primaryQuantity;
    private final String secondaryQuantity;
    private final String directoryBlocks;
    private final String recordLength;
    private final String blockSize;
    private final String spaceUnit;
    private final String averageRECUnit;
    private final String recordFormat;
    private final String dataSetNameType;

    private AllocateDatasetInputs(Properties inputProperties) {
        this.datasetName = DatasetHelper.determineFullyQualifiedDsn(inputProperties.getProperty(DATA_SET_NAME));
        this.isDeleteDatasetEnabled = Boolean.parseBoolean(inputProperties.getProperty(DELETE_DATASET));
        this.volumeSerial = inputProperties.getProperty(VOLUME_SERIAL).trim();
        this.primaryQuantity = inputProperties.getProperty(PRIMARY_QUANTITY).trim();
        this.secondaryQuantity = inputProperties.getProperty(SECONDARY_QUANTITY).trim();
        String directoryBlocksInput = inputProperties.getProperty(DIRECTORY_BLOCKS).trim();
        this.directoryBlocks = directoryBlocksInput.isEmpty() ? DEFAULT_DIRECTORY_BLOCKS : directoryBlocksInput;
        this.recordLength = inputProperties.getProperty(RECORD_LENGTH).trim();
        this.blockSize = inputProperties.getProperty(BLOCK_SIZE).trim();
        this.spaceUnit = inputProperties.getProperty(SPACE_UNIT);
        String avgRec = inputProperties.getProperty(AVER_REC_UNIT);
        this.averageRECUnit = avgRec.equals(DEFAULT_VALUE) ? "" : avgRec;
        this.recordFormat = inputProperties.getProperty(RECORD_FORMAT);
        String dsnType = inputProperties.getProperty(DATA_SET_NAME_TYPE);
        this.dataSetNameType = dsnType.equals(DEFAULT_VALUE) ? "" : dsnType;
    }

    public static AllocateDatasetInputs getValidatedInputs(Properties inputProperties) {
        AllocateDatasetInputs pluginInputs = new AllocateDatasetInputs(inputProperties);
        pluginInputs.validateInputs();
        return pluginInputs;
    }

    private void validateInputs() {
        InputsValidator.checkIfEmpty(this.datasetName, "Dataset Name");
        InputsValidator.checkIfEmpty(this.primaryQuantity, "Primary Quantity");
        InputsValidator.checkIfEmpty(this.secondaryQuantity, "Secondary Quantity");
        InputsValidator.checkIfEmpty(this.recordLength, "Record Length");
        InputsValidator.checkIfEmpty(this.blockSize, "Block Size");
        InputsValidator.checkForPositiveInteger(this.primaryQuantity, "Primary Quantity");
        InputsValidator.checkForPositiveInteger(this.secondaryQuantity, "Secondary Quantity");
        InputsValidator.checkForPositiveInteger(this.recordLength, "Record Length");
        InputsValidator.checkForPositiveInteger(this.blockSize, "Block Size");
        InputsValidator.checkForPositiveInteger(this.directoryBlocks, "Directory Blocks");
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public boolean isDeleteDatasetEnabled() {
        return this.isDeleteDatasetEnabled;
    }

    public String getVolumeSerial() {
        return this.volumeSerial;
    }

    public String getPrimaryQuantity() {
        return this.primaryQuantity;
    }

    public String getSecondaryQuantity() {
        return this.secondaryQuantity;
    }

    public String getDirectoryBlocks() {
        return this.directoryBlocks;
    }

    public String getRecordLength() {
        return this.recordLength;
    }

    public String getBlockSize() {
        return this.blockSize;
    }

    public String getSpaceUnit() {
        return this.spaceUnit;
    }

    public String getAverageRECUnit() {
        return this.averageRECUnit;
    }

    public String getRecordFormat() {
        return this.recordFormat;
    }

    public String getDataSetNameType() {
        return this.dataSetNameType;
    }
}

