/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.jcl;

import java.util.ArrayList;
import java.util.List;

public final class TokensUtil {
    private static final String LINE_BREAK = "\n";
    private static final String TWO_FORWARD_SLASHES = "//";
    private static final String NEWLINE_WITH_TWO_FORWARD_SLASHES = "\n//";
    private static final String TWO_FORWARD_SLASHES_WITH_NEWLINE = "//\n";

    private TokensUtil() {
    }

    public static List<String> loadTokenGroupsIntoList(String jclTokenGroups) {
        String[] tokenGroups;
        if (jclTokenGroups.startsWith(TWO_FORWARD_SLASHES_WITH_NEWLINE)) {
            jclTokenGroups = TokensUtil.removeStartingDoubleSlashesLine(jclTokenGroups);
        }
        ArrayList<String> jclTokenGroupsList = new ArrayList<String>();
        for (String tokenGroup : tokenGroups = jclTokenGroups.split(NEWLINE_WITH_TWO_FORWARD_SLASHES)) {
            if ((tokenGroup = tokenGroup.trim()).isEmpty()) continue;
            jclTokenGroupsList.add(tokenGroup);
        }
        return jclTokenGroupsList;
    }

    private static String removeStartingDoubleSlashesLine(String jclTokenGroups) {
        return jclTokenGroups.substring(TWO_FORWARD_SLASHES_WITH_NEWLINE.length());
    }
}

