/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.restore.backup;

import com.ibm.jzos.ZFileException;
import com.ibm.team.enterprise.deployment.dataset.record.DatasetRecord;
import com.ibm.team.enterprise.deployment.dataset.record.DatasetRecordsWriter;
import com.ibm.team.enterprise.deployment.dataset.record.DeploymentRecord;
import com.ibm.team.enterprise.deployment.dataset.record.PdsUpdateRecordBuilder;
import com.ibm.team.enterprise.deployment.dataset.record.SeqUpdateRecordBuilder;
import com.ibm.team.enterprise.deployment.dataset.record.XmitReceiveRecord;
import com.ibm.team.enterprise.deployment.mappings.DatasetMapper;
import com.ibm.team.enterprise.deployment.toolkit.manifest.ProcessExecutor;
import com.ibm.urbancode.zos.common.util.AgentInstalledProperties;
import com.ibm.urbancode.zos.common.util.Console;
import com.ibm.urbancode.zos.common.util.DeploymentFilesHelper;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.common.util.PluginFilesHelper;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.ibm.urbancode.zos.dataset.util.TempDsnNameHelper;
import com.ibm.urbancode.zos.deploy.xml.utils.ContainerType;
import com.ibm.urbancode.zos.deploy.xml.utils.RollbackContainer;
import com.ibm.urbancode.zos.deploy.xml.utils.RollbackManifest;
import com.ibm.urbancode.zos.rexx.RexxExecutor;
import com.urbancode.air.plugin.command.restore.backup.DatasetMapping;
import com.urbancode.air.plugin.command.restore.backup.RestoreBackupDatasetsInputs;
import com.urbancode.air.plugin.inputs.InvalidInputException;
import com.urbancode.air.plugin.inputs.MissingInputException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;

public class RestoreBackupDatasets {
    private static final String COMMA = ",";
    private static final String BIN_EXTENSION = ".bin";
    private final Properties inputProperties;
    private RestoreBackupDatasetsInputs pluginInputs;
    private String versionWorkDirectory = null;

    public RestoreBackupDatasets(Properties inputProperties, Properties ignoredOutputProperties) {
        this.inputProperties = inputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws Exception {
        int exitCode = 0;
        try {
            this.pluginInputs = RestoreBackupDatasetsInputs.getValidatedInputs(this.inputProperties);
            this.versionWorkDirectory = DeploymentFilesHelper.getVersionDirPathInWorkingDir(this.pluginInputs.getVersionName(), this.pluginInputs.getResourceId());
            this.setupVersionWorkDirectory();
            this.copyBackupZipToVersionWorkDirectory();
            Map<String, RollbackContainer> backupDatasets = this.getBackupDatasetsFromRollbackManifest();
            RestoreBackupDatasets.printBackupDatasetsToConsole(backupDatasets);
            List<DatasetMapping> datasetMappings = this.getDatasetMapping(backupDatasets);
            if (datasetMappings.isEmpty()) {
                throw new InvalidInputException("No mapping found for the backup datasets");
            }
            if (!this.pluginInputs.isCreateDatasetAllowed()) {
                this.checkIfTargetDatasetsExist(datasetMappings);
            }
            ProcessExecutor.extractUsingPaxCommand(this.versionWorkDirectory, "backup.zip");
            this.printRestoreDatasetInfoToConsole(datasetMappings);
            this.xmitSourceBinFilesToTempDatasets(datasetMappings);
            this.copyTempDatasetsToTargetDatasets(datasetMappings);
        }
        catch (InvalidInputException | MissingInputException exception) {
            System.out.println(" [Error] " + exception.getMessage());
            exitCode = 1;
        }
        finally {
            if (this.versionWorkDirectory != null) {
                FileHelper.cleanDirectory(this.versionWorkDirectory);
            }
        }
        return exitCode;
    }

    private void setupVersionWorkDirectory() throws IOException {
        if (FileHelper.isDirectoryExist(this.versionWorkDirectory)) {
            this.deleteWorkDirectory();
        }
        this.createVersionWorkDirectory();
    }

    private void deleteWorkDirectory() throws IOException {
        Console.printActionTitle("Deleting version working directory - " + this.versionWorkDirectory);
        FileHelper.cleanDirectory(this.versionWorkDirectory);
    }

    private void createVersionWorkDirectory() {
        Console.printActionTitle("Creating version working directory - " + this.versionWorkDirectory);
        if (!new File(this.versionWorkDirectory).mkdirs()) {
            throw new IllegalArgumentException("Failed to create version working directory " + this.versionWorkDirectory);
        }
    }

    private void copyBackupZipToVersionWorkDirectory() throws IOException {
        String versionDeployBasePath = this.getVersionDeployBasePath();
        String backupZipFilePath = this.getBackupZipFilePath(versionDeployBasePath);
        String backupFilePathInWorkDir = this.versionWorkDirectory + File.separator + "backup.zip";
        FileHelper.copyFile(backupZipFilePath, backupFilePathInWorkDir);
    }

    private String getVersionDeployBasePath() {
        String versionDeployBasePath = DeploymentFilesHelper.getVersionDeployBasePath(this.pluginInputs.getDeployBasePath(), this.pluginInputs.getResourceId(), this.pluginInputs.getComponentName(), this.pluginInputs.getVersionName());
        if (FileHelper.isDirectoryNotExist(versionDeployBasePath)) {
            throw new MissingInputException("Version deploy base path " + versionDeployBasePath + " does not exist. Restore step runs for only deployed component version.");
        }
        return versionDeployBasePath;
    }

    private String getBackupZipFilePath(String versionDeployBasePath) {
        String backupZipFilePath = versionDeployBasePath + File.separator + "backup.zip";
        if (FileHelper.isFileNotExist(backupZipFilePath)) {
            throw new MissingInputException("Backup File " + backupZipFilePath + " does not exist. Restore step runs for only deployed component version with backup enabled during deployment.");
        }
        return backupZipFilePath;
    }

    private Map<String, RollbackContainer> getBackupDatasetsFromRollbackManifest() throws XMLStreamException, IOException {
        HashMap<String, RollbackContainer> backupDatasets = new HashMap<String, RollbackContainer>();
        String rollbackManifestPath = this.getVersionDeployBasePath() + File.separator + "rollbackManifest.xml";
        RollbackManifest rollbackManifest = RollbackManifest.from((String)rollbackManifestPath);
        Map deletedContainersMap = rollbackManifest.getDeletedContainersMap();
        for (String deletedContainer : deletedContainersMap.keySet()) {
            RollbackContainer rollbackContainer = (RollbackContainer)deletedContainersMap.get(deletedContainer);
            if (this.isMissingDeletedSequentialContainer(rollbackContainer)) continue;
            backupDatasets.put(deletedContainer, rollbackContainer);
        }
        backupDatasets.putAll(rollbackManifest.getUpdatedContainersMap());
        return backupDatasets;
    }

    private boolean isMissingDeletedSequentialContainer(RollbackContainer rollbackContainer) {
        return rollbackContainer.getType() == ContainerType.SEQUENTIAL && rollbackContainer.isMissing();
    }

    private static void printBackupDatasetsToConsole(Map<String, RollbackContainer> backupDatasets) {
        Console.printActionTitle("Datasets present in backup - ");
        for (String dataset : backupDatasets.keySet()) {
            Console.printProcessOutput(dataset);
        }
        System.out.println();
    }

    private List<DatasetMapping> getDatasetMapping(Map<String, RollbackContainer> backupDatasets) {
        DatasetMapper datasetMapper = DatasetMapper.from(this.pluginInputs.getDatasetMapping());
        LinkedHashMap<String, String> mappingWithoutWildCard = datasetMapper.getSourceToTargetMapWithoutWildcard();
        LinkedHashMap<String, String> mappingWithWildcard = datasetMapper.getSourceToTargetMapWithWildcard();
        ArrayList<DatasetMapping> datasetMappings = new ArrayList<DatasetMapping>();
        for (String dataset : backupDatasets.keySet()) {
            String tempXmitDsn = TempDsnNameHelper.getXmitDsnName(this.pluginInputs.getTempDsnPrefix());
            RollbackContainer source = backupDatasets.get(dataset);
            if (mappingWithoutWildCard.containsKey(dataset)) {
                datasetMappings.add(new DatasetMapping(source, (String)mappingWithoutWildCard.get(dataset), tempXmitDsn));
                continue;
            }
            Optional<String> target = this.getMappedTarget(dataset, mappingWithWildcard);
            if (target.isPresent()) {
                datasetMappings.add(new DatasetMapping(source, target.get(), tempXmitDsn));
                continue;
            }
            Console.printProcessOutput("Skipping restore for dataset " + dataset + " as target mapping not found.");
        }
        return datasetMappings;
    }

    private void checkIfTargetDatasetsExist(List<DatasetMapping> datasetMappings) throws ZFileException {
        List<String> targetDatasets = datasetMappings.stream().map(DatasetMapping::getTarget).collect(Collectors.toList());
        if (!DatasetHelper.areDatasetsExist(targetDatasets)) {
            throw new InvalidInputException("Restore failed because target dataset is not found and Allow Creating Data Set is set to false.");
        }
    }

    private void printRestoreDatasetInfoToConsole(List<DatasetMapping> datasetMappings) {
        System.out.println();
        for (DatasetMapping datasetMapping : datasetMappings) {
            Console.printProcessOutput("Restoring dataset " + datasetMapping.getSource().getName() + " to " + datasetMapping.getTarget());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void xmitSourceBinFilesToTempDatasets(List<DatasetMapping> datasetMappings) throws Exception {
        String xmitInputDataset = this.createInputDatasetForXmitProgram(datasetMappings);
        String rexxArguments = this.getXmitReceiverRexxArguments(xmitInputDataset);
        try {
            RexxExecutor rexxExecutor = new RexxExecutor(this.pluginInputs.getTempDsnPrefix(), this.pluginInputs.getIspfGatewayBinariesPath());
            rexxExecutor.execute(PluginFilesHelper.getXmitReceiverRexxFilePath(), rexxArguments);
        }
        finally {
            DatasetHelper.deleteDataset(xmitInputDataset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyTempDatasetsToTargetDatasets(List<DatasetMapping> datasetMappings) throws Exception {
        String tempActionDataset = TempDsnNameHelper.getActionDsnName(this.pluginInputs.getTempDsnPrefix());
        try {
            List<DatasetRecord> actionRecords = this.createActionRecords(datasetMappings);
            DatasetRecordsWriter.write(actionRecords, tempActionDataset);
            RexxExecutor rexxExecutor = new RexxExecutor(this.pluginInputs.getTempDsnPrefix(), this.pluginInputs.getIspfGatewayBinariesPath());
            rexxExecutor.execute(PluginFilesHelper.getDeploymentRexxFilePath(), tempActionDataset);
        }
        finally {
            DatasetHelper.deleteDataset(tempActionDataset);
            for (DatasetMapping datasetMapping : datasetMappings) {
                DatasetHelper.deleteDataset(datasetMapping.getTempXmitDataset());
            }
        }
    }

    private List<DatasetRecord> createActionRecords(List<DatasetMapping> datasetMappings) {
        ArrayList<DatasetRecord> datasetRecords = new ArrayList<DatasetRecord>();
        for (DatasetMapping datasetMapping : datasetMappings) {
            DeploymentRecord datasetRecord;
            if (datasetMapping.getSource().getType() == ContainerType.PDS) {
                datasetRecord = new PdsUpdateRecordBuilder().withSourceDsn(datasetMapping.getTempXmitDataset()).withTargetDsn(datasetMapping.getTarget()).build();
                datasetRecords.add(datasetRecord);
                continue;
            }
            if (datasetMapping.getSource().getType() != ContainerType.SEQUENTIAL) continue;
            datasetRecord = new SeqUpdateRecordBuilder().withSourceDsn(datasetMapping.getTempXmitDataset()).withTargetDsn(datasetMapping.getTarget()).build();
            datasetRecords.add(datasetRecord);
        }
        return datasetRecords;
    }

    private Optional<String> getMappedTarget(String dataset, Map<String, String> mappingWithWildcard) {
        for (String sourceWithRegEx : mappingWithWildcard.keySet()) {
            if (!dataset.matches(sourceWithRegEx)) continue;
            return Optional.of(mappingWithWildcard.get(sourceWithRegEx));
        }
        return Optional.empty();
    }

    private String createInputDatasetForXmitProgram(List<DatasetMapping> datasetMappings) throws IOException {
        ArrayList<DatasetRecord> datasetRecords = new ArrayList<DatasetRecord>();
        for (DatasetMapping datasetMapping : datasetMappings) {
            String xmitBinFileName = datasetMapping.getSource().getName() + BIN_EXTENSION;
            String xmitBinFilePath = this.versionWorkDirectory + File.separator + xmitBinFileName;
            long fileSizeInBytes = FileHelper.getFileSizeInBytes(xmitBinFilePath);
            XmitReceiveRecord xmitReceiveRecord = new XmitReceiveRecord(xmitBinFileName, fileSizeInBytes, datasetMapping.getTempXmitDataset());
            datasetRecords.add(xmitReceiveRecord);
        }
        String xmitInputDataset = TempDsnNameHelper.getXmitProgramInputDsnName(this.pluginInputs.getTempDsnPrefix());
        DatasetRecordsWriter.write(datasetRecords, xmitInputDataset);
        return xmitInputDataset;
    }

    private String getXmitReceiverRexxArguments(String xmitInputFile) {
        AgentInstalledProperties agentInstalledProperties = new AgentInstalledProperties();
        return this.versionWorkDirectory + COMMA + xmitInputFile + COMMA + agentInstalledProperties.getSysoutClass() + COMMA + agentInstalledProperties.getTempUnit() + COMMA + agentInstalledProperties.getTempVolser();
    }
}

