/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.xml.utils;

import com.ibm.urbancode.zos.deploy.xml.utils.ContainerType;
import com.ibm.urbancode.zos.deploy.xml.utils.Resource;
import com.ibm.urbancode.zos.deploy.xml.utils.RollbackContainer;
import com.ibm.urbancode.zos.deploy.xml.utils.XmlHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class RollbackManifest {
    private static final String CREATED_TAG = "created";
    private static final String UPDATED_TAG = "updated";
    private static final String DELETED_TAG = "deleted";
    private final Map<String, RollbackContainer> createdContainersMap = new HashMap<String, RollbackContainer>();
    private final Map<String, RollbackContainer> updatedContainersMap = new HashMap<String, RollbackContainer>();
    private final Map<String, RollbackContainer> deletedContainersMap = new HashMap<String, RollbackContainer>();
    private Map<String, RollbackContainer> datasetMap = new HashMap<String, RollbackContainer>();
    private RollbackContainer container = null;
    private String actionName = null;
    private boolean isInsideActionTag = false;
    private boolean isInsidePDSContainer = false;

    private RollbackManifest() {
    }

    public static RollbackManifest from(String rollbackManifestPath) throws IOException, XMLStreamException {
        RollbackManifest rollbackManifest = new RollbackManifest();
        try (InputStream inputStream = Files.newInputStream(Paths.get(rollbackManifestPath, new String[0]), new OpenOption[0]);){
            rollbackManifest.parse(inputStream);
        }
        return rollbackManifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream rollbackInputStream) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newFactory();
        try (XMLStreamReader xmlStreamReader = null;){
            xmlStreamReader = inputFactory.createXMLStreamReader(rollbackInputStream, XmlHelper.getFileEncoding());
            while (xmlStreamReader.hasNext()) {
                int next = xmlStreamReader.next();
                if (next == 1) {
                    this.processStartElement(xmlStreamReader);
                    continue;
                }
                if (next != 2) continue;
                this.processEndElement(xmlStreamReader);
            }
        }
    }

    private void processStartElement(XMLStreamReader xmlStreamReader) {
        String nodeName = xmlStreamReader.getLocalName().trim();
        if (this.isActionTag(nodeName)) {
            this.isInsideActionTag = true;
            this.actionName = nodeName;
        } else if (this.isInsideActionTag) {
            if ("container".equalsIgnoreCase(nodeName)) {
                this.processContainerTag(xmlStreamReader);
            } else if ("resource".equalsIgnoreCase(nodeName) && this.isInsidePDSContainer) {
                this.processResourceTag(xmlStreamReader);
            }
        }
    }

    private void processContainerTag(XMLStreamReader xmlStreamReader) {
        String containerName = XmlHelper.getAttributeValue(xmlStreamReader, "name");
        ContainerType containerType = XmlHelper.getContainerType(xmlStreamReader, containerName);
        if (containerType == ContainerType.PDS) {
            this.isInsidePDSContainer = true;
            RollbackContainer rollbackContainer = new RollbackContainer(containerName, containerType);
            this.container = this.datasetMap.getOrDefault(containerName, rollbackContainer);
        } else {
            this.isInsidePDSContainer = false;
            if (containerType == ContainerType.SEQUENTIAL) {
                this.container = new RollbackContainer(containerName, containerType);
                if (this.isInsideDeletedActionTag() && this.hasMissingAttribute(xmlStreamReader)) {
                    this.container.setMissing();
                }
            }
        }
    }

    private void processResourceTag(XMLStreamReader xmlStreamReader) {
        String resourceName = XmlHelper.getAttributeValue(xmlStreamReader, "name");
        Resource resource = new Resource(resourceName);
        if (this.isInsideDeletedActionTag() && this.hasMissingAttribute(xmlStreamReader)) {
            resource.setMissing();
        }
        this.container.addResourceToMap(resource);
    }

    private void processEndElement(XMLStreamReader xmlStreamReader) {
        String endNodeName = xmlStreamReader.getLocalName().trim();
        if (this.isActionTag(endNodeName)) {
            this.actionName = null;
            this.isInsideActionTag = false;
            this.isInsidePDSContainer = false;
            this.datasetMap = new HashMap<String, RollbackContainer>();
        } else if ("container".equalsIgnoreCase(endNodeName)) {
            if (this.isInsidePDSContainer) {
                this.datasetMap.put(this.container.getName(), this.container);
                this.isInsidePDSContainer = false;
            }
            this.addContainerToMap(this.container);
            this.container = null;
        }
    }

    private void addContainerToMap(RollbackContainer container) {
        if (this.actionName.equalsIgnoreCase(CREATED_TAG)) {
            this.createdContainersMap.put(container.getName(), container);
        } else if (this.actionName.equalsIgnoreCase(UPDATED_TAG)) {
            this.updatedContainersMap.put(container.getName(), container);
        } else {
            this.deletedContainersMap.put(container.getName(), container);
        }
    }

    private boolean isActionTag(String nodeName) {
        return CREATED_TAG.equalsIgnoreCase(nodeName) || UPDATED_TAG.equalsIgnoreCase(nodeName) || DELETED_TAG.equalsIgnoreCase(nodeName);
    }

    private boolean isInsideDeletedActionTag() {
        return DELETED_TAG.equalsIgnoreCase(this.actionName);
    }

    private boolean hasMissingAttribute(XMLStreamReader xmlStreamReader) {
        return Boolean.parseBoolean(XmlHelper.getAttributeValue(xmlStreamReader, "missing"));
    }

    public Map<String, RollbackContainer> getCreatedContainersMap() {
        return Collections.unmodifiableMap(this.createdContainersMap);
    }

    public Map<String, RollbackContainer> getUpdatedContainersMap() {
        return Collections.unmodifiableMap(this.updatedContainersMap);
    }

    public Map<String, RollbackContainer> getDeletedContainersMap() {
        return Collections.unmodifiableMap(this.deletedContainersMap);
    }
}

