/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields;

import com.ibm.jzos.fields.BigDecimalAccessor;
import com.ibm.jzos.fields.BinaryAsBigIntegerField;
import java.math.BigDecimal;

public class BinaryAsBigDecimalField
extends BinaryAsBigIntegerField
implements BigDecimalAccessor {
    private int scale;

    public BinaryAsBigDecimalField(int offset, int length, int scale, boolean signed) {
        super(offset, length, signed);
        if (scale < 0) {
            throw new IllegalArgumentException("scale must be >= 0");
        }
        this.scale = scale;
    }

    public BigDecimal getBigDecimal(byte[] buffer) {
        return this.getBigDecimal(buffer, 0);
    }

    public BigDecimal getBigDecimal(byte[] buffer, int bufOffset) {
        return new BigDecimal(super.getBigInteger(buffer, bufOffset), this.scale);
    }

    public void putBigDecimal(BigDecimal value, byte[] buffer) throws IllegalArgumentException {
        this.putBigDecimal(value, buffer, 0);
    }

    public void putBigDecimal(BigDecimal value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        BigDecimal bd = value.setScale(this.scale, 1);
        super.putBigInteger(bd.unscaledValue(), buffer, bufOffset);
    }

    public boolean equals(BigDecimal a, BigDecimal b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }

    public int getScale() {
        return this.scale;
    }
}

