/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.mappings;

import com.ibm.team.enterprise.deployment.mappings.InvalidDatasetMappingException;
import com.ibm.team.enterprise.deployment.mappings.MappingHelper;
import java.util.LinkedHashMap;

public class DatasetMapper {
    private final LinkedHashMap<String, String> sourceToTargetMapWithWildcard = new LinkedHashMap();
    private final LinkedHashMap<String, String> sourceToTargetMapWithoutWildcard = new LinkedHashMap();
    private final String datasetMapping;

    private DatasetMapper(String datasetMapping) {
        this.datasetMapping = datasetMapping;
    }

    public static DatasetMapper from(String datasetMapping) {
        DatasetMapper datasetMapper = new DatasetMapper(datasetMapping);
        datasetMapper.loadMappingIntoMaps();
        return datasetMapper;
    }

    private void loadMappingIntoMaps() {
        String[] mappingPairs;
        for (String mappingPair : mappingPairs = this.datasetMapping.split("\n")) {
            if ((mappingPair = mappingPair.trim()).isEmpty()) continue;
            this.loadPairIntoMap(mappingPair);
        }
    }

    private void loadPairIntoMap(String mappingPair) {
        String[] onePair = mappingPair.split(",");
        if (onePair.length != 2) {
            throw new InvalidDatasetMappingException(" [Error] Dataset Mapping is incorrect - " + mappingPair);
        }
        String source = onePair[0].trim();
        String target = onePair[1].trim();
        if (source.isEmpty()) {
            throw new InvalidDatasetMappingException(" [Error] Missing source dataset in Dataset Mapping - " + mappingPair);
        }
        if (MappingHelper.containsWildcardCharacter(source)) {
            this.loadMappingIntoMapWithWildcard(source, target);
        } else {
            this.loadMappingIntoMapWithoutWildcard(source, target);
        }
    }

    private void loadMappingIntoMapWithoutWildcard(String source, String target) {
        if (this.sourceToTargetMapWithoutWildcard.containsKey(source)) {
            System.out.println(" [Warning] The mapping rule " + source + "," + target + " is ignored as it is already set by " + source + "," + this.sourceToTargetMapWithoutWildcard.get(source));
        } else {
            this.sourceToTargetMapWithoutWildcard.put(source, target);
        }
    }

    private void loadMappingIntoMapWithWildcard(String source, String target) {
        String sourceWithRegularExp = MappingHelper.convertWildcardsToRegularExp(source);
        if (this.sourceToTargetMapWithWildcard.containsKey(sourceWithRegularExp)) {
            System.out.println(" [Warning] The mapping rule " + source + "," + target + " is ignored as it is already set by " + source + "," + this.sourceToTargetMapWithWildcard.get(sourceWithRegularExp));
        } else {
            this.sourceToTargetMapWithWildcard.put(sourceWithRegularExp, target);
        }
    }

    public LinkedHashMap<String, String> getSourceToTargetMapWithWildcard() {
        return this.sourceToTargetMapWithWildcard;
    }

    public LinkedHashMap<String, String> getSourceToTargetMapWithoutWildcard() {
        return this.sourceToTargetMapWithoutWildcard;
    }
}

