/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.allocate.steps;

import com.ibm.jzos.ZFileException;
import com.ibm.urbancode.zos.dataset.alloc.AllocLikeCommandBuilder;
import com.ibm.urbancode.zos.dataset.alloc.DatasetAllocator;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.urbancode.air.plugin.command.allocate.steps.AllocateLikeInputs;
import java.util.Properties;

public class AllocateLike {
    public static final String OUTPUT_PROPERTY_DATASET_NAME = "DatasetName";
    private static final String SPACE_UNIT_BLOCKS = "BLKS";
    private final Properties inputProperties;
    private final Properties outputProperties;

    public AllocateLike(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        try {
            AllocateLikeInputs pluginInputs = AllocateLikeInputs.getValidatedInputs(this.inputProperties);
            if (pluginInputs.isDeleteDatasetEnabled()) {
                DatasetHelper.deleteDataset(pluginInputs.getDatasetName());
            }
            DatasetAllocator allocator = this.getAllocator(pluginInputs);
            String allocatedDataset = allocator.allocate();
            System.out.println(" [INFO] Dataset " + allocatedDataset + " is created.");
            this.outputProperties.put(OUTPUT_PROPERTY_DATASET_NAME, allocatedDataset);
            return 0;
        }
        catch (RuntimeException runtimeException) {
            System.out.println(" [Error] " + runtimeException.getMessage());
        }
        catch (ZFileException zFileException) {
            throw new RuntimeException(zFileException);
        }
        return 1;
    }

    private DatasetAllocator getAllocator(AllocateLikeInputs pluginInputs) throws ZFileException {
        String likeDatasetName = DatasetHelper.isGDGDatasetWithReference(pluginInputs.getLikeDatasetName()) ? DatasetHelper.getGDGNameFromDataset(pluginInputs.getLikeDatasetName()) : pluginInputs.getLikeDatasetName();
        AllocLikeCommandBuilder commandBuilder = new AllocLikeCommandBuilder(pluginInputs.getDatasetName()).withLikeDataset(likeDatasetName).withVolumeSerial(pluginInputs.getVolumeSerial());
        if (this.containsPrimarySecondarySpaceQuantity(pluginInputs)) {
            commandBuilder = commandBuilder.withSpace(pluginInputs.getPrimaryQuantity(), pluginInputs.getSecondaryQuantity());
            if (this.isSpaceNotInBlocks(pluginInputs.getSpaceUnit())) {
                commandBuilder = commandBuilder.withSpaceUnit(pluginInputs.getSpaceUnit());
            }
        }
        return commandBuilder.build();
    }

    private boolean containsPrimarySecondarySpaceQuantity(AllocateLikeInputs pluginInputs) {
        return !pluginInputs.getPrimaryQuantity().isEmpty() && !pluginInputs.getSecondaryQuantity().isEmpty();
    }

    private boolean isSpaceNotInBlocks(String spaceUnit) {
        return !spaceUnit.equals(SPACE_UNIT_BLOCKS);
    }
}

