/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.replacetoken;

import com.ibm.jzos.RecordReader;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZUtil;
import com.ibm.urbancode.zos.common.util.GenericHelper;
import com.ibm.urbancode.zos.common.util.SystemEnv;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.urbancode.air.plugin.command.replacetoken.helpers.DatasetRecordTruncateException;
import com.urbancode.air.plugin.command.replacetoken.helpers.DatasetWriter;
import com.urbancode.air.plugin.command.replacetoken.helpers.ExcludePattern;
import com.urbancode.air.plugin.command.replacetoken.helpers.IncludePattern;
import com.urbancode.air.plugin.command.replacetoken.helpers.ReplaceTokensMVSInputs;
import com.urbancode.air.plugin.command.replacetoken.helpers.TokenReplacer;
import com.urbancode.air.plugin.inputs.InvalidInputException;
import com.urbancode.air.plugin.inputs.MissingInputException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;

public class ReplaceTokensMVS {
    private static final String JAVA_LIBRARY_PATH = "java.library.path";
    private static final String LIB_NATIVE_PATH = "lib/native";
    private static final String LINE_BREAK = "\n";
    private static final String SPLIT_REGEX = "\\s|,";
    private final Properties inputProperties;

    public ReplaceTokensMVS(Properties inputProperties, Properties ignoredOutputProperties) {
        this.inputProperties = inputProperties;
    }

    public int execute() throws Exception {
        try {
            ReplaceTokensMVSInputs pluginInputs = ReplaceTokensMVSInputs.getValidatedInputs(this.inputProperties);
            this.updateJavaLibraryPathWithPluginLibraries();
            HashMap<String, String> replaceTokens = new HashMap<String, String>();
            if (!pluginInputs.getEnvPropValues().isEmpty()) {
                replaceTokens.putAll(this.getEnvironmentProperties(pluginInputs));
            }
            if (!pluginInputs.getExplicitTokens().isEmpty()) {
                replaceTokens.putAll(this.getExplicitTokens(pluginInputs.getExplicitTokens()));
            }
            if (replaceTokens.isEmpty()) {
                System.out.println("No properties or explicit tokens to replace.");
                return 0;
            }
            LinkedHashSet<String> datasets = this.getFilteredDatasets(pluginInputs.getIncludes(), pluginInputs.getExcludes());
            System.out.println("Replace token in following files:");
            for (String dataset : datasets) {
                System.out.println(ZFile.getFullyQualifiedDSN((String)dataset));
            }
            int totalTokenReplacements = 0;
            int modifiedFilesCount = 0;
            for (String dataset : datasets) {
                TokenReplacer tokenReplacer = TokenReplacer.replace(this.getDatasetContent(dataset), replaceTokens);
                if (tokenReplacer.getReplacedTokenCount() <= 0) continue;
                ++modifiedFilesCount;
                totalTokenReplacements += tokenReplacer.getReplacedTokenCount();
                System.out.println("Apply changes to " + dataset);
                DatasetWriter datasetWriter = DatasetWriter.write(dataset, tokenReplacer.getReplacedContent());
                if (!datasetWriter.isDatasetRecordTruncated() || !pluginInputs.isFailOnTruncate()) continue;
                throw new DatasetRecordTruncateException("Failed for truncated.");
            }
            System.out.println("  [replace] Replaced " + totalTokenReplacements + " occurrences in " + modifiedFilesCount + " files.");
            return 0;
        }
        catch (DatasetRecordTruncateException | InvalidInputException | MissingInputException knownRuntimeException) {
            System.out.println(" [Error] " + knownRuntimeException.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDatasetContent(String datasetName) throws ZFileException, UnsupportedEncodingException {
        StringBuilder datasetContentBuilder = new StringBuilder();
        try (RecordReader recordReader = null;){
            int bytesRead;
            recordReader = RecordReader.newReader((String)datasetName, (int)1);
            byte[] bytes = new byte[recordReader.getLrecl()];
            while ((bytesRead = recordReader.read(bytes)) > 0) {
                String datasetRecord = new String(bytes, 0, bytesRead, ZUtil.getDefaultPlatformEncoding());
                datasetContentBuilder.append(datasetRecord).append(LINE_BREAK);
            }
        }
        return datasetContentBuilder.toString();
    }

    private Map<String, String> getExplicitTokens(String inputExplicitTokens) throws IOException {
        HashMap<String, String> explicitTokens = new HashMap<String, String>();
        try (BufferedReader reader = new BufferedReader(new StringReader(inputExplicitTokens));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split("->", 2);
                String propName = parts[0];
                String propValue = parts.length == 2 ? parts[1] : "";
                propName = this.convertStringToDefaultEncoding(propName);
                propValue = this.convertStringToDefaultEncoding(propValue);
                explicitTokens.put(propName, propValue);
            }
        }
        return explicitTokens;
    }

    private Map<String, String> getEnvironmentProperties(ReplaceTokensMVSInputs pluginInputs) throws UnsupportedEncodingException {
        String[] properties;
        HashMap<String, String> envProperties = new HashMap<String, String>();
        if (!pluginInputs.getPropertyPrefix().isEmpty()) {
            System.out.println("Looking for properties starting with " + pluginInputs.getPropertyPrefix());
        }
        for (String property : properties = pluginInputs.getEnvPropValues().split("(?<=(^|[^\\\\])(\\\\{2}){0,8}),")) {
            String propertyValue;
            String[] parts = property.split("(?<=(^|[^\\\\])(\\\\{2}){0,8})=", 2);
            String propertyName = parts[0];
            String string = propertyValue = parts.length == 2 ? parts[1] : "";
            if (GenericHelper.isNullOrEmpty(propertyName)) continue;
            propertyName = propertyName.replace("\\=", "=").replace("\\,", ",").replace("\\\\", "\\");
            propertyValue = propertyValue.replace("\\=", "=").replace("\\,", ",").replace("\\\\", "\\");
            if (!GenericHelper.isNullOrEmpty(pluginInputs.getPropertyPrefix()) && !propertyName.startsWith(pluginInputs.getPropertyPrefix())) continue;
            propertyName = this.convertStringToDefaultEncoding(pluginInputs.getStartDelimiter() + propertyName + pluginInputs.getEndDelimiter());
            propertyValue = this.convertStringToDefaultEncoding(propertyValue);
            envProperties.put(propertyName, propertyValue);
        }
        return envProperties;
    }

    private void updateJavaLibraryPathWithPluginLibraries() {
        String javaLibPath = System.getProperty(JAVA_LIBRARY_PATH);
        String newJavaLibPath = SystemEnv.getPluginHome() + File.separator + LIB_NATIVE_PATH + File.pathSeparator + javaLibPath;
        System.setProperty(JAVA_LIBRARY_PATH, newJavaLibPath);
    }

    private LinkedHashSet<String> getFilteredDatasets(String includes, String excludes) throws Exception {
        LinkedHashSet<String> filteredDatasets = this.getFilteredIncludes(includes);
        if (!excludes.isEmpty()) {
            filteredDatasets.removeAll(this.getFilteredExcludes(excludes, filteredDatasets));
        }
        return filteredDatasets;
    }

    private LinkedHashSet<String> getFilteredIncludes(String includes) throws Exception {
        String[] includeEntries;
        LinkedHashSet<String> filteredIncludes = new LinkedHashSet<String>();
        for (String includeEntry : includeEntries = includes.split(SPLIT_REGEX)) {
            IncludePattern includePattern = new IncludePattern(includeEntry);
            if (includePattern.getDatasetPattern().isEmpty()) continue;
            Map<String, String> datasetToVolumeMap = DatasetHelper.searchNonVsamDataset(includePattern.getDatasetPattern());
            for (String dataset : datasetToVolumeMap.keySet()) {
                String volume = datasetToVolumeMap.get(dataset);
                filteredIncludes.addAll(DatasetHelper.getMembers(dataset, volume, includePattern.getMemberPattern()));
            }
        }
        return filteredIncludes;
    }

    private LinkedHashSet<String> getFilteredExcludes(String excludes, LinkedHashSet<String> filteredIncludeEntries) {
        String[] excludeEntries;
        LinkedHashSet<String> filteredExcludes = new LinkedHashSet<String>();
        for (String excludeEntry : excludeEntries = excludes.split(SPLIT_REGEX)) {
            ExcludePattern excludePattern = new ExcludePattern(excludeEntry);
            String pattern = DatasetHelper.makeRegexPattern(excludePattern.getDatasetPattern() + "(" + excludePattern.getMemberPattern() + ")");
            for (String includeFile : filteredIncludeEntries) {
                if (!includeFile.matches("^.*" + pattern + ".*$")) continue;
                filteredExcludes.add(includeFile);
            }
        }
        return filteredExcludes;
    }

    private String convertStringToDefaultEncoding(String str) throws UnsupportedEncodingException {
        byte[] bytes = str.getBytes(ZUtil.getDefaultPlatformEncoding());
        return new String(bytes);
    }
}

