/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.common.util;

import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.common.util.GenericHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public final class DeploymentFilesHelper {
    private static final File workingDir = new File(".");

    private DeploymentFilesHelper() {
    }

    public static String getVersionDirPathInWorkingDir(String versionName, String resourceId) throws IOException {
        return workingDir.getCanonicalPath() + File.separator + resourceId + File.separator + versionName;
    }

    public static String getFilePathInWorkingDir(String versionName, String resourceId, String fileName) throws IOException {
        return DeploymentFilesHelper.getVersionDirPathInWorkingDir(versionName, resourceId) + File.separator + fileName;
    }

    public static String getVersionDirPathInRepository(String basePath, String componentName, String versionName) {
        return basePath + File.separator + componentName + File.separator + versionName;
    }

    public static String getFilePathInRepository(String basePath, String componentName, String versionName, String fileName) {
        return DeploymentFilesHelper.getVersionDirPathInRepository(basePath, componentName, versionName) + File.separator + fileName;
    }

    public static String getVersionPathInDeployBasePath(String basePath, String resourceId, String componentName, String versionName, boolean compatible) {
        String basePathToVersion = DeploymentFilesHelper.getVersionDeployBasePath(basePath, resourceId, componentName, versionName);
        if (compatible && FileHelper.isDirectoryNotExist(basePathToVersion)) {
            basePathToVersion = basePath + File.separator + "deploy" + File.separator + componentName + File.separator + versionName;
        }
        return basePathToVersion;
    }

    public static String getVersionDeployBasePath(String basePath, String resourceId, String componentName, String versionName) {
        return basePath + File.separator + "deploy" + File.separator + resourceId + File.separator + componentName + File.separator + versionName;
    }

    public static String getComponentPathInDeployBasePath(String basePath, String resourceId, String componentName) {
        String basePathToComponent = GenericHelper.isNullOrEmpty(resourceId) ? basePath + File.separator + "deploy" + File.separator + componentName : basePath + File.separator + "deploy" + File.separator + resourceId + File.separator + componentName;
        return basePathToComponent;
    }

    public static String getFilePathInDeployBasePath(String versionPathInBasePah, String fileName) {
        return versionPathInBasePah + File.separator + fileName;
    }

    public static void createTempFileForNewHFSMappingFormat(String componentVersionWorkingDir) throws IOException {
        File tempFile = new File(componentVersionWorkingDir + File.separator + "tempFileNewVersion.xml");
        if (tempFile.createNewFile()) {
            try (FileWriter writer = new FileWriter(tempFile.getCanonicalPath());){
                writer.write("THIS IS DUMMY FILE FOR IDENTIFYING NEW HFS MAPPING FORMAT");
                writer.flush();
            }
        }
    }
}

