/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.jcl;

import com.ibm.urbancode.zos.common.util.StringHelper;
import com.urbancode.air.plugin.inputs.InvalidInputException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JclTokenReplacer {
    private static final String TOKEN_DELIMITER = "->";
    private static final String REPLACE_TOKEN_REGEX = ".+->.*";
    private static final Pattern REPLACE_TOKEN_REGEX_PATTERN = Pattern.compile(".+->.*");
    private final String tokensToBeReplaced;
    private int noOfReplaceOccurrences = 0;

    public JclTokenReplacer(String tokensToBeReplaced) {
        this.tokensToBeReplaced = tokensToBeReplaced;
    }

    public String getJclWithTokensReplaced(String jcl) throws IOException {
        try (BufferedReader reader = new BufferedReader(new StringReader(this.tokensToBeReplaced));){
            String tokenLine;
            while ((tokenLine = reader.readLine()) != null) {
                if (this.isInvalidToken(tokenLine)) {
                    throw new InvalidInputException("Found invalid explicit token " + tokenLine + ". Token must be of format key->value.");
                }
                jcl = this.replaceToken(jcl, tokenLine);
            }
        }
        return jcl;
    }

    private boolean isInvalidToken(String tokenLine) {
        Matcher replaceTokenMatcher = REPLACE_TOKEN_REGEX_PATTERN.matcher(tokenLine.trim());
        return !replaceTokenMatcher.find();
    }

    private String replaceToken(String jcl, String tokenLine) {
        int indexOfDelimiter = tokenLine.indexOf(TOKEN_DELIMITER);
        String tokenKey = this.getTokenKey(tokenLine, indexOfDelimiter).trim();
        String tokenValue = this.getTokenValue(tokenLine, indexOfDelimiter);
        this.noOfReplaceOccurrences += StringHelper.countMatches(jcl, tokenKey);
        return jcl.replace(tokenKey, tokenValue);
    }

    private String getTokenKey(String tokenLine, int indexOfDelimiter) {
        return tokenLine.substring(0, indexOfDelimiter);
    }

    private String getTokenValue(String tokenLine, int indexOfDelimiter) {
        return tokenLine.substring(indexOfDelimiter + TOKEN_DELIMITER.length());
    }

    public int getNoOfReplaceOccurrences() {
        return this.noOfReplaceOccurrences;
    }
}

