/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.xml.utils;

import com.ibm.urbancode.zos.deploy.xml.utils.ContainerType;
import com.ibm.urbancode.zos.deploy.xml.utils.CopyType;
import com.ibm.urbancode.zos.deploy.xml.utils.ElementsSorter;
import com.ibm.urbancode.zos.deploy.xml.utils.Inputs;
import com.ibm.urbancode.zos.deploy.xml.utils.OrderBy;
import com.ibm.urbancode.zos.deploy.xml.utils.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Container
implements Comparable<Container> {
    private String targetContainerName;
    private CopyType copyType;
    private String deployType;
    private final List<Resource> resources = new ArrayList<Resource>();
    private final Map<String, String> customerProperties = new HashMap<String, String>();
    private Inputs inputs;
    private final String sourceContainerName;
    private final ContainerType type;
    private boolean isDeleted = false;

    Container(String sourceContainerName, ContainerType type) {
        this.sourceContainerName = sourceContainerName;
        this.type = type;
    }

    public Inputs getInputs() {
        return this.inputs;
    }

    void setInputs(Inputs inputs) {
        this.inputs = inputs;
    }

    void addResource(Resource resource) {
        this.resources.add(resource);
    }

    public List<Resource> getResources() {
        return Collections.unmodifiableList(this.resources);
    }

    void sortResources(OrderBy orderBy) {
        new ElementsSorter<Resource>(this.resources, orderBy).sort();
    }

    public String getTargetContainerName() {
        return this.targetContainerName;
    }

    void setTargetContainerName(String targetContainerName) {
        this.targetContainerName = targetContainerName;
    }

    public String getDeployType() {
        return this.deployType;
    }

    void setDeployType(String deployType) {
        this.deployType = deployType;
    }

    public Map<String, String> getCustomerProperties() {
        return Collections.unmodifiableMap(this.customerProperties);
    }

    void addCustomerProperty(String property, String value) {
        this.customerProperties.put(property, value);
    }

    public String getSourceContainerName() {
        return this.sourceContainerName;
    }

    public ContainerType getType() {
        return this.type;
    }

    public boolean isGeneric() {
        return this.type == ContainerType.GENERIC;
    }

    public boolean isDirectory() {
        return this.type == ContainerType.DIRECTORY;
    }

    public boolean isPds() {
        return this.type == ContainerType.PDS;
    }

    public boolean isSequential() {
        return this.type == ContainerType.SEQUENTIAL;
    }

    public boolean isDataset() {
        return this.isPds() || this.isSequential();
    }

    public CopyType getCopyType() {
        return this.copyType;
    }

    void setCopyType(CopyType copyType) {
        this.copyType = copyType;
    }

    void setDeleted() {
        this.isDeleted = true;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    @Override
    public int compareTo(Container other) {
        return this.sourceContainerName.compareTo(other.getSourceContainerName());
    }
}

