/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.BsamRecordWriter;
import com.ibm.jzos.Messages;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileConstants;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZFileRecordWriter;
import com.ibm.jzos.ZUtil;

public abstract class RecordWriter
implements ZFileConstants {
    protected boolean autoFree = false;

    protected RecordWriter() {
    }

    public static RecordWriter newWriterForDD(String ddname) throws ZFileException {
        ZFile.checkSecurityManager("//DD:" + ddname, "w");
        return RecordWriter.basicNewWriterForDD(ddname);
    }

    static RecordWriter basicNewWriterForDD(String ddname) throws ZFileException {
        RecordWriter writer = null;
        try {
            writer = BsamRecordWriter.newWriterForDD(ddname);
        }
        catch (UnsupportedOperationException uoe) {
            writer = new ZFileRecordWriter(ddname);
        }
        return writer;
    }

    public static RecordWriter newWriter(String name, int flags) throws ZFileException, RcException {
        ZFile.checkSecurityManager(name, "w");
        String fqdsn = ZFile.getFullyQualifiedDSN(name);
        String ddname = null;
        boolean autoFree = false;
        ddname = RecordWriter.extractDDName(name);
        if (ddname != null) {
            if (flags != 0) {
                ZUtil.logDiagnostic(3, Messages.getString("RecordWriter.DDNameNotSupported") + " " + name);
            }
        } else if (flags == 1) {
            ddname = RecordWriter.doAlloc(fqdsn, "shr");
            autoFree = true;
        } else if (flags == 4 || flags == 0) {
            ddname = RecordWriter.doAlloc(fqdsn, "old");
            autoFree = true;
        } else if (flags == 8) {
            ddname = RecordWriter.doAlloc(fqdsn, "mod");
            autoFree = true;
        } else {
            throw new IllegalArgumentException(Messages.getString("RecordWriter.InvalidFlags") + " 0x" + Integer.toHexString(flags));
        }
        try {
            RecordWriter instance = RecordWriter.basicNewWriterForDD(ddname);
            instance.setAutoFree(autoFree);
            return instance;
        }
        catch (ZFileException zfe) {
            if (autoFree) {
                RecordWriter.doFree(ddname);
            }
            throw zfe;
        }
    }

    public abstract void write(byte[] var1) throws ZFileException;

    public abstract void write(byte[] var1, int var2, int var3) throws ZFileException;

    public abstract void close() throws ZFileException;

    public abstract void flush() throws ZFileException;

    public abstract int getLrecl();

    public abstract int getBlksize();

    public abstract int getRecfmBits();

    public abstract String getRecfm();

    public abstract String getDDName();

    public abstract String getDsn();

    public boolean getAutoFree() {
        return this.autoFree;
    }

    public void setAutoFree(boolean autoFree) {
        this.autoFree = autoFree;
    }

    protected static String doAlloc(String fqdsn, String disp) throws RcException {
        String ddname = ZFile.allocDummyDDName();
        try {
            ZFile.bpxwdyn("alloc fi(" + ddname + ") da(" + fqdsn + ") reuse " + disp + " msg(2)");
            ZUtil.logDiagnostic(5, "RecordWriter: Allocated " + fqdsn + " to DD:" + ddname + " DISP=" + disp);
        }
        catch (RcException rce) {
            RecordWriter.doFree(ddname);
            throw rce;
        }
        return ddname;
    }

    protected static void doFree(String ddname) {
        try {
            ZFile.bpxwdyn("free fi(" + ddname + ") msg(2)");
            ZUtil.logDiagnostic(5, "RecordWriter: Freed DD:" + ddname);
        }
        catch (RcException rce) {
            ZUtil.logDiagnostic(1, "RecordWriter: Error freeing DD:" + ddname + " - " + rce.getMessage());
        }
    }

    protected void doAutoFree() {
        if (this.autoFree) {
            RecordWriter.doFree(this.getDDName());
        }
    }

    private static String extractDDName(String filename) {
        if (filename == null) {
            return null;
        }
        String upperFilename = filename.toUpperCase().trim();
        int i = upperFilename.indexOf("DD:");
        if (i >= 0 && (i += 3) < upperFilename.length()) {
            return upperFilename.substring(i);
        }
        return null;
    }
}

