/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.copy.dataset;

import com.ibm.jzos.ZFileException;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.urbancode.air.plugin.command.copy.dataset.IncludeMember;
import com.urbancode.air.plugin.command.copy.dataset.SourcePDS;
import com.urbancode.air.plugin.exceptions.InvalidInputException;
import com.urbancode.air.plugin.inputs.InputsValidator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

class CopyDatasetInputs {
    private static final String WILDCARD_ASTERISK = "*";
    private static final String WILDCARD_PERCENTAGE = "%";
    public static final String SOURCE_PDS = "sourcePDS";
    public static final String TO_PDS = "toPDS";
    public static final String INCLUDE_MEMBERS = "includeMembers";
    public static final String EXCLUDE_MEMBERS = "excludeMembers";
    public static final String IS_LOAD_MODULE = "isLoadModule";
    private static final String COMMA = ",";
    private static final String REPLACE_CHAR = "R";
    private static final boolean NO_REPLACE = false;
    private static final boolean REPLACE = true;
    private final String sourcePDSLines;
    private final String toPDS;
    private final String includeMemberLines;
    private final String excludeMemberLines;
    private final Boolean isLoadModule;
    private final Set<SourcePDS> sourceDatasets = new LinkedHashSet<SourcePDS>();
    private final List<String> excludeMembers = new ArrayList<String>();
    private final List<IncludeMember> includeMembers = new ArrayList<IncludeMember>();
    private List<SourcePDS> sourceDatasetsList = null;

    private CopyDatasetInputs(Properties inputProperties) {
        this.sourcePDSLines = inputProperties.getProperty(SOURCE_PDS).toUpperCase().trim();
        this.toPDS = inputProperties.getProperty(TO_PDS).toUpperCase().trim().replace("'", "");
        this.includeMemberLines = inputProperties.getProperty(INCLUDE_MEMBERS).trim().toUpperCase();
        this.excludeMemberLines = inputProperties.getProperty(EXCLUDE_MEMBERS).trim().toUpperCase();
        this.isLoadModule = Boolean.valueOf(inputProperties.getProperty(IS_LOAD_MODULE));
    }

    public static CopyDatasetInputs getValidatedInputs(Properties inputProperties) throws ZFileException {
        CopyDatasetInputs copyDatasetInputs = new CopyDatasetInputs(inputProperties);
        copyDatasetInputs.validate();
        copyDatasetInputs.convertSourcePDSLinesToSet();
        copyDatasetInputs.convertExcludeMembersToList();
        copyDatasetInputs.convertIncludeMembersToList();
        return copyDatasetInputs;
    }

    private void validate() throws ZFileException {
        InputsValidator.checkIfEmpty(this.sourcePDSLines, "From PDS");
        InputsValidator.checkIfEmpty(this.toPDS, "To PDS");
        if (DatasetHelper.isDatasetNotExist(this.toPDS)) {
            throw new InvalidInputException("To PDS " + this.toPDS + " does not exist");
        }
        if (!this.includeMemberLines.isEmpty() && !this.excludeMemberLines.isEmpty()) {
            throw new InvalidInputException("Inputs 'Include Members' and 'Exclude Members' are mutually exclusive.");
        }
        if (this.includeMemberLines.contains(WILDCARD_ASTERISK) || this.includeMemberLines.contains(WILDCARD_PERCENTAGE)) {
            throw new InvalidInputException("Wildcards are not supported in member name. Input 'Include Members' contains wildcard '*' or '%'.");
        }
        if (this.excludeMemberLines.contains(WILDCARD_ASTERISK) || this.excludeMemberLines.contains(WILDCARD_PERCENTAGE)) {
            throw new InvalidInputException("Wildcards are not supported in member name. Input 'Exclude Members' contains wildcard '*' or '%'.");
        }
    }

    private void convertSourcePDSLinesToSet() {
        try (StringReader stringReader = new StringReader(this.sourcePDSLines);
             BufferedReader bufferedReader = new BufferedReader(stringReader);){
            String sourcePDSLine;
            int lineNo = 0;
            while ((sourcePDSLine = bufferedReader.readLine()) != null) {
                ++lineNo;
                if ((sourcePDSLine = sourcePDSLine.trim()).isEmpty()) {
                    throw new InvalidInputException("Source PDS at line no " + lineNo + " is empty.");
                }
                SourcePDS sourcePDS = sourcePDSLine.contains(COMMA) ? this.getSourcePDSWithReplaceOption(sourcePDSLine, lineNo) : new SourcePDS(sourcePDSLine, false);
                this.validateSourcePds(sourcePDS, lineNo);
                this.sourceDatasets.add(sourcePDS);
            }
        }
        catch (IOException e) {
            throw new InvalidInputException("Failed to read Source PDS Lines");
        }
    }

    private SourcePDS getSourcePDSWithReplaceOption(String sourcePDSLine, int lineNo) throws ZFileException {
        String[] sourcePDSLineArgs = sourcePDSLine.split(COMMA);
        if (sourcePDSLineArgs.length != 2) {
            throw new InvalidInputException("Invalid input " + sourcePDSLine + " at line no " + lineNo + " for Source PDS. Input should be in the format '<PDS Name>' or '<PDS Name>,<R>' where <R> is optional and indicates whether to replace the PDS members if it already exists.");
        }
        if (sourcePDSLineArgs[1].trim().equals(REPLACE_CHAR)) {
            return new SourcePDS(sourcePDSLineArgs[0], true);
        }
        throw new InvalidInputException("Invalid input " + sourcePDSLine + " at line no " + lineNo + " for Source PDS. Input should be in the format '<PDS Name>' or '<PDS Name>,<R>' where <R> is optional and indicates whether to replace the PDS members if it already exists.");
    }

    private void validateSourcePds(SourcePDS sourcePDS, int lineNo) throws ZFileException {
        if (sourcePDS.getPdsName().isEmpty()) {
            throw new InvalidInputException("Source PDS at line no " + lineNo + " is empty.");
        }
        if (this.sourceDatasets.contains(sourcePDS)) {
            throw new InvalidInputException("Duplicate Source PDS " + sourcePDS.getPdsName() + " at line no " + lineNo + ".");
        }
        if (DatasetHelper.isDatasetNotExist(sourcePDS.getPdsName())) {
            throw new InvalidInputException("Source PDS " + sourcePDS.getPdsName() + " at line no " + lineNo + " does not exist.");
        }
        if (sourcePDS.getPdsName().equals(this.toPDS)) {
            throw new InvalidInputException("Source PDS " + sourcePDS.getPdsName() + " at line no " + lineNo + " and To PDS " + this.toPDS + " are same.");
        }
    }

    private void convertExcludeMembersToList() {
        try (StringReader stringReader = new StringReader(this.excludeMemberLines);
             BufferedReader bufferedReader = new BufferedReader(stringReader);){
            String excludeMemberLine;
            int lineNo = 0;
            while ((excludeMemberLine = bufferedReader.readLine()) != null) {
                ++lineNo;
                if ((excludeMemberLine = excludeMemberLine.trim()).isEmpty()) {
                    throw new InvalidInputException("Exclude Member at line no " + lineNo + " is empty.");
                }
                this.excludeMembers.add(excludeMemberLine);
            }
        }
        catch (IOException e) {
            throw new InvalidInputException("Failed to read Exclude Members");
        }
    }

    private void convertIncludeMembersToList() {
        try (StringReader stringReader = new StringReader(this.includeMemberLines);
             BufferedReader bufferedReader = new BufferedReader(stringReader);){
            String includeMemberLine;
            int lineNo = 0;
            while ((includeMemberLine = bufferedReader.readLine()) != null) {
                IncludeMember includeMember;
                ++lineNo;
                if ((includeMemberLine = includeMemberLine.trim()).isEmpty()) {
                    throw new InvalidInputException("Include Member at line no " + lineNo + " is empty.");
                }
                IncludeMember includeMember2 = includeMember = includeMemberLine.contains(COMMA) ? this.getIncludeMemberWithNewNameAndReplaceOption(includeMemberLine, lineNo) : new IncludeMember(includeMemberLine, "", false);
                if (includeMember.getMemberName().isEmpty()) {
                    throw new InvalidInputException("Include Member at line no " + lineNo + " have member name empty.");
                }
                this.includeMembers.add(includeMember);
            }
        }
        catch (IOException e) {
            throw new InvalidInputException("Failed to read Include Members");
        }
    }

    private IncludeMember getIncludeMemberWithNewNameAndReplaceOption(String includeMemberLine, int lineNo) {
        String[] includeMemberLineArgs = includeMemberLine.split(COMMA);
        if (includeMemberLineArgs.length == 2) {
            return new IncludeMember(includeMemberLineArgs[0], includeMemberLineArgs[1], false);
        }
        if (includeMemberLineArgs.length == 3) {
            if (includeMemberLineArgs[2].trim().equals(REPLACE_CHAR)) {
                return new IncludeMember(includeMemberLineArgs[0], includeMemberLineArgs[1], true);
            }
            throw new InvalidInputException("Invalid input " + includeMemberLine + " at line no " + lineNo + " for Include Member. Input should be in the format '<Member Name>' or '<Member Name>,<New Member Name>' or '<Member Name>,<New Member Name>,<R>' where <New Member Name> and <R> are optional and indicates whether to replace the member if it already exists.");
        }
        throw new InvalidInputException("Invalid input " + includeMemberLine + " at line no " + lineNo + " for Include Member. Input should be in the format '<Member Name>' or '<Member Name>,<New Member Name>' or '<Member Name>,<New Member Name>,<R>' where <New Member Name> and <R> are optional and indicates whether to replace the member if it already exists.");
    }

    public String getToPDS() {
        return this.toPDS;
    }

    public List<IncludeMember> getIncludeMembers() {
        return this.includeMembers;
    }

    public List<String> getExcludeMembers() {
        return this.excludeMembers;
    }

    public Boolean isLoadModule() {
        return this.isLoadModule;
    }

    public List<SourcePDS> getSourceDatasets() {
        if (this.sourceDatasetsList == null) {
            this.sourceDatasetsList = new ArrayList<SourcePDS>(this.sourceDatasets);
        }
        return this.sourceDatasetsList;
    }
}

