/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.copy.dataset;

import com.urbancode.air.plugin.command.copy.dataset.CopyDatasetInputs;
import com.urbancode.air.plugin.command.copy.dataset.FileAccessException;
import com.urbancode.air.plugin.command.copy.dataset.IncludeMember;
import com.urbancode.air.plugin.exceptions.InvalidInputException;
import com.urbancode.air.plugin.exceptions.MissingInputException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class CopyDataset {
    private static final int LRECL = 80;
    private final Properties inputProperties;
    private CopyDatasetInputs pluginInputs;

    public CopyDataset(Properties inputProperties, Properties ignoredOutputProperties) {
        this.inputProperties = inputProperties;
    }

    public int execute() throws Exception {
        try {
            this.pluginInputs = CopyDatasetInputs.getValidatedInputs(this.inputProperties);
            File sysinFile = File.createTempFile("COPY", ".SYSIN");
            sysinFile.deleteOnExit();
            this.writeSysinStatements(sysinFile);
            File sysprintFile = File.createTempFile("COPY", ".SYSPRINT");
            sysprintFile.deleteOnExit();
            File rexxScriptFile = File.createTempFile("COPY", ".rexx");
            if (!rexxScriptFile.setExecutable(true)) {
                throw new FileAccessException("Unable to set executable permission on " + rexxScriptFile.getCanonicalPath());
            }
            rexxScriptFile.deleteOnExit();
            this.writeScriptStatements(rexxScriptFile, sysinFile, sysprintFile);
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command(rexxScriptFile.getCanonicalPath());
            Process process = processBuilder.start();
            StringBuilder rexxOutput = this.getProcessOutput(process.getInputStream());
            this.printSysprintOutput(sysprintFile);
            int exitValue = process.waitFor();
            if (exitValue == 0) {
                System.out.println("Copy data set completed.");
                System.out.println(rexxOutput);
                System.out.println("The rexx script is executed successfully.");
                return 0;
            }
            System.out.println(rexxOutput);
            System.out.println("Program terminated with return code " + exitValue);
            return 8;
        }
        catch (FileAccessException | InvalidInputException | MissingInputException e) {
            System.out.println(" [Error] " + e.getMessage());
            return 8;
        }
    }

    private StringBuilder getProcessOutput(InputStream processInputStream) throws IOException {
        StringBuilder output = new StringBuilder();
        output.append("out:\n");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(processInputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                output.append(line).append("\n");
            }
        }
        return output;
    }

    private void writeSysinStatements(File sysinFile) throws IOException {
        try (FileWriter fileWriter = new FileWriter(sysinFile.getAbsolutePath());
             BufferedWriter sysinWriter = new BufferedWriter(fileWriter);){
            this.writeOUTDDStatement(sysinWriter);
            this.writeINDDStatements(sysinWriter);
            this.writeMEMBERStatements(sysinWriter);
        }
    }

    private void writeOUTDDStatement(BufferedWriter sysinWriter) throws IOException {
        if (this.pluginInputs.isLoadModule().booleanValue()) {
            sysinWriter.append(StringUtils.rightPad((String)"COPERST1 COPYMOD OUTDD=SYSUT2", (int)80));
        } else {
            sysinWriter.append(StringUtils.rightPad((String)"COPERST1 COPY OUTDD=SYSUT2", (int)80));
        }
    }

    private void writeINDDStatements(BufferedWriter sysinWriter) throws IOException {
        for (int i = 0; i < this.pluginInputs.getSourceDatasets().size(); ++i) {
            if (this.pluginInputs.getSourceDatasets().get(i).isReplaceEnabled()) {
                sysinWriter.append(StringUtils.rightPad((String)("              INDD=((INDD" + i + ",R))"), (int)80));
                continue;
            }
            sysinWriter.append(StringUtils.rightPad((String)("              INDD=(INDD" + i + ")"), (int)80));
        }
    }

    private void writeMEMBERStatements(BufferedWriter sysinWriter) throws IOException {
        block3: {
            block2: {
                if (this.pluginInputs.getIncludeMembers().isEmpty()) break block2;
                for (IncludeMember includeMember : this.pluginInputs.getIncludeMembers()) {
                    sysinWriter.append(StringUtils.rightPad((String)("        SELECT MEMBER=" + includeMember.getArguments()), (int)80));
                }
                break block3;
            }
            if (this.pluginInputs.getExcludeMembers().isEmpty()) break block3;
            for (String excludeMember : this.pluginInputs.getExcludeMembers()) {
                sysinWriter.append(StringUtils.rightPad((String)("        EXCLUDE MEMBER=" + excludeMember), (int)80));
            }
        }
    }

    private void writeScriptStatements(File rexxScriptFile, File sysinFile, File sysprintFile) throws IOException {
        try (FileWriter fileWriter = new FileWriter(rexxScriptFile.getCanonicalPath());
             BufferedWriter rexxWriter = new BufferedWriter(fileWriter);){
            this.writeHeaderRecords(rexxWriter);
            this.writeSysinAllocationRecords(sysinFile, rexxWriter);
            this.writeInputAllocationRecords(rexxWriter);
            this.writeOutputAllocationRecords(rexxWriter);
            this.writeSysprintAllocationRecords(sysprintFile, rexxWriter);
            this.writeIEBCOPYRecords(rexxWriter);
            this.writeFreeDDRecords(rexxWriter);
            this.writeExitRecord(rexxWriter);
        }
    }

    private void writeHeaderRecords(BufferedWriter rexxWriter) throws IOException {
        rexxWriter.append("/* rexx */\n");
        rexxWriter.append("userid = USERID()\n");
        rexxWriter.append("ADDRESS TSO\n");
    }

    private void writeSysinAllocationRecords(File sysinFile, BufferedWriter rexxWriter) throws IOException {
        rexxWriter.append("\"ALLOC PATH('").append(sysinFile.getCanonicalPath()).append("') DDNAME(SYSIN) PATHDISP(keep,keep) PATHOPTS(ORDONLY) PATHMODE(SIRUSR) \"\n");
        rexxWriter.append("if rc <> 0 then do\n");
        rexxWriter.append("    say 'Error allocating SYSIN for IEBCOPY '\n");
        rexxWriter.append("    return 8\n");
        rexxWriter.append("end\n");
    }

    private void writeInputAllocationRecords(BufferedWriter rexxWriter) throws IOException {
        for (int i = 0; i < this.pluginInputs.getSourceDatasets().size(); ++i) {
            String inDsnName = "'" + this.pluginInputs.getSourceDatasets().get(i).getPdsName() + "'";
            rexxWriter.append("\"ALLOC DATASET(").append(inDsnName).append(") DDNAME(INDD").append(String.valueOf(i)).append(") SHR  REUSE\"\n");
            rexxWriter.append("say \"Allocation for data set ").append(inDsnName).append(" ends with \"rc\n");
            rexxWriter.append("if rc <> 0 then return 8\n");
        }
    }

    private void writeOutputAllocationRecords(BufferedWriter rexxWriter) throws IOException {
        rexxWriter.append("\"ALLOC DATASET('").append(this.pluginInputs.getToPDS()).append("') DDNAME(SYSUT2) SHR  REUSE\"\n");
        rexxWriter.append("if rc <> 0 then do\n");
        rexxWriter.append("    say 'Error allocating DD for To PDS'\n");
        rexxWriter.append("    return 8\n");
        rexxWriter.append("end\n");
    }

    private void writeSysprintAllocationRecords(File sysprintFile, BufferedWriter rexxWriter) throws IOException {
        rexxWriter.append("\"ALLOC PATH('").append(sysprintFile.getCanonicalPath()).append("') DDNAME(SYSPRINT) FILEDATA(TEXT) pathdisp(keep,keep) pathopts(owronly,ocreat) PATHMODE(SIRUSR)\"\n");
    }

    private void writeIEBCOPYRecords(BufferedWriter rexxWriter) throws IOException {
        rexxWriter.append("ADDRESS TSO 'LISTALC STATUS'\n");
        rexxWriter.append("ADDRESS TSO 'IEBCOPY'\n");
        rexxWriter.append("exitRC =rc\n");
        rexxWriter.append("if rc <> 0 then say 'Error executing IEBCOPY'\n");
    }

    private void writeFreeDDRecords(BufferedWriter rexxWriter) throws IOException {
        for (int i = 0; i < this.pluginInputs.getSourceDatasets().size(); ++i) {
            rexxWriter.append("\"FREE DDNAME(INDD").append(String.valueOf(i)).append(")\"\n");
        }
        rexxWriter.append("\"FREE DDNAME(SYSUT2) \"\n");
        rexxWriter.append("if rc <> 0 then say 'Error free To PDS'\n");
        rexxWriter.append("\"FREE DDNAME(SYSPRINT) \"\n");
        rexxWriter.append("\"FREE DDNAME(SYSIN) \"\n");
    }

    private void writeExitRecord(BufferedWriter rexxWriter) throws IOException {
        rexxWriter.append("return exitRC\n");
    }

    private void printSysprintOutput(File sysprintFile) throws IOException {
        System.out.println(" [SYSPRINT OUTPUT] ");
        try (BufferedReader br = new BufferedReader(new FileReader(sysprintFile));){
            String line;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
        }
    }
}

