/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.restore.backup;

import com.ibm.jzos.ZFile;
import com.urbancode.air.plugin.inputs.InputsValidator;
import java.util.Properties;

class RestoreBackupDatasetsInputs {
    public static final String RESOURCE_ID = "resourceId";
    public static final String COMPONENT_NAME = "componentName";
    public static final String VERSION_NAME = "versionName";
    public static final String DEPLOY_BASE_PATH = "deployBasePath";
    public static final String DATASET_MAPPING = "datasetMapping";
    public static final String ALLOW_CREATE_DATASET = "allowCreateDataset";
    public static final String TEMP_DSN_PREFIX = "tempDsnPrefix";
    public static final String ISPF_GATEWAY_PATH = "ispfGatewayPath";
    private final String resourceId;
    private final String componentName;
    private final String versionName;
    private final String deployBasePath;
    private final String datasetMapping;
    private final boolean isCreateDatasetAllowed;
    private final String tempDsnPrefix;
    private final String ispfGatewayBinariesPath;

    private RestoreBackupDatasetsInputs(Properties inputProperties) {
        this.datasetMapping = inputProperties.getProperty(DATASET_MAPPING).trim();
        this.isCreateDatasetAllowed = Boolean.parseBoolean(inputProperties.getProperty(ALLOW_CREATE_DATASET));
        this.resourceId = inputProperties.getProperty(RESOURCE_ID).trim();
        this.componentName = inputProperties.getProperty(COMPONENT_NAME).trim();
        this.versionName = inputProperties.getProperty(VERSION_NAME).trim();
        this.deployBasePath = inputProperties.getProperty(DEPLOY_BASE_PATH).trim();
        this.tempDsnPrefix = inputProperties.getProperty(TEMP_DSN_PREFIX).trim().isEmpty() ? ZFile.getDefaultHLQ() : inputProperties.getProperty(TEMP_DSN_PREFIX).trim();
        this.ispfGatewayBinariesPath = inputProperties.getProperty(ISPF_GATEWAY_PATH).trim();
    }

    public static RestoreBackupDatasetsInputs getValidatedInputs(Properties inputProperties) {
        RestoreBackupDatasetsInputs pluginInputs = new RestoreBackupDatasetsInputs(inputProperties);
        pluginInputs.validate();
        return pluginInputs;
    }

    private void validate() {
        InputsValidator.checkIfEmpty(this.deployBasePath, "Deployment Base Path");
        InputsValidator.checkIfEmpty(this.versionName, "Version Name");
        InputsValidator.checkIfEmpty(this.componentName, "Component Name");
        InputsValidator.checkIfEmpty(this.resourceId, "Resource Id");
        InputsValidator.checkIfEmpty(this.datasetMapping, "Dataset Mapping");
        InputsValidator.checkIfEmpty(this.ispfGatewayBinariesPath, "ISPF Gateway Path");
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getDeployBasePath() {
        return this.deployBasePath;
    }

    public String getDatasetMapping() {
        return this.datasetMapping;
    }

    public boolean isCreateDatasetAllowed() {
        return this.isCreateDatasetAllowed;
    }

    public String getTempDsnPrefix() {
        return this.tempDsnPrefix;
    }

    public String getIspfGatewayBinariesPath() {
        return this.ispfGatewayBinariesPath;
    }
}

