/* REXX */
/*%STUB CALLCMD*/
/*********************************************************************/
/* Copyright:    Licensed Materials - Property of IBM and/or HCL     */
/*                                                                   */
/*        Copyright IBM Corporation. All rights reserved             */
/*        Copyright HCL Technologies limited. All rights reserved    */
/*                                                                   */
/*        US Government Users Restricted Rights -                    */
/*        Use, duplication or disclosure restricted by               */
/*        GSA ADP Schedule Contract with IBM Corp.                   */
/*                                                                   */
/*********************************************************************/

   Call syscalls('ON')

   parse arg Module '"'manifest'"' '"'ziploc'"' '"'pkgzip'"' '"'restore'"',
                '"'tstamp'"' '"'traceOption'"' '"'sysoutValue'"',
                '"'tempUnit'"' '"'tempVolSerValue'"'.

   Parse var traceOption TraceOn '(' TraceMod ')'
   TraceCmd = ''
   If Substr(TraceOn,1,5) = 'TRACE' Then
   Do
     modname = 'BUZBKPZP'
     If TraceMod = 'ALL' |,
        TraceMod = modname Then
     Do
       Say "*** Tracing activated for "modname "on "Date('N') ||,
           " at "Time()" ***"
       Select
         When (TraceOn = 'TRACE?I') Then TraceCmd = 'Trace ?i'
         When (TraceOn = 'TRACEI')  Then TraceCmd = 'Trace i'
         When (TraceOn = 'TRACEA')  Then TraceCmd = 'Trace a'
         When (TraceOn = 'TRACER')  Then TraceCmd = 'Trace r'
         When (TraceOn = 'TRACEC')  Then TraceCmd = 'Trace c'
         When (TraceOn = 'TRACEE')  Then TraceCmd = 'Trace e'
         When (TraceOn = 'TRACEF')  Then TraceCmd = 'Trace f'
         When (TraceOn = 'TRACEL')  Then TraceCmd = 'Trace l'
         When (TraceOn = 'TRACEN')  Then TraceCmd = 'Trace n'
         When (TraceOn = 'TRACE')   Then TraceCmd = 'Trace r'
         Otherwise NOP
       End
     End
   End
   Interpret TraceCmd

   /* Set Sysout class and temp volser */
   sysoutClass = ''
   tempVolser  = ''
   If sysoutValue /= "" Then
   Do
      sysoutClass = 'SYSOUT('sysoutValue')'
   End
   If tempVolSerValue /= "" Then
   Do
      tempVolser  = 'VOLUME('tempVolSerValue')'
   End

   Say 'Manifest file :' manifest
   Say 'Location of the zip file :' ziploc
   Say 'Name of backup zip file :' pkgzip
   Say 'Restore Mapping File :' restore

  /* read input files and set up */
   Call initialize

  /* create backup manifest      */
   Call bkupmanfV301

  /* create the backup zip       */
   Call doBackup301
Exit

Initialize :

   manlist.0 = 0
   Address syscall "readfile (manifest) manlist."
   If retval < 0 Then
   Do
      Say 'There was a problem reading the manifest file :' manifest ||,
          ' Errno :' errno 'Reason :' right(errnojr,8,0)
      Call Exitproc(8)
   End
   /* remove <property */
   entryPtr=0
   Do i = 1 to manlist.0
      /*UCD: remove comments */
      if Pos("<property",manlist.i) <= 0 then
      do
        if entryPtr == i-1  then
        do
          entryPtr=i
        end
        else
        do
          entryPtr= entryPtr+1
          manlist.entryPtr = manlist.i
          manlist.i=' '
        end
      end
   end
   manlist.0=entryPtr

   origlist. = ''
   Do i = 1 to manlist.0
      origlist.i = manlist.i
   End

   maplist.0 = 0
   Address syscall "readfile (restore) maplist."
   If retval < 0 Then
   Do
      Say 'There was a problem reading the mapping file :' restore ||,
          ' Errno :' errno 'Reason :' right(errnojr,8,0)
      Call Exitproc(8)
   End

   if maplist.0 = 0 then
   do
      Say 'No mapping found in the mapping file' restore
      Call Exitproc(8)
   end
Return

bkupmanfV301 :

   /* Need to create a new Backup/Restore manifest based on */
   /* original Manifest with the Restore mapping file       */
   /* Also create a mapping list package data set to deploy */
   /* data set.                                             */

   k = 0
   Zip = 'No'
   isSequential = 0
   isDeleted = 0
   Do i = 1 to manlist.0
      If Pos('<deleted>',manlist.i) > 0 Then
        isDeleted = 1
      If Pos('</deleted>',manlist.i) > 0 Then
        isDeleted = 0
      If Pos('<container',manlist.i) > 0 Then
      Do
        If pos(' type="sequential"',manlist.i) > 0 Then
          isSequential = 1
        Else
          isSequential = 0

        Parse var manlist.i . ' name="' DataSet '"' .

        /* Ignore directory (i.e. HFS) containers. They are handled by Ant. */
        If Pos(' type="directory"',manlist.i) > 0 Then
        Do
          /* Say "Skipping directory container "DataSet */
          i = i + 1
          Do while (Pos('<resource',manlist.i) > 0)
             i = i + 1
          End
          i = i - 1
        End
        Else
        Do
           /* Loop through restore mapping file to see if */
           /* there is an entry for the data set. If so   */
           /* replace it in the list.                     */

           Call updateTargetDatasetOfManifestContainer
           i = i + 1
           Do while Pos('<resource',manlist.i) > 0 |,
                    Pos('</resource',manlist.i) > 0
              i = i + 1
           End
           i = i - 1
        End
     End
   End

Return

/*-----------------------------------------------------------------*/
/* Update mapping file to have deploy to names                     */
/*-----------------------------------------------------------------*/

updateTargetDatasetOfManifestContainer :

  DeplDSN = Strip(DataSet)
  isMappingNotFound = 1
  Do rest = 1 to maplist.0
     If Pos('<?xml',maplist.rest) > 0 Then
        iterate
     If Pos('<maps>',maplist.rest) > 0  |,
        Pos('</maps>',maplist.rest) > 0 Then
        iterate
     If Pos('<map type="PDS">',maplist.rest) > 0  |,
        Pos('<map type="sequential">',maplist.rest) > 0  |,
        Pos('</map>',maplist.rest) > 0 Then
        iterate
     If Pos('<sourceContainer',maplist.rest) > 0 Then
     Do
        Parse var maplist.rest . '<sourceContainer name="' OrigDSN,
                                 '" />' .
        rest = rest + 1
     End
     If Pos('<targetContainer',maplist.rest) > 0 Then
        Parse var maplist.rest . '<targetContainer name="' ToDSN,
                                 '" />' .
     Else
     Do
        Say 'The data set for "Deploy to" was not specified for' OrigDSN
        Call Exitproc(8)
     End
     OrigDSN = Strip(OrigDSN)
     ToDSN   = Strip(ToDSN)
     If DataSet = OrigDSN Then
     Do
        DeplDSN = ToDSN
        if (isSequential) Then
            manlist.i = '    <container name="'ToDSN'" type="sequential">'
        else
            manlist.i = '    <container name="'ToDSN'" type="PDS">'

        isMappingNotFound = 0
        Leave
     End
  End

  If isMappingNotFound Then
  Do
     Say 'The data set for "Deploy to" was not specified for' DataSet
     Call Exitproc(8)
  End

Return

dobackup301:

   /* Backup the original files based on the contents of    */
   /* the modified manifest file. Create the restore        */
   /* manifest file.                                        */

   k   = 0
   Zip = 'No'
   d = 0

   /*
    Description of the DeltaFileMap data structure
    DeltaFileMap.1 = Added Containers
    DeltaFileMap.2 = Updated Containers
    DeltaFileMap.3 = Deleted Containers
    DeltaFileMap.i.# = List of Containers
    DeltaFileMap.i.j.# = List of Resources
    DeltaFileMap.i.j.#.missing = 0 or 1
   */
   /* Need to initialize all the arrays in our data structure */
   DeltaFileMap.1.0 = 0
   DeltaFileMap.2.0 = 0
   DeltaFileMap.3.0 = 0
   DeltaFileMap.0   = 3
   lastPosition     = 0
   updateContainers = 0
   deleteContainers = 0
   addedContainers  = 0

   isDeleted = 0
   ds = 0
   DsnList  = ''
   MemList. = ''

   Do i = 1 to manlist.0
      /* Let's see if we are in a deletion block */
      /* Still need to save deleted members      */
      If Pos('<deleted>',manlist.i) > 0 Then
        isDeleted = 1
      If Pos('</deleted>',manlist.i) > 0 Then
        isDeleted = 0

      If Pos('<container',manlist.i) > 0 Then
      Do
        /* Get the source data set to zip from      */
        Parse var manlist.i . ' name="' DataSet '"' .
        DataSet = Strip(DataSet)
        Parse var origlist.i . ' name="' OrigDsn '"' . ' type="' Type '"' .
        OrigDsn = Strip(OrigDsn)

        /* Ignore directory (i.e. HFS) containers. They are handled by Ant. */
        If Type = 'directory' Then
          iterate

        If Type = 'sequential' Then
          Call ProcSeq
        Else
          Call ProcPDS

        /* need to alter the xmiting as there may be updated */
        /* and deleted members to backup                     */
        CopyMem.0 = j
        If Wordpos(dataset,dsnList) = 0 Then
          dsnList = dsnList dataset

        If Type = 'sequential' Then
          MemList.dataset = 'sequential'
        Else
          Do c = 1 to CopyMem.0
            MemList.dataset = MemList.dataset CopyMem.c
          End
      End
   End

   Do i = 1 to Words(dsnList)
     DataSet = Word(dsnList,i)
     If Memlist.DataSet <> '' Then
     Do
       xmi_rc = xmi_it();
       If xmi_rc = 0 Then
       Do
         k = k + 1
         ZipDSN.k = DataSet".bin"
         Zip = 'Yes'
       End
     End
     Else
     Do
       Say 'There are no members to back up in' DataSet
     End
   End

   If Zip = 'Yes' then
   DO
      ZipDSN.0 = K
      Call Zip_it pkgzip
      tstampdir = ziploc'/'tstamp
      shellcmd='mkdir "'tstampdir'";cp "'ziploc'/'zipname'" "'tstampdir'"'
      sh_rc = bpxwunix(shellcmd,,stdout.,stderr.)
   End

   DeltaFileMap.1.0 = addedContainers
   DeltaFileMap.2.0 = updateContainers
   DeltaFileMap.3.0 = deleteContainers

   Call CreateDeltaDeployFile

Return

ProcPDS :

  sysdsnRC = 'OK'
  var = "'"Dataset"'"
  ListdsiRC = Listdsi(var directory)
  isPdsNotExist = 0
  If ListdsiRC <= 4 Then
  Do
    If SYSMEMBERS = 0 Then
    Do
      sysdsnRC = 'MEMBER NOT FOUND'
      Say 'The data set for "Restore to"' DataSet 'is empty.'
    End
  End
  Else
  Do
    If SYSREASON = 5 Then
    Do
      isPdsNotExist = 1
      sysdsnRC = 'MEMBER NOT FOUND'
      Say 'The data set for "Restore to"' DataSet 'does not exist.'
    End
    Else
    Do
      Say 'There was a problem checking the existence of the data set' dataset
      Say 'The return code from the LISTDSI function is :' SYSREASON
      Call Exitproc(8)
    End
  End
  i = i + 1
  j = 0
  /* Get all the members to zip               */
  Do while (Pos('<resource',manlist.i) > 0)
     Parse var manlist.i . ' name="' member '"' .

     /* Need to change the XML format chars to real chars */
     member = chkmem3(member)
     member=Strip(member)
     /* Need to check that the member exists in the    */
     /* previous PDS. If not Transmit will fail.       */
     /* Also we need to mark this as we will need      */
     /* to delete the member if a restore is done.     */

     If (member /= '*') Then
     Do
        If sysdsnRC = 'OK' Then
        Do
           tempdsn     = "'"Dataset"("Strip(member)")'"
           x  = MSG('Off')
           sysdsnRCRes = sysdsn(tempdsn)
           If Pos('INVALID DATASET NAME,',sysdsnRCRes) > 0 Then
           Do
             /* probably an IMS member with invalid characters */
             /* Try LMMFIND as that works                      */
             "ISPEXEC LMINIT DATAID(DOD) DATASET('"Dataset"') ENQ(SHR)"
             "ISPEXEC LMOPEN DATAID("DOD")"
             "ISPEXEC LMMFIND  DATAID("DOD") MEMBER("member")"
             If RC = 0 Then
               sysdsnRCRes = 'OK'
             Else
               sysdsnRCRes = 'MEMBER NOT FOUND'
             "ISPEXEC LMCLOSE DATAID("DOD")"
             "ISPEXEC LMFREE DATAID("DOD")"
           End
           x  = MSG('On')
        End
        else
        Do
           sysdsnRCRes = 'MEMBER NOT FOUND'
        End
     End

     Select
       When (sysdsnRCRes = 'OK') Then
       Do
         j = j + 1
         /* Need to get rid of weird chars */
         cpyMember = chkmem2(member)
         CopyMem.j = Strip(cpyMember)
         If member /= '*' Then
         Do
           If isDeleted Then
           Do
             parse var DeltaFileMap.3.deleteContainers . 'name="' LDataSet '"' .
             If LDataSet = DataSet then
             Do
               lastPosition = DeltaFileMap.3.deleteContainers.0 + 1
               DeltaFileMap.3.deleteContainers.lastPosition = member
               DeltaFileMap.3.deleteContainers.lastPosition.missing = 0
               DeltaFileMap.3.deleteContainers.0 = lastPosition
             End
             Else
             Do
               deleteContainers = deleteContainers + 1
               DeltaFileMap.3.deleteContainers = '<container name="' ||,
                                                  DataSet || '" type="PDS">'
               DeltaFileMap.3.deleteContainers.1 = member
               DeltaFileMap.3.deleteContainers.1.missing = 0
               DeltaFileMap.3.deleteContainers.0 = 1
             End
           End
           Else
           Do
             parse var DeltaFileMap.2.updateContainers . 'name="' LDataSet '"' .
             If LDataSet = DataSet then
             Do
               lastPosition = DeltaFileMap.2.updateContainers.0 + 1
               DeltaFileMap.2.updateContainers.lastPosition = member
               DeltaFileMap.2.updateContainers.lastPosition.missing = 0
               DeltaFileMap.2.updateContainers.0 = lastPosition
             End
             Else
             Do
               updateContainers = updateContainers + 1
               DeltaFileMap.2.updateContainers = '<container name="' ||,
                                                  DataSet || '" type="PDS">'
               DeltaFileMap.2.updateContainers.1 = member
               DeltaFileMap.2.updateContainers.1.missing = 0
               DeltaFileMap.2.updateContainers.0 = 1
             End
           End
         End
       End
       When (sysdsnRCRes= 'MEMBER NOT FOUND') Then
       Do
         If member /= '*' Then
         Do
           If isDeleted Then
             Do
             parse var DeltaFileMap.3.deleteContainers . 'name="' LDataSet '"' .
             If LDataSet = DataSet then
             Do
               lastPosition = DeltaFileMap.3.deleteContainers.0 + 1
               DeltaFileMap.3.deleteContainers.lastPosition = member
               DeltaFileMap.3.deleteContainers.lastPosition.missing = 1
               DeltaFileMap.3.deleteContainers.0 = lastPosition
             End
             Else
             Do
               deleteContainers = deleteContainers + 1
               containerTagPrefix = '<container name="'DataSet'" type="PDS"'
               if (isPdsNotExist) then
                  DeltaFileMap.3.deleteContainers = containerTagPrefix ||,
                                                     ' missing="true">'
               else
                  DeltaFileMap.3.deleteContainers = containerTagPrefix || '>'
               DeltaFileMap.3.deleteContainers.1 = member
               DeltaFileMap.3.deleteContainers.1.missing = 1
               DeltaFileMap.3.deleteContainers.0 = 1
             End
           End
           Else
           Do
              parse var DeltaFileMap.1.addedContainers . 'name="' LDataSet '"' .
              if LDataSet = DataSet then
              Do
                 lastPosition = DeltaFileMap.1.addedContainers.0 + 1
                 DeltaFileMap.1.addedContainers.lastPosition = member
                 DeltaFileMap.1.addedContainers.lastPosition.missing = 0
                 DeltaFileMap.1.addedContainers.0 = lastPosition
              End
              Else
              Do
                 addedContainers = addedContainers + 1
                 containerTagPrefix = '<container name="'DataSet'" type="PDS"'
                 if (isPdsNotExist) then
                    DeltaFileMap.1.addedContainers = containerTagPrefix ||,
                                                     ' missing="true">'
                 else
                    DeltaFileMap.1.addedContainers = containerTagPrefix || '>'
                 DeltaFileMap.1.addedContainers.1 = member
                 DeltaFileMap.1.addedContainers.1.missing = 0
                 DeltaFileMap.1.addedContainers.0 = 1
              End
           End
         End
       End
       Otherwise
       Do
         Say 'There was a problem checking the existence of the member.'
         Say 'Message received :' sysdsnRCRes
         Call Exitproc(8)
       End
     End
     i = i + 1
     if Pos('</resource',manlist.i) > 0 then
     do
        i = i + 1
     end
  End
  i = i - 1

Return


chkmem1: Procedure

  /* change characters that may cause problems in the xml */

  Parse arg member
  Validchars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ@#$'
  newMemb = ''

  Do mm = 1 to Length(member)
    char = Substr(member,mm,1)
    If Pos(char,Validchars) = 0 Then
    Do
      newMemb = newMemb||'HexValueIs'||right(C2D(char),3,0)
    End
    Else
      newMemb = newMemb||char
  End

Return newMemb

chkmem2: Procedure

  /* change characters to wildcards for IEBCOPY           */

  Parse arg member
  Validchars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ@#$'
  newMemb = ''

  Do mm = 1 to Length(member)
    char = Substr(member,mm,1)
    If Pos(char,Validchars) = 0 Then
      newMemb = newMemb||'%'
    Else
      newMemb = newMemb||char
  End

Return newMemb

chkmem3: Procedure

  /* change characters that may cause problems in the xml */

  Parse arg member
  nonValid = 'HexValueIs'
  newMemb = ''

  Do mm = 1 to Length(member)
    char = Substr(member,mm,10)
    If char = nonValid Then
    Do
       newMemb = newMemb || D2C(Substr(member,mm+10,03))
       mm = mm + 12 /* Because do loop will increment by 1 */
    End
    Else
      newMemb = newMemb||Substr(member,mm,1)
  End

Return newMemb

ProcSeq:

  containerTag = '<container name="'DataSet'" type="sequential"'
  closingTag = '/>'

  var = "'"Dataset"'"
  ListdsiRC = Listdsi(var directory)
  If ListdsiRC = 16 Then
  Do
    If SYSREASON = 5 Then
    Do
      missingAttr = ' missing="true"'
      Say 'The data set for "Restore to"' DataSet 'does not exist.'
      If isDeleted Then
      Do
        deleteContainers = deleteContainers + 1
        DeltaFileMap.3.deleteContainers = containerTag || missingAttr ||,
                                          closingTag
      End
      Else
      Do
        addedContainers = addedContainers + 1
        DeltaFileMap.1.addedContainers = containerTag || missingAttr ||,
                                         closingTag
      End
    End
  End
  Else
  Do
    If isDeleted Then
    Do
      deleteContainers = deleteContainers + 1
      DeltaFileMap.3.deleteContainers = containerTag || closingTag
    End
    Else
    Do
        updateContainers = updateContainers + 1
        DeltaFileMap.2.updateContainers = containerTag || closingTag
    End
  End

Return

CreateDeltaDeployFile :

   XML_INDENT_1 = '    '
   XML_INDENT_2 = copies(XML_INDENT_1, 2)
   XML_INDENT_3 = copies(XML_INDENT_1, 3)

   DeltaFile.1 = '<?xml version="1.0"?>'
   DeltaFile.2 = '<manifest type="MANIFEST_REPORT">'
   k = 2

   Do i = 1 to DeltaFileMap.0
     Select
       When (i == 1) then
       Do
         k = k + 1
         DeltaFile.k = ''
         k = k + 1
         DeltaFile.k = XML_INDENT_1 || '<created>'
       End
       When (i == 2) then
       Do
         k = k + 1
         DeltaFile.k = ''
         k = k + 1
         DeltaFile.k = XML_INDENT_1 || '<updated>'
       End
       Otherwise /* i == 3 */
       Do
         k = k + 1
         DeltaFile.k = ''
         k = k + 1
         DeltaFile.k = XML_INDENT_1 || '<deleted>'
       End
     End

     Do j = 1 to DeltaFileMap.i.0
        If pos(' type="sequential"', DeltaFileMap.i.j) > 0 Then
        Do
            k = k + 1
            DeltaFile.k = XML_INDENT_2 || DeltaFileMap.i.j
        End
        Else
        Do
          k = k + 1
          DeltaFile.k = XML_INDENT_2 || DeltaFileMap.i.j

          Do l = 1 to DeltaFileMap.i.j.0
            k = k + 1
            DeltaFileMap.i.j.l = chkmem1(DeltaFileMap.i.j.l)
            resourceTagPrefix = XML_INDENT_3 || '<resource' ||,
                          ' name="'DeltaFileMap.i.j.l'" type="PDSMember"'
            If (DeltaFileMap.i.j.l.missing) then
              DeltaFile.k = resourceTagPrefix || ' missing="true"' || '/>'
            else
              DeltaFile.k = resourceTagPrefix || '/>'
          End

          k = k + 1
          DeltaFile.k = XML_INDENT_2 || '</container>'
        End
     End

     Select
       When (i == 1) then
       Do
         k = k + 1
         DeltaFile.k = XML_INDENT_1 || '</created>'
       End
       When (i == 2) then
       Do
         k = k + 1
         DeltaFile.k = XML_INDENT_1 || '</updated>'
       End
       Otherwise /* i == 3 */
       Do
         k = k + 1
         DeltaFile.k = XML_INDENT_1 || '</deleted>'
       End
     End
   End

   k = k + 1
   DeltaFile.k = '</manifest>'
   DeltaFile.0 = k

   deltamanifest = ziploc'/deltaDeployed.xml'
   Address syscall "writefile (deltamanifest) 755 DeltaFile."
   If rc <> 0 Then
   Do
      Say 'There was an error writing the delta deployed file '||,
          ':' deltamanifest 'Errno :'errno
      Call Exitproc(8)
   End

Return

Xmi_it :

   x = msg('off')
   Address TSO "FREE F(SYSPRINT)"
   x = msg('on')
   Address TSO "ALLOC F(SYSPRINT) NEW REUSE " sysoutClass

   /* Take a stab at the allocation of the sequential XMI  */
   /* file. XMITs are generally about the same size as     */
   /* the actual PDS. So if we are XMITing the whole thing */
   /* then make the primary the same as the PDS. If we are */
   /* XMITing some members split the primary and secondary */
   /* up.                                                  */

   Address ISPEXEC "DSINFO DATASET('"Dataset"')"
   nummems = Space(ZDS#MEM,0)

   Select
     When (rc = 8) | (ZDSORG /= 'PS' & (rc = 0 & nummems = 0)) Then
     Do
       Say 'Deploy to data set' Dataset ' does not exist or contains' ||,
           ' no members. Ignoring this data set for backup/restore.'
       /* Don't try and XMI the file */
       Return 8
     End
     When (rc = 0) Then
       Nop
     Otherwise
     Do
       msg = "DSINFO failed on '"Dataset"' Return Code :" rc
       Call ISPFerr (msg' rc='rc)
     End
   End

   /* Need to get rid of the thousands separators */
   AllocUnit = Translate(Strip(ZDSTOTA),"abc def ghi jkl","abc,def,ghi,jkl")
   AllocUnit = Space(AllocUnit,0)
   UsedUnit  = Translate(Strip(ZDSTOTU),"abc def ghi jkl","abc,def,ghi,jkl")
   UsedUnit  = Space(UsedUnit,0)
   NumMems   = Translate(Strip(ZDS#MEM),"abc def ghi jkl","abc,def,ghi,jkl")
   NumMems   = Space(NumMems,0)

   If ZDSDSNT = 'LIBRARY' Then
     SpaceUsed = AllocUnit*(ZDSPERU/100)
   Else
     SpaceUsed = UsedUnit

   /* If all members being copied then allocate a sequential */
   /* data set with a primary of 1/4 of the total space used */
   /* and a secondary of 1/4 also. This will limit the       */
   /* chance of not being able to get a big enough primary   */
   /* on a pack.                                             */

   If (Pos('*',Strip(Memlist.Dataset)) > 0 ) | ZDSORG = 'PS' Then
   Do
     /* If Primary is > 1 then set primary to 1 */
     Primary   = Max(Format(SpaceUsed/4,,0),1)
     Secondary = Primary
   End

   /* If only some members are being copied then calculate   */
   /* the primary as a percentage of the members being       */
   /* copied against the total member count. If the total    */
   /* percentage of members is > 24% then set primary to 25% */
   Else
   Do
      Memperc   = (Words(Memlist.Dataset)/NumMems)*100
     If Memperc > 24 Then
     Do
       /* If Primary is > 1 then set primary to 1 */
       Primary   = Max(Format(SpaceUsed/4,,0),1)
       Secondary = Primary
     End
     Else
     Do
       /* If Primary is > 1 then set primary to 1 */
       Primary   = Max(Format(SpaceUsed*Memperc/100,,0),1)
       Secondary = Max(Format(((SpaceUsed-Primary)/15)+1,,0),1)
     End
   End

   /* Create the space units literal, either tracks, cylinders */
   /* or Blocks. If blocks, the blocksize is also required.    */

   If Pos('BLOCK',ZDSSPC) > 0 Then
     SpaceUnits = Strip(ZDSSPC)'('Strip(ZDSBLK)')'
   Else
     SpaceUnits = Strip(ZDSSPC)

   Select
     When (SpaceUnits = 'MEGABYTE') Then
     Do
       SpaceUnits = 'TRACK'
       Primary    = Primary%0.06
       Secondary  = Secondary%0.06
     End
     When (SpaceUnits = 'KILOBYTE') Then
     Do
       SpaceUnits = 'TRACK'
       Primary    = Primary%56
       Secondary  = Secondary%56
     End
     When (SpaceUnits = 'BYTE') Then
     Do
       SpaceUnits = 'TRACK'
       Primary    = Primary%56664
       Secondary  = Secondary%56664
     End
     Otherwise
       Nop
   End
   If Primary < 10 Then
     Primary = 10
   If Secondary < 10 Then
     Secondary = 10

   x= MSG('off')
   Address TSO "FREE F(SEQFILE)"
   x= MSG('on')
   Address TSO "ALLOC F(SEQFILE) NEW " SpaceUnits ||,
            " UNIT("tempUnit") "tempVolser" DSORG(PS)" ||,
            " BLKSIZE(3120) LRECL(80) RECFM(F B)" ||,
            " SPACE("Primary" "Secondary")"

   xmit_rc = 0
   /* You have to XMIT into a sequential dataset            */
   XX=OUTTRAP('STEM.')
   If (Pos('*',Strip(Memlist.DataSet)) > 0 ) | ZDSORG = 'PS' Then
   Do
     Address TSO "XMIT A.A DA('"DataSet"')",
                    "OUTDD(SEQFILE) NON NOL " sysoutClass
     xmit_rc = rc
   End
   Else
   Do
     /* Going to copy members to a temporary data set first */
     /* to ensure aliases are copied. Then XMIT the         */
     /* complete data set                                   */

     /* Need to put blanks into record format */
     recfm = ''
     Do r = 1 to length(strip(ZDSRF))
       recfm = recfm || substr(strip(ZDSRF),r,1) || ' '
     End
     /* get some additional stuff to allocate temp PDS */
     If ZDSDSNT = 'LIBRARY' Then
       DSORG = 'DSORG('ZDSORG') DSNTYPE(LIBRARY)'
     Else
     Do
       DirBlks = Words(Memlist.DataSet)%2
       If DirBlks < 10 Then
          DirBlks = 10
       Select
         When (SpaceUnits = 'TRACK') Then
         Do
           DirSpace = DirBlks * 256
           DirSpace = DirSpace%56664
           If DirSpace = 0 Then
             DirSpace = 1
           Primary = Primary + DirSpace
         End
         When (SpaceUnits = 'CYLINDER') Then
         Do
           DirSpace = DirBlks * 256
           DirSpace = DirSpace%849960
           If DirSpace = 0 Then
             DirSpace = 1
           Primary = Primary + DirSpace
         End
         Otherwise
         Do
           DirSpace = ZDSBLK%256
           DirSpace = DirSpace%DirBlks
           If DirSpace = 0 Then
             DirSpace = 1
           Primary = Primary + DirSpace
         End
       End
       DSORG = 'DSORG('ZDSORG') DIR('Strip(DirBlks)')'
     End

     Address TSO "ALLOC F(TEMPPDS) NEW " SpaceUnits ||,
          " UNIT("tempUnit") "tempVolser" "DSORG ||,
          " BLKSIZE("ZDSBLK") LRECL("ZDSLREC") RECFM("recfm")"          ||,
          " SPACE("Primary" "Secondary")"

     /* Now copy the members to the temp PDS */
     x = msg('off')
     Address TSO "FREE F(SYSOUT)"
     Address TSO "FREE F(SYSPRINT)"
     x = msg('on')
     Address TSO "ALLOC F(SYSPRINT) NEW REUSE " sysoutClass

     Address TSO "ALLOC F(INDD)  DA('"DataSet"') SHR REUSE"
     Address TSO "ALLOC F(SYSIN) NEW REUSE"

     Drop SYSLINE.
     ss = 1

     SYSLINE.1 = " COPYGROUP OUTDD=TEMPPDS,INDD=INDD"

     Do mems = 1 to words(Memlist.Dataset)
        copymem = Word(Memlist.Dataset,mems)
        ss = ss + 1
        SYSLINE.ss = "  SELECT MEMBER=("copymem")"
     End
     SYSLINE.0 = ss
     Address TSO "EXECIO "SYSLINE.0" DISKW SYSIN (STEM SYSLINE. FINIS)"

     Address ISPEXEC "ISPEXEC SELECT PGM(IEBCOPY)"
     Copy_rc = rc

     If Copy_rc = 0 Then
     Do
       Address TSO "XMIT A.A DD(TEMPPDS) OUTDD(SEQFILE) NON NOL " ||,
               sysoutClass
       xmit_rc = rc
     End
     Else
     Do
       "EXECIO * DISKR SYSPRINT (FINIS STEM sysprint."
       Do x = 1 to sysprint.0
         Say Strip(sysprint.x)
       End
       Call Exitproc(8)
     End

     Address TSO "FREE F(TEMPPDS)"
   End

   NullPDS = 0
   If xmit_rc <> 0 Then
   Do
      Do xmit = 1 to stem.0
         If Pos('Empty partitioned datasets cannot be transmitted',,
                 stem.xmit) Then
            NullPDS = 1
      End
      If NullPDS = 0 Then
      Do
        Do x = 1 to stem.0
          Say stem.x
        End
        /* Need to run the copy through IEBCOPY just to get the      */
        /* message. Stupid solution but XMIT does not return the     */
        /* sysprint output and IEBCOPY always creates the sequential */
        /* data set as VS.                                           */
        Address TSO "ALLOC F(INDD)  DA('"DataSet"') SHR REUSE"
        Address TSO "ALLOC F(SYSIN) NEW REUSE"
        SYSIN.0 = 1
        SYSIN.1 = " COPYGROUP OUTDD=SEQFILE,INDD=INDD"
        If Strip(Memlist.DataSet) /= '*' Then
        Do
          i = 1
          Do mems = 1 to words(memlist.DataSet)
            copymem = Word(memlist.DataSet,mems)
            i = i + 1
            SYSIN.i = "  SELECT MEMBER=("Strip(copymem)")"
          End
          SYSIN.0 = i
        End
        Address TSO "EXECIO * DISKW SYSIN (STEM SYSIN. FINIS)"

        /* Call IEBCOPY to XMIT into a sequential dataset */
        Address ISPEXEC "ISPEXEC SELECT PGM(IEBCOPY)"
        "EXECIO * DISKR SYSPRINT (FINIS STEM sysprint."
        Do x = 1 to sysprint.0
          Say Strip(sysprint.x)
        End

        Address TSO "FREE F(INDD)"
        Address TSO "FREE F(SYSIN)"

        Call Exitproc(8)
      End
   End
   XX=OUTTRAP('OFF')

   /* Now copy sequential to HFS                            */
   x = msg('off')
   Address TSO "FREE F(HFSFILE)"
   x = msg('on')
   PATHMODE = 'SIRWXU,SIRGRP,SIXGRP,SIROTH,SIXOTH'
   Address TSO "ALLOC F(HFSFILE) PATH('"ziploc"/"DataSet".bin')",
                "PATHMODE ("PATHMODE") PATHOPTS (ocreat, owronly)"
   Address TSO "OCOPY INDD(SEQFILE) OUTDD(HFSFILE) BINARY"

   Address TSO "FREE F(SEQFILE)"
   Address TSO "FREE F(HFSFILE)"
   Address TSO "FREE F(SYSPRINT)"

Return 0

Zip_it :

   parse arg zipname

   stdout.0 = 0
   stderr.0 = 0
   ZipList   = ''
   Do c = 1 to ZipDSN.0
      /* need to escape any $ in the dsname */
      newDSN = ''
      i$ = Index(ZipDSN.c,'$')
      If i$ /= 0 then
      Do
        Do While i$ /= 0
          newDSN   = newDSN || Substr(ZipDSN.c,1,i$-1) || '\$'
          ZipDSN.c = Substr(ZipDSN.c,i$+1)
          i$ = Index(ZipDSN.c,'$')
        End
        newDSN   = newDSN || ZipDSN.c
        ZipDSN.c = newDSN
      End
      ZipList = ZipList ZipDSN.c
   End

   /* Set attributes for the bin files */
   shellcmd='cd "'ziploc'";chmod 744 'ZipList

   sh_rc = bpxwunix(shellcmd,,stdout.,stderr.)

   /* zip up the new one     */
   shellcmd='cd "'ziploc'";pax -o saveext -wvpe -f "'zipname'"' ZipList
   sh_rc = bpxwunix(shellcmd,,stdout.,stderr.)
   If stderr.0 > 0 Then
   Do
      Do e = 1 to stderr.0
         Say stderr.e
      End
   End
   If stdout.0 > 0 Then
   Do
      Say '---STDOUT---'
      Do o = 1 to stdout.0
         Say stdout.o
      End
   End
   If sh_rc /= 0 Then
      Call Exitproc(sh_rc)

   /* remove temporary xmi files */

   Do i = 1 to ZipDSN.0
      xmiFile = ziploc"/"ZipDSN.i
      shellcmd = 'rm "'xmiFile'"'
      sh_rc = bpxwunix(shellcmd,,stdout.,stderr.)
      If stderr.0 > 0 Then
      Do
         Say '---STDERR---'
         Do e = 1 to stderr.0
            Say stderr.e
         End
      End
      If stdout.0 > 0 Then
      Do
         Say '---STDOUT---'
         Do o = 1 to stdout.0
            Say stdout.o
         End
      End
   End

Return

ISPFErr :

   Parse arg msg 'rc='ISPFrc

   /* Say msg || ' Return code : 'ISPFrc */
   Say msg
   Say ZERRMSG ':' ZERRSM
   Say ZERRLM

   Call Exitproc(ISPFrc)

Return

ExitProc :

   Parse arg exit_rc

   ZISPFRC = exit_rc
   Address ISPEXEC "VPUT (ZISPFRC) SHARED"

Exit exit_rc
