/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.dataset.record;

import com.ibm.team.enterprise.deployment.dataset.record.DatasetRecord;
import com.ibm.team.enterprise.deployment.dataset.record.DatasetRecordBuilder;
import com.ibm.team.enterprise.deployment.dataset.record.PdsDeleteRecordBuilder;
import com.ibm.team.enterprise.deployment.dataset.record.PdsUpdateRecordBuilder;
import com.ibm.team.enterprise.deployment.dataset.record.SeqDeleteRecordBuilder;
import com.ibm.team.enterprise.deployment.dataset.record.SeqUpdateRecordBuilder;
import com.ibm.urbancode.zos.deploy.xml.utils.Container;
import com.ibm.urbancode.zos.deploy.xml.utils.PackageManifest;
import com.ibm.urbancode.zos.deploy.xml.utils.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class DeploymentRecord
implements DatasetRecord {
    private static final String SEMICOLON = ";";
    private final String dsnType;
    private final String action;
    private final String sourceDsn;
    private final String targetDsn;
    private final String member;

    public DeploymentRecord(DatasetRecordBuilder datasetRecordBuilder) {
        this.dsnType = datasetRecordBuilder.getDsnType().toString();
        this.action = datasetRecordBuilder.getAction().toString();
        this.sourceDsn = datasetRecordBuilder.getSourceDsn();
        this.targetDsn = datasetRecordBuilder.getTargetDsn();
        this.member = datasetRecordBuilder.getMember();
    }

    @Override
    public String getRecord() {
        return this.dsnType + SEMICOLON + this.action + SEMICOLON + this.sourceDsn + SEMICOLON + this.targetDsn + SEMICOLON + this.member;
    }

    public static List<DatasetRecord> generateRecordsFrom(PackageManifest packageManifest, Map<String, String> sourceTempDsnMap) {
        return packageManifest.getContainers().stream().filter(Container::isDataset).flatMap(container -> DeploymentRecord.getDeploymentRecords(container, sourceTempDsnMap)).collect(Collectors.toList());
    }

    private static Stream<DeploymentRecord> getDeploymentRecords(Container container, Map<String, String> sourceTempDsnMap) {
        if (container.isDeleted()) {
            return DeploymentRecord.getDeleteRecords(container);
        }
        return DeploymentRecord.getUpdateRecord(container, sourceTempDsnMap);
    }

    private static Stream<DeploymentRecord> getDeleteRecords(Container container) {
        if (container.isSequential()) {
            String targetDataset = container.getTargetContainerName();
            return Stream.of(DeploymentRecord.getSeqDeleteRecord(targetDataset));
        }
        return DeploymentRecord.getPdsDeleteRecords(container);
    }

    private static Stream<DeploymentRecord> getPdsDeleteRecords(Container container) {
        String targetDsn = container.getTargetContainerName();
        return container.getResources().stream().map(resource -> DeploymentRecord.getPdsMemberDeleteRecord(resource, targetDsn));
    }

    private static Stream<DeploymentRecord> getUpdateRecord(Container container, Map<String, String> sourceTempDsnMap) {
        String sourceDsn = sourceTempDsnMap.get(container.getSourceContainerName());
        String targetDsn = container.getTargetContainerName();
        if (container.isSequential()) {
            return Stream.of(DeploymentRecord.getSeqUpdateRecord(sourceDsn, targetDsn));
        }
        return Stream.of(DeploymentRecord.getPdsUpdateRecord(sourceDsn, targetDsn));
    }

    private static DeploymentRecord getSeqUpdateRecord(String sourceDataset, String targetDataset) {
        return new SeqUpdateRecordBuilder().withSourceDsn(sourceDataset).withTargetDsn(targetDataset).build();
    }

    private static DeploymentRecord getPdsUpdateRecord(String sourceDataset, String targetDataset) {
        return new PdsUpdateRecordBuilder().withSourceDsn(sourceDataset).withTargetDsn(targetDataset).build();
    }

    private static DeploymentRecord getSeqDeleteRecord(String targetDataset) {
        return new SeqDeleteRecordBuilder().withTargetDsn(targetDataset).build();
    }

    private static DeploymentRecord getPdsMemberDeleteRecord(Resource resource, String targetDsn) {
        return new PdsDeleteRecordBuilder().withTargetDsn(targetDsn).withMember(resource.getName()).build();
    }
}

