/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.dataset.record;

import com.ibm.team.enterprise.deployment.dataset.record.DatasetRecord;
import com.ibm.urbancode.zos.deploy.xml.utils.Container;
import com.ibm.urbancode.zos.deploy.xml.utils.PackageManifest;
import com.ibm.urbancode.zos.deploy.xml.utils.Resource;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class MemberStatsRecord
implements DatasetRecord {
    public static final String RESOURCE_LAST_MODIFIED_USERID = "lastModifiedUserid";
    private static final String SEMICOLON = ";";
    private final String pdsDataset;
    private final String member;
    private final String modifiedTimestamp;
    private final String modifiedUser;

    private MemberStatsRecord(String pdsDataset, String member, String modifiedTimestamp, String modifiedUser) {
        this.pdsDataset = pdsDataset;
        this.member = member;
        this.modifiedTimestamp = modifiedTimestamp;
        this.modifiedUser = modifiedUser;
    }

    public static List<DatasetRecord> generateRecords(PackageManifest manifest, Map<String, String> sourceTempDsnMap) {
        return manifest.getContainers().stream().filter(container -> !container.isDeleted()).filter(Container::isPds).flatMap(container -> MemberStatsRecord.getStatsForContainerMembers(container, sourceTempDsnMap)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Stream<MemberStatsRecord> getStatsForContainerMembers(Container container, Map<String, String> sourceTempDsnMap) {
        String dataset = sourceTempDsnMap.get(container.getSourceContainerName());
        return container.getResources().stream().map(resource -> MemberStatsRecord.getMemberStats(resource, dataset));
    }

    private static MemberStatsRecord getMemberStats(Resource resource, String dataset) {
        String modifiedUser = (String)resource.getCustomerProperties().get(RESOURCE_LAST_MODIFIED_USERID);
        String modifiedTimestamp = resource.getLastModifiedTimestamp();
        if (modifiedUser != null && modifiedTimestamp != null) {
            return new MemberStatsRecord(dataset, resource.getName(), modifiedTimestamp, modifiedUser);
        }
        return null;
    }

    @Override
    public String getRecord() {
        return this.pdsDataset + SEMICOLON + this.member + SEMICOLON + this.modifiedTimestamp + SEMICOLON + this.modifiedUser;
    }
}

