/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.toolkit.manifest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GenerateRollbackManifest {
    private static final String CREATED_TAG = "created";
    private static final String DELETED_TAG = "deleted";
    private static final String UPDATED_TAG = "updated";
    private static final String TRANSIENT = "_tmp";
    private static final String CONTAINER_TAG = "container";
    private static final String RESOURCE_TAG = "resource";
    private static final String CHANGE_TYPE = "changeType";
    private static final String SIZE_TYPE = "size";
    private static final String LAST_MODIFIED_TIME_TYPE = "lastModifiedTimestamp";
    private static final String WORK_ITEM_NUMBER_TYPE = "workItemId";
    private static final String WORK_ITEM_UUID_TYPE = "workItemUUID";
    private static final String MISSING_ATTRIBUTE = "missing";
    private static final String MISSING_TRUE = "true";
    private static final String IBM_1047 = "IBM-1047";
    private static final String XML_TRANSFORMER_INDENT_YES = "yes";
    private final File outputManifest;
    private final String encoding;
    private final String lineSeparator;
    private final String indent;
    private final Document document;

    protected GenerateRollbackManifest(String inputManifestPath, String outputManifestPath, String encoding, String lineSeparator, String indent) throws Exception {
        this.outputManifest = new File(outputManifestPath);
        this.encoding = encoding;
        this.lineSeparator = lineSeparator;
        this.indent = indent;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setCoalescing(true);
        documentBuilderFactory.setIgnoringComments(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.parse(new File(inputManifestPath));
    }

    public GenerateRollbackManifest(String inputManifestPath, String outputManifestPath) throws Exception {
        this(inputManifestPath, outputManifestPath, IBM_1047, System.lineSeparator(), XML_TRANSFORMER_INDENT_YES);
    }

    public void generate() throws Exception {
        boolean ignoredResult = this.outputManifest.createNewFile();
        this.processCreatedTag();
        this.processDeletedTag();
        this.processUpdatedTag();
        this.processDeletedTransientTag();
        Transformer transformer = this.createTransformer();
        this.writeDocumentIntoOutputFile(transformer);
        this.convertOutputFileToZosEncoding();
    }

    private void processCreatedTag() {
        NodeList createdNodes = this.document.getElementsByTagName(CREATED_TAG);
        if (createdNodes.getLength() > 0) {
            this.renameTag(createdNodes, "deleted_tmp");
            NodeList childNodes = createdNodes.item(0).getChildNodes();
            this.removeChangeTypeAttributeFromContainers(childNodes);
            this.cleanupResourceAttributesOfContainers(childNodes);
        }
    }

    private void processDeletedTag() {
        NodeList deletedNodes = this.document.getElementsByTagName(DELETED_TAG);
        if (deletedNodes.getLength() > 0) {
            NodeList deletedChildNodes = deletedNodes.item(0).getChildNodes();
            this.removeMissingElements(deletedNodes, deletedChildNodes);
            deletedChildNodes = deletedNodes.item(0).getChildNodes();
            this.removeChangeTypeAttributeFromContainers(deletedChildNodes);
            this.cleanupResourceAttributesOfContainers(deletedChildNodes);
            this.renameTag(deletedNodes, CREATED_TAG);
        }
    }

    private void processUpdatedTag() {
        NodeList updatedNodes = this.document.getElementsByTagName(UPDATED_TAG);
        if (updatedNodes.getLength() > 0) {
            NodeList updatedChildNodes = updatedNodes.item(0).getChildNodes();
            this.removeChangeTypeAttributeFromContainers(updatedChildNodes);
            this.cleanupResourceAttributesOfContainers(updatedChildNodes);
        }
    }

    private void processDeletedTransientTag() {
        NodeList deletedTmpNodes = this.document.getElementsByTagName("deleted_tmp");
        if (deletedTmpNodes.getLength() > 0) {
            this.renameTag(deletedTmpNodes, DELETED_TAG);
        }
    }

    private void renameTag(NodeList deletedNodes, String createdTag) {
        this.document.renameNode(deletedNodes.item(0), null, createdTag);
    }

    private void removeChangeTypeAttributeFromContainers(NodeList childNodes) {
        for (int i = 0; i < childNodes.getLength(); ++i) {
            NamedNodeMap attributes;
            Node container = childNodes.item(i);
            if (!container.getNodeName().equals(CONTAINER_TAG) || (attributes = container.getAttributes()).getNamedItem(CHANGE_TYPE) == null) continue;
            attributes.removeNamedItem(CHANGE_TYPE);
        }
    }

    private void cleanupResourceAttributesOfContainers(NodeList childNodes) {
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node container = childNodes.item(i);
            if (!container.getNodeName().equals(CONTAINER_TAG)) continue;
            this.cleanUpAttributes(container);
        }
    }

    private void cleanUpAttributes(Node container) {
        NodeList resources = container.getChildNodes();
        for (int i = 0; i < resources.getLength(); ++i) {
            Node resource = resources.item(i);
            if (!resource.getNodeName().equals(RESOURCE_TAG)) continue;
            this.cleanUpAttributesOnResource(resource.getAttributes());
        }
    }

    private void cleanUpAttributesOnResource(NamedNodeMap attributes) {
        if (attributes.getNamedItem(SIZE_TYPE) != null) {
            attributes.removeNamedItem(SIZE_TYPE);
        }
        if (attributes.getNamedItem(LAST_MODIFIED_TIME_TYPE) != null) {
            attributes.removeNamedItem(LAST_MODIFIED_TIME_TYPE);
        }
        if (attributes.getNamedItem(WORK_ITEM_NUMBER_TYPE) != null) {
            attributes.removeNamedItem(WORK_ITEM_NUMBER_TYPE);
        }
        if (attributes.getNamedItem(WORK_ITEM_UUID_TYPE) != null) {
            attributes.removeNamedItem(WORK_ITEM_UUID_TYPE);
        }
    }

    private void removeMissingElements(NodeList deletedNodes, NodeList deletedChildNodes) {
        for (int i = 0; i < deletedChildNodes.getLength(); ++i) {
            Node container = deletedChildNodes.item(i);
            if (!container.getNodeName().equals(CONTAINER_TAG)) continue;
            this.processDeletedContainers(deletedNodes, container);
        }
    }

    private void processDeletedContainers(NodeList deletedNodes, Node container) {
        if (this.isMissing(container)) {
            deletedNodes.item(0).removeChild(container);
        } else {
            this.removeMissingResources(container);
        }
    }

    private void removeMissingResources(Node container) {
        NodeList resources = container.getChildNodes();
        for (int j = 0; j < resources.getLength(); ++j) {
            Node resource = resources.item(j);
            if (!resource.getNodeName().equals(RESOURCE_TAG) || !this.isMissing(resource)) continue;
            container.removeChild(resource);
        }
    }

    private boolean isMissing(Node node) {
        return node.getAttributes().getNamedItem(MISSING_ATTRIBUTE) != null && MISSING_TRUE.equals(node.getAttributes().getNamedItem(MISSING_ATTRIBUTE).getNodeValue());
    }

    private Transformer createTransformer() throws TransformerConfigurationException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("encoding", this.encoding);
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", this.indent);
        return transformer;
    }

    private void writeDocumentIntoOutputFile(Transformer transformer) throws TransformerFactoryConfigurationError, TransformerException {
        DOMSource source = new DOMSource(this.document);
        StreamResult result = new StreamResult(this.outputManifest);
        transformer.transform(source, result);
    }

    private void convertOutputFileToZosEncoding() throws IOException {
        File tempFile = new File(this.outputManifest.getAbsolutePath() + ".tmp");
        try (BufferedReader reader = new BufferedReader(new FileReader(this.outputManifest));
             PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(Files.newOutputStream(tempFile.getCanonicalFile().toPath(), new OpenOption[0]), this.encoding), true);){
            String line;
            while ((line = reader.readLine()) != null) {
                writer.print(line + this.lineSeparator);
            }
        }
        if (!this.outputManifest.delete()) {
            throw new RuntimeException(" [Error] Failed to delete file " + this.outputManifest.getCanonicalPath());
        }
        if (!tempFile.renameTo(this.outputManifest)) {
            throw new RuntimeException(" [Error] Failed to rename file " + tempFile.getCanonicalPath());
        }
    }
}

