/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.jcl.common;

import com.urbancode.air.plugin.inputs.InputsValidator;
import java.util.Properties;

public class JmonInputs {
    public static final String USERID = "userid";
    public static final String HOSTNAME = "hostname";
    public static final String PASSWORD = "password";
    public static final String PORT = "port";
    public static final String USE_PASSTICKET = "usePassticket";
    public static final String USE_RUN_ID = "useRunId";
    public static final String IRRRACF_LIBRARY_PATH = "irrracfLibraryPath";
    public static final String TIMEOUT = "timeout";
    public static final String SHOW_OUTPUT = "showOutput";
    public static final String CUT_OFF = "cutOff";
    public static final String MAX_RC = "maxRC";
    private final String hostname;
    private final String userid;
    private final String password;
    private final String port;
    private final String irrracfLibraryPath;
    private final AuthenticationMethod authenticationMethod;
    private final String timeout;
    private final String showOutput;
    private final String maxLines;
    private final String maxRC;

    private JmonInputs(Properties inputProperties) {
        this.hostname = inputProperties.getProperty(HOSTNAME).trim();
        this.userid = inputProperties.getProperty(USERID).trim().toUpperCase();
        this.password = inputProperties.getProperty(PASSWORD).trim();
        this.port = inputProperties.getProperty(PORT).trim();
        this.irrracfLibraryPath = inputProperties.getProperty(IRRRACF_LIBRARY_PATH).trim();
        boolean usePassTicket = Boolean.parseBoolean(inputProperties.getProperty(USE_PASSTICKET).trim());
        boolean useRunId = Boolean.parseBoolean(inputProperties.getProperty(USE_RUN_ID).trim());
        this.authenticationMethod = useRunId ? AuthenticationMethod.RUN_ID : (usePassTicket ? AuthenticationMethod.PASS_TICKET : AuthenticationMethod.PASSWORD);
        this.timeout = inputProperties.getProperty(TIMEOUT).trim();
        this.showOutput = inputProperties.getProperty(SHOW_OUTPUT).trim();
        this.maxLines = inputProperties.getProperty(CUT_OFF).trim();
        this.maxRC = inputProperties.getProperty(MAX_RC).trim();
    }

    public static JmonInputs getValidatedInputs(Properties inputProperties) {
        JmonInputs jmonInputs = new JmonInputs(inputProperties);
        jmonInputs.validate();
        return jmonInputs;
    }

    private void validate() {
        InputsValidator.checkIfEmpty(this.hostname, "Host Name");
        InputsValidator.checkIfEmpty(this.port, "Port");
        if (this.isUsePassword()) {
            InputsValidator.checkIfEmpty(this.userid, "User ID");
            InputsValidator.checkIfEmpty(this.password, "Password");
        }
        if (this.isUsePassTicket()) {
            InputsValidator.checkIfEmpty(this.userid, "User ID");
            InputsValidator.checkIfEmpty(this.irrracfLibraryPath, "IRRRacf Native Library Path");
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getUserid() {
        return this.userid;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPort() {
        return this.port;
    }

    public String getIrrracfLibraryPath() {
        return this.irrracfLibraryPath;
    }

    public boolean isUseRunId() {
        return this.authenticationMethod == AuthenticationMethod.RUN_ID;
    }

    public boolean isUsePassTicket() {
        return this.authenticationMethod == AuthenticationMethod.PASS_TICKET;
    }

    public boolean isUsePassword() {
        return this.authenticationMethod == AuthenticationMethod.PASSWORD;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public String getShowOutput() {
        return this.showOutput;
    }

    public String getMaxLines() {
        return this.maxLines;
    }

    public String getMaxRC() {
        return this.maxRC;
    }

    private static enum AuthenticationMethod {
        RUN_ID,
        PASSWORD,
        PASS_TICKET;

    }
}

