/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.generate.artifact.info;

import com.ibm.urbancode.zos.deploy.xml.utils.OrderBy;
import com.ibm.urbancode.zos.generate.artifact.info.LoopType;
import com.urbancode.air.plugin.exceptions.InvalidInputException;
import com.urbancode.air.plugin.inputs.InputsValidator;
import java.util.Properties;

class GenerateInfoInputs {
    public static final String LOOP_TYPE = "loopType";
    public static final String DEPLOY_TYPE_NAME = "deployTypeName";
    public static final String SRC_DATASET_NAME = "srcDatasetName";
    public static final String DATASET_NAME = "datasetName";
    public static final String MEMBER_NAME = "memberName";
    public static final String CUST_PROPERTIES = "custProperties";
    public static final String TEMPLATE_TEXT = "templateText";
    public static final String ORDER_BY = "orderBy";
    public static final String FAIL_ON_EMPTY = "failOnEmpty";
    public static final String IGNORE_UNRESOLVED = "ignoreUnresolved";
    public static final String DEPLOY_BASE_PATH = "deployBasePath";
    public static final String COMPONENT_NAME = "componentName";
    public static final String VERSION_NAME = "versionName";
    public static final String RESOURCE_ID = "resourceId";
    public static final String DEPLOY_ACTION = "deployAction";
    private static final String ESCAPED_NEW_LINE = "\\n";
    private static final String NEW_LINE = "\n";
    private final String deployBasePath;
    private final String componentName;
    private final String versionName;
    private final String resourceId;
    private final boolean failOnEmpty;
    private final LoopType loopType;
    private final String deployType;
    private final String sourceContainer;
    private String targetDataset;
    private final String resourceName;
    private final String customPropertyLines;
    private final String template;
    private final OrderBy orderBy;
    private final boolean ignoreUnresolved;
    private String deployAction;

    private GenerateInfoInputs(Properties inputProperties) {
        this.loopType = LoopType.valueOf((String)inputProperties.getProperty(LOOP_TYPE));
        this.deployType = inputProperties.getProperty(DEPLOY_TYPE_NAME).trim();
        this.sourceContainer = inputProperties.getProperty(SRC_DATASET_NAME).trim();
        this.targetDataset = inputProperties.getProperty(DATASET_NAME).trim();
        this.resourceName = inputProperties.getProperty(MEMBER_NAME).trim();
        this.customPropertyLines = inputProperties.getProperty(CUST_PROPERTIES).trim();
        String inputTemplate = inputProperties.getProperty(TEMPLATE_TEXT);
        this.template = inputTemplate.replace(ESCAPED_NEW_LINE, NEW_LINE);
        this.orderBy = OrderBy.valueOf((String)inputProperties.getProperty(ORDER_BY));
        this.failOnEmpty = Boolean.parseBoolean(inputProperties.getProperty(FAIL_ON_EMPTY));
        this.ignoreUnresolved = Boolean.parseBoolean(inputProperties.getProperty(IGNORE_UNRESOLVED));
        this.deployAction = inputProperties.getProperty(DEPLOY_ACTION).trim();
        this.deployBasePath = inputProperties.getProperty(DEPLOY_BASE_PATH).trim();
        this.componentName = inputProperties.getProperty(COMPONENT_NAME).trim();
        this.versionName = inputProperties.getProperty(VERSION_NAME).trim();
        this.resourceId = inputProperties.getProperty(RESOURCE_ID).trim();
    }

    public static GenerateInfoInputs getValidatedInputs(Properties inputProperties) {
        GenerateInfoInputs pluginInputs = new GenerateInfoInputs(inputProperties);
        pluginInputs.validateInputs();
        return pluginInputs;
    }

    private void validateInputs() {
        boolean isLoopTypeNeitherSequentialNorMember;
        InputsValidator.checkIfEmpty(this.componentName, "Component Name");
        InputsValidator.checkIfEmpty(this.deployBasePath, "Deploy Base Path");
        InputsValidator.checkIfEmpty(this.versionName, "Version Name");
        InputsValidator.checkIfEmpty(this.resourceId, "Resource Id");
        InputsValidator.checkIfEmpty(this.template.trim(), "Template");
        boolean bl = isLoopTypeNeitherSequentialNorMember = this.loopType != LoopType.Sequential && this.loopType != LoopType.Member;
        if (!this.deployAction.isEmpty() && isLoopTypeNeitherSequentialNorMember) {
            throw new InvalidInputException("Unsupported Loop Type '" + this.loopType + "' found with deployment action. Deployment Action is supported for Loop Types - 'Sequential' or 'PDS Member'");
        }
        if (!this.targetDataset.isEmpty() && !LoopType.isDatasetLevel((LoopType)this.loopType)) {
            throw new InvalidInputException("Target Dataset Filter is applicable for only dataset/member loop types.");
        }
    }

    public String getDeployBasePath() {
        return this.deployBasePath;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public boolean isFailOnEmpty() {
        return this.failOnEmpty;
    }

    public LoopType getLoopType() {
        return this.loopType;
    }

    public String getDeployType() {
        return this.deployType;
    }

    public String getSourceContainer() {
        return this.sourceContainer;
    }

    public String getTargetDataset() {
        return this.targetDataset;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getCustomPropertyLines() {
        return this.customPropertyLines;
    }

    public String getTemplate() {
        return this.template;
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public boolean isIgnoreUnresolved() {
        return this.ignoreUnresolved;
    }

    public String getDeployAction() {
        return this.deployAction;
    }

    public void ignoreTargetDataset() {
        this.targetDataset = "";
    }

    public void ignoreDeployAction() {
        this.deployAction = "";
    }
}

